/* mml-defs.c */

/*
 * Copyright (c) 1991-1993  R. Nigel Horspool.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#include <stdio.h>
#include <ctype.h>
#include <stdlib.h>

#include "tables.h"
#include "mml-defs.h"

#ifndef FPR
#define FPR		fprintf
#endif


static char *strip_angle_brackets( register char *cp ) {
    static char buffer[64];
    register char *dp;

    for( dp=buffer,cp++;  *cp != '>';  cp++ )
	*dp++ = *cp;
    *dp = '\0';
    return buffer;
}


void write_header( FILE *f ) {
    FPR(f, "<MML -- created by la_mml>\n" );
}


void write_defs( FILE *f, BOOL alldefs ) {
    CHARFORMAT *chfp;
    PARAFORMAT *pfp;
    char *cp;

    for( chfp = chfmttable;  chfp->name != NULL;  chfp++ ) {
	short int s;

	if (!alldefs && !chfp->used) continue;
	FPR(f, "<!DefineFont %s\n\t%s\n\t<pts %d>\n",
	    strip_angle_brackets(chfp->name), chfp->family, chfp->size);
	s = chfp->style;
	FPR(f, "    <Plain><Normal>");
	if (s != 0) {
	    if (s & ITALIC) FPR(f, "<Italic>");
	    if (s & BOLD) FPR(f, "<Bold>");
	    if (s & UNDERLINE) FPR(f, "<Underline>");
	    if (s & STRIKE) FPR(f, "<Strike>");
	    if (s & OBLIQUE) FPR(f, "<Oblique>");
	    if (s & SUBSCRIPT) FPR(f, "<Subscript>");
	    if (s & SUPERSCRIPT) FPR(f, "<Superscript>");
	}
	FPR(f, "\n>\n" );
    }
    for( pfp = paratable;  pfp->tagname != NULL;  pfp++ ) {
	if (!alldefs && !pfp->used) continue;
	FPR(f, "<!DefinePar %s\n\t%s\n",
	    strip_angle_brackets(pfp->tagname), pfp->font);
	FPR(f, "\t<Alignment %s>\n\t<LeftIndent %.2f\">\n",
	    pfp->alignment, pfp->left);
	FPR(f, "\t<FirstIndent %.2f\">\n\t<RightIndent %.2f\">\n",
	    pfp->first, pfp->right);
	FPR(f, "\t<Leading %dpt>\n\t<SpaceBefore %dpt>\n\t<SpaceAfter %dpt>\n",
	    pfp->leading, pfp->before, pfp->after);
	if (pfp->autoformat != NULL) {
	    FPR(f, "\t<Autonumber Yes>\n\t<NumberFormat \"%s\">\n", pfp->autoformat);
	} else
	    FPR(f, "\t<Autonumber No>\n");
	FPR(f, "\t<Hyphenate %s>\n", pfp->hyphenate? "Yes" : "No");
	if (pfp->tabstops != NULL) {
	    char *dp, buff[16];
	    short cnt = 0;  short change = 0;

	    FPR(f, "\t<TabStops " );	    
	    for( cp = pfp->tabstops; *cp != '\0';  cp++ ) {
		if (isspace(*cp)) continue;
		if (++cnt >= 5) {
		    FPR(f, "\n\t");  cnt = 1;
		}
		if (isalpha(*cp)) {
		    FPR(f, "<TabStopType %c>", *cp);
		    change = 1;
		    continue;
		}
		if (isdigit(*cp)) {
		    for( dp=buff;  *cp != '\0' && (isdigit(*cp) || *cp=='.'); )
			*dp++ = *cp++;
		    *dp = '\0';
		    FPR(f, "<TabStop %s\">", buff);
		    cp--;
		} else {
		    FPR(stderr, "bad character in tab settings string: %s\n",
			pfp->tabstops);
		    break;
		}
	    }
	    if (change) {
		FPR(f, "<TabStopType L>");
		change = 0;
	    }
	    FPR(f, ">\n" );
	}
	FPR(f, ">\n" );
    }
}

