/* tables.c */

/*
 * Copyright (c) 1991-1993  R. Nigel Horspool.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/


/* enable mapping of 8-bit characters in ISO-1 set */
#define ISO


/* tables of math characters and other funny symbols */

#include <stdio.h>
#include "tables.h"


/* Font families used in the mml version */
char TIMESFAMILY[]	= "<Family Times>";
char SYMBOLFAMILY[]	= "<Family Symbol>";
char COURIERFAMILY[]	= "<Family Courier>";
char HELVETICAFAMILY[]	= "<Family Helvetica>";

/* Abbreviated names for choosing fonts in mml */
char RM[] = "<rm>";
char TT[] = "<tt>";
char SY[] = "<sy>";
char BF[] = "<bf>";
char BI[] = "<bi>";
char EM[] = "<em>";
static char Ti[] = "<Ti>";
static char Au[] = "<Au>";
static char Ab[] = "<Ab>";
static char H0[] = "<H0>";
static char H1[] = "<H1>";
static char H2[] = "<H2>";
static char H3[] = "<H3>";
static char H4[] = "<H4>";
static char H5[] = "<H5>";
static char H6[] = "<H6>";
static char eq[] = "<eq>";
static char Pa[] = "<Pa>";
static char Hg[] = "<Huge>";
static char hg[] = "<huge>";
static char LA[] = "<LARGE>";
static char La[] = "<Large>";
static char la[] = "<large>";
static char ss[] = "<ss>";
static char et[] = "<et>";
static char sm[] = "<Small>";
static char fn[] = "<Footnote>";
static char sc[] = "<Script>";
static char tn[] = "<Tiny>";



/* Actions needed to map single characters */
ACTION special_chars[] = {
	{ "\n", "%n" },
	{ "\r", "%n" },
	{ "\f", "%n" },
	{ "&", "%?a%\b\\t" },
	{ "~", "\\x11  " },
	{ "_", "%?m%P<sc>%sL%p%f0" },
	{ "^", "%?m%P<sc>%sH%p%f0" },
	{ "{", "%(D){" },
	{ "}", "%(D)}" },
	{ "$", "%(D)$" },
	{ "[", "[" },
	{ "]", "%(D)]" },
	{ "`", "\\xd4 " },
	{ "'", "\\xd5 " },
#ifdef ISO
	{ "\xa1", "\\xc1 " },
	{ "\xa2", "\\xa2 " },
	{ "\xa3", "\\xa3 " },
	{ "\xa4", "\\xdb " },
	{ "\xa5", "\\xb4 " },
	{ "\xa6", "\\x7c " },
	{ "\xa7", "\\xa4 " },
	{ "\xa8", "\\xac " },
	{ "\xa9", "\\xa9 " },
	{ "\xaa", "\\xbb " },
	{ "\xab", "\\xc7 " },
	{ "\xac", "\\xc2 " },
	{ "\xad", "\\xd0 " },
	{ "\xae", "\\xa8 " },
	{ "\xaf", "\\xf8 " },
	{ "\xb0", "\\xa1 " },
	{ "\xb1", "\\xc0 " },
	{ "\xb2", "\\x32 " },
	{ "\xb3", "\\x33 " },
	{ "\xb4", "\\xab " },
	{ "\xb5", "\\x75 " },
	{ "\xb6", "\\xa6 " },
	{ "\xb7", "\\xa5 " },
	{ "\xb8", "\\xfc " },
	{ "\xb9", "\\x31 " },
	{ "\xba", "\\xbc " },
	{ "\xbb", "\\xc8 " },
	{ "\xbc", "\\xc0 " },
	{ "\xbd", "\\xc0 " },
	{ "\xbe", "\\xc0 " },
	{ "\xbf", "\\xc0 " },
	{ "\xc0", "\\xcb " },
	{ "\xc1", "\\xe7 " },
	{ "\xc2", "\\xe5 " },
	{ "\xc3", "\\xcc " },
	{ "\xc4", "\\x80 " },
	{ "\xc5", "\\x81 " },
	{ "\xc6", "\\xae " },
	{ "\xc7", "\\x82 " },
	{ "\xc8", "\\xe9 " },
	{ "\xc9", "\\x83 " },
	{ "\xca", "\\xe6 " },
	{ "\xcb", "\\xe8 " },
	{ "\xcc", "\\xed " },
	{ "\xcd", "\\xea " },
	{ "\xce", "\\xeb " },
	{ "\xcf", "\\xec " },
	{ "\xd0", "\\x44 " },
	{ "\xd1", "\\x84 " },
	{ "\xd2", "\\xf1 " },
	{ "\xd3", "\\xee " },
	{ "\xd4", "\\xef " },
	{ "\xd5", "\\x9b " },
	{ "\xd6", "\\x85 " },
	{ "\xd7", "\\x78 " },
	{ "\xd8", "\\xaf " },
	{ "\xd9", "\\xf4 " },
	{ "\xda", "\\xf2 " },
	{ "\xdb", "\\xf3 " },
	{ "\xdc", "\\x86 " },
	{ "\xdd", "\\x59 " },
	{ "\xde", "\\x50 " },
	{ "\xdf", "\\xa7 " },
	{ "\xe0", "\\x88 " },
	{ "\xe1", "\\x87 " },
	{ "\xe2", "\\x89 " },
	{ "\xe3", "\\x8b " },
	{ "\xe4", "\\x8a " },
	{ "\xe5", "\\x8c " },
	{ "\xe6", "\\xbe " },
	{ "\xe7", "\\x8d " },
	{ "\xe8", "\\x8f " },
	{ "\xe9", "\\x8e " },
	{ "\xea", "\\x90 " },
	{ "\xeb", "\\x91 " },
	{ "\xec", "\\x93 " },
	{ "\xed", "\\x92 " },
	{ "\xee", "\\x94 " },
	{ "\xef", "\\x95 " },
	{ "\xf0", "\\xb6 " },
	{ "\xf1", "\\x96 " },
	{ "\xf2", "\\x98 " },
	{ "\xf3", "\\x97 " },
	{ "\xf4", "\\x99 " },
	{ "\xf5", "\\x9b " },
	{ "\xf6", "\\x9a " },
	{ "\xf7", "\\xd6 " },
	{ "\xf8", "\\xbf " },
	{ "\xf9", "\\x9d " },
	{ "\xfa", "\\x9c " },
	{ "\xfb", "\\x9e " },
	{ "\xfc", "\\x9f " },
	{ "\xfd", "\\x79 " },
	{ "\xfe", "\\x70 " },
	{ "\xff", "\\xd8 " },
#endif
	{ NULL, NULL }
};


/* Actions needed to map \x commands, where x is not a letter */
ACTION slash_chars[] = {
	{ "\\>", "%?a%\b\\t%!" },
	{ "\\\\", "%*%o%n%&" },
	{ "\\(", "%(D)\\(" },
	{ "\\)", "%(D)\\)" },
	{ "\\[", "%(D)\\[" },
	{ "\\]", "%(D)\\]" },
	{ "\\ ", " " },
	{ "\\@", " " },
	{ "\\!", "%\b" },
	{ "\\,", "\\x12 " },
	{ "\\:", "\\x13 " },
	{ "\\;", "\\x14 " },
	{ "\\<", "%!" },
	{ "\\+", "%!" },
	{ "\\-", "%!" },

	{ "\\`", "%(A)`" },	/* Accent commands (from table 3.1) */
	{ "\\'", "%(A)'" },
	{ "\\^", "%(A)^" },
	{ "\\\"", "%(A)\"" },
	{ "\\~", "%(A)~" },
	{ "\\=", "%(A)=" },
	{ "\\.", "%(A)." },

	{ NULL, NULL }
};

/* KJT 29/03/08: "eof" renamaed "endoffile" to avoid MingW clash */

ACTION dollardollar	= { "$$", "%(D)$$" };
ACTION endoffile	= { "EOF", "%(D)E" };
ACTION dashdash		= { "--", "%fT\\xd0 %f0" };
ACTION dashdashdash	= { "---", "%fT\\xd1 %f0" };
ACTION leftdquote	= { "``", "%fT\\xd2 %f0" };
ACTION rightdquote	= { "''", "%fT\\xd3 %f0" };

ACTION other		= { "", "%b" };

ACTION untranslated	= { "", "%fT%b%f0 " };


/*  Accented characters available in Times family fonts */

/* KJT 29/03/08:
     o last (sentinel) field fully initialised
*/

ACTION accent_tab[] = {
	{ "A\"", "\\x80 " },		{ "A.", "\\x81 " },
	{ "Cc", "\\x82 " },		{ "E'", "\\x83 " },
	{ "N~", "\\x84 " },		{ "O\"", "\\x85 " },
	{ "U\"", "\\x86 " },		{ "a'", "\\x87 " },
	{ "a`", "\\x88 " },		{ "a^", "\\x89 " },
	{ "a\"", "\\x8a " },		{ "a~", "\\x8b " },
	{ "a.", "\\x8c " },		{ "cc", "\\x8d " },
	{ "e'", "\\x8e " },		{ "e`", "\\x8f " },
	{ "e^", "\\x90 " },		{ "e\"", "\\x91 " },
	{ "i'", "\\x92 " },		{ "i`", "\\x93 " },
	{ "i^", "\\x94 " },		{ "i\"", "\\x95 " },
	{ "n~", "\\x96 " },		{ "o'", "\\x97 " },
	{ "o`", "\\x98 " },		{ "o^", "\\x99 " },
	{ "o\"", "\\x9a " },		{ "o~", "\\x9b " },
	{ "u'", "\\x9c " },		{ "u`", "\\x9d " },
	{ "u^", "\\x9e " },		{ "u\"", "\\x9f " },
	{ "A`", "\\xcb " },		{ "A~", "\\xcc " },
	{ "O~", "\\xcd " },
	{ "y\"", "\\xd8 " },		{ "Y\"", "\\xd9 " },
	{ "A^", "\\xe5 " },		{ "E^", "\\xe6 " },
	{ "A'", "\\xe7 " },		{ "E\"", "\\xe8 " },
	{ "E`", "\\xe9 " },		{ "I'", "\\xea " },
	{ "I^", "\\xeb " },		{ "I\"", "\\xec " },
	{ "I`", "\\xed " },		{ "O'", "\\xee " },
	{ "O^", "\\xef " },
	{ "O`", "\\xf1 " },		{ "U'", "\\xf2 " },
	{ "U^", "\\xf3 " },		{ "U`", "\\xf4 " },
	{ NULL, NULL }					/* terminator record */
};


ACTION commands[] = {

    /* Math mode commands with no arguments */

	/* Table 3.3 of the LaTeX book */
	{"\\alpha", "%fS\\x61 %f0"},	{"\\beta", "%fS\\x62 %f0"},
	{"\\gamma", "%fS\\x67 %f0"},	{"\\delta", "%fS\\x64 %f0"},
	{"\\epsilon", "%fS\\x65 %f0"},	{"\\varepsilon", "%fS\\x65 %f0"},
	{"\\zeta", "%fS\\x7a %f0"},	{"\\eta", "%fS\\x68 %f0"},
	{"\\theta", "%fS\\x71 %f0"},	{"\\vartheta", "%fS\\x4a %f0"},
	{"\\iota", "%fS\\x69 %f0"},	{"\\kappa", "%fS\\x6b %f0"},
	{"\\lambda", "%fS\\x6c %f0"},	{"\\mu", "%fS\\x6d %f0"},
	{"\\nu", "%fS\\x6e %f0"},	{"\\xi", "%fS\\x78 %f0"},
	{"\\pi", "%fS\\x70 %f0"},	{"\\varpi", "%fS\\x70 %f0"},
	{"\\rho", "%fS\\x72 %f0"},	{"\\varrho", "%fS\\x72 %f0"},
	{"\\sigma", "%fS\\x73 %f0"},	{"\\varsigma", "%fS\\x56 %f0"},
	{"\\tau", "%fS\\x74 %f0"},	{"\\upsilon", "%fS\\x75 %f0"},
	{"\\phi", "%fS\\x66 %f0"},	{"\\varphi", "%fS\\x6a %f0"},
	{"\\chi", "%fS\\x63 %f0"},	{"\\psi", "%fS\\x79 %f0"},
	{"\\omega", "%fS\\x77 %f0"},	{"\\Gamma", "%fS\\x47 %f0"},
	{"\\Delta", "%fS\\x44 %f0"},	{"\\Theta", "%fS\\x4a %f0"},
	{"\\Lambda", "%fS\\x4c %f0"},	{"\\Xi", "%fS\\x58 %f0"},
	{"\\Pi", "%fS\\x50 %f0"},	{"\\Sigma", "%fS\\x53 %f0"},
	{"\\Upsilon", "%fS\\x55 %f0"},	{"\\Phi", "%fS\\x46 %f0"},
	{"\\Psi", "%fS\\x59 %f0"},	{"\\Omega", "%fS\\x57 %f0"},

	/* Table 3.4 */
	{"\\pm", "%fS\\xb1 %f0"},
	{"\\times", "%fS\\xb4 %f0"},	{"\\div", "%fS\\xb8 %f0"},
	{"\\ast", "%fS\\x2a %f0"},	{"\\star", "%fS\\x2a %f0"},
	{"\\bullet", "%fS\\xb7 %f0"},	{"\\cdot", "%fS\\d7 %f0"},
	{"\\cap", "%fS\\xc7 %f0"},	{"\\cup", "%fS\\xc8 %f0"},
	{"\\vee", "%fS\\xda %f0"},	{"\\wedge", "%fS\\xd9 %f0"},
	{"\\setminus", "%fT\\%f0"},	{"\\diamond", "%fS\\xe0 %f0"},
	{"\\oplus", "%fS\\xc5 %f0"},	{"\\otimes", "%fS\\xc4 %f0"},
	{"\\dagger", "%fT\\xa0 %f0"},	{"\\ddagger", "%fT\\xe0 %f0"},

	/* No translations for these characters/commands
	{"\\mp", NULL},			{"\\circ", NULL},
	{"\\uplus", NULL},
	{"\\sqcap", NULL},		{"\\sqcup", NULL},
	{"\\wr", NULL},
	{"\\bigtriangleup", NULL},	{"\\bigtriangledown", NULL},
	{"\\triangleleft", NULL},	{"\\triangleright", NULL},
	{"\\lhd", NULL},		{"\\rhd", NULL},
	{"\\unlhd", NULL},		{"\\unrhd", NULL},
	{"\\ominus", NULL},		{"\\oslash", NULL},
	{"\\odot", NULL},		{"\\bigcirc", NULL},
	{"\\amalg", NULL},
	*/

	/* Table 3.5 */
	{"\\leq", "%fS\\xa3 %f0"},	{"\\subset", "%fS\\xcc %f0"},
	{"\\subseteq", "%fS\\xcd %f0"},	{"\\sqsubset", "%fS\\xcc %f0"},
	{"\\sqsubseteq", "%fS\\xcd %f0"},{"\\in", "%fS\\xce %f0"},
	{"\\geq", "%fS\\xb3 %f0"},	{"\\supset", "%fS\\xc9 %f0"},
	{"\\supseteq", "%fS\\xca %f0"},	{"\\sqsupset", "%fS\\xc9 %f0"},
	{"\\sqsupseteq", "%fS\\xca %f0"},{"\\ni", "%fS\\x27 %f0"},
	{"\\approx", "%fS\\xbb %f0"},	{"\\cong", "%fS\\x40 %f0"},
	{"\\neq", "%fS\\xb9 %f0"},	{"\\propto", "%fS\\xb5 %f0"},

	/* No translations for these characters/commands
	{"\\prec", NULL},		{"\\preceq", NULL},
	{"\\ll", NULL},			{"\\vdash", NULL},
	{"\\succ", NULL},		{"\\succeq", NULL},
	{"\\gg", NULL},			{"\\dashv", NULL},
	{"\\equiv", NULL},		{"\\sim", NULL},
	{"\\simeq", NULL},		{"\\asymp", NULL},
	{"\\doteq", NULL},		{"\\models", NULL},
	{"\\perp", NULL},		{"\\mid", NULL},
	{"\\parallel", NULL},		{"\\bowtie", NULL},
	{"\\Join", NULL},		{"\\smile", NULL},
	{"\\frown", NULL},
	*/

	/* Table 3.6 -- we map some different sizes to same character */
	{"\\leftarrow", "%fS\\xac %f0"},
	{"\\Leftarrow", "%fS\\xdc %f0"},
	{"\\longleftarrow", "%fS\\xac %f0"},
	{"\\Longleftarrow", "%fS\\xdc %f0"},
	{"\\rightarrow", "%fS\\xae %f0"},
	{"\\Rightarrow", "%fS\\xde %f0"},
	{"\\longrightarrow", "%fS\\xae %f0"},
	{"\\Longrightarrow", "%fS\\xde %f0"},
	{"\\leftrightarrow", "%fS\\xab %f0"},
	{"\\Leftrightarrow", "%fS\\xdb %f0"},
	{"\\longleftrightarrow", "%fS\\xab %f0"},
	{"\\Longleftrightarrow", "%fS\\xdb %f0"},
	{"\\uparrow", "%fS\\xad %f0"},
	{"\\Uparrow", "%fS\\xdd %f0"},
	{"\\downarrow", "%fS\\xaf %f0"},
	{"\\Downarrow", "%fS\\xdf %f0"},

	/* No translations for these characters/commands
	{"\\mapsto", NULL},		{"\\hookleftarrow", NULL},
	{"\\leftharpoonup", NULL},	{"\\leftharpoondown", NULL},
	{"\\rightleftharpoons", NULL},
	{"\\longmapsto", NULL},
	{"\\hookrightarrow", NULL},	{"\\rightharpoonup", NULL},
	{"\\rightharpoondown", NULL},	{"\\leadsto", NULL},
	{"\\updownarrow", NULL},	{"\\Updownarrow", NULL},
	{"\\nearrow", NULL},		{"\\searrow", NULL},
	{"\\swarrow", NULL},		{"\\nwarrow", NULL},
	*/

	/* Table 3.7 */
	{"\\aleph", "%fS\\xc0 %f0"},	{"\\imath", "%fT\\xf5 %f0"},
	{"\\Re", "%fS\\xc2 %f0"},	{"\\Im", "%fS\\xc1 %f0"},
	{"\\emptyset", "%fS\\xc6 %f0"},	{"\\nabla", "%fS\\xd1 %f0"},
	{"\\bot", "%fS\\x5e %f0"},	{"\\angle", "%fS\\xd0 %f0"},
	{"\\forall", "%fS\\x22 %f0"},	{"\\exists", "%fS\\x24 %f0"},
	{"\\neg", "%fS\\xd8 %f0"},	{"\\backslash", "%fT\\%f0"},
	{"\\partial", "%fS\\xb6 %f0"},	{"\\infty", "%fS\\xa5 %f0"},
	{"\\Diamond", "%fS\\xe0 %f0"},	{"\\clubsuit", "%fS\\xa7 %f0"},
	{"\\diamondsuit", "%fS\\xa8 %f0"},{"\\heartsuit", "%fS\\xa9 %f0"},
	{"\\spadesuit", "%fS\\xaa %f0"},	{"\\jmath", "%fT%=pj%@%f0"},

	/* No translations for these characters/commands
	{"\\hbar", NULL},
	{"\\ell", NULL},		{"\\wp", NULL},
	{"\\mho", NULL},		{"\\prime", NULL},
	{"\\surd", NULL},		{"\\top", NULL},
	{"\\flat", NULL},		{"\\natural", NULL},
	{"\\sharp", NULL},		{"\\Box", NULL},
	{"\\triangle", NULL},
	*/

	/* Table 3.8 */
	{"\\sum", "%fS\\xe5 %f0"},	{"\\prod", "%fS\\xd5  %f0"},
	{"\\int", "%fS\\xf2 %f0"},

	/* No translations for these characters/commands
	{"\\coprod", NULL},
	{"\\oint", NULL},		{"\\bigcap", NULL},
	{"\\bigcup", NULL},		{"\\bigsqcup", NULL},
	{"\\bigvee", NULL},		{"\\bigwedge", NULL},
	{"\\bigodot", NULL},		{"\\bigotimes", NULL},
	{"\\bigoplus", NULL},		{"\\biguplus", NULL},
	*/

	/* Table 3.9 */
	{"\\arccos", "%fT%=parccos%@%f0"},	{"\\arcsin", "%fT%=parcsin%@%f0"},
	{"\\arctan", "%fT%=parctan%@%f0"},	{"\\arg", "%fT%=parg%@%f0"},
	{"\\cos", "%fT%=pcos%@%f0"},		{"\\cosh", "%fT%=pcosh%@%f0"},
	{"\\cot", "%fT%=pcot%@%f0"},		{"\\coth", "%fT%=pcoth%@%f0"},
	{"\\gcd", "%fT%=pgcd%@%f0"},		{"\\ln", "%fT%=pln%@%f0"},
	{"\\log", "%fT%=plog%@%f0"},		{"\\max", "%fT%=pmax%@%f0"},
	{"\\min", "%fT%=pmin%@%f0"},
	{"\\sec", "%fT%=psec%@%f0"},		{"\\sin", "%fT%=psin%@%f0"},
	{"\\sinh", "%fT%=psinh%@%f0"},		{"\\sup", "%fT%=psup%@%f0"},
	{"\\tan", "%fT%=ptan%@%f0"},		{"\\tanh", "%fT%=ptanh%@%f0"},

	/* No translations for these characters/commands
	{"\\csc", NULL},		{"\\deg", NULL},
	{"\\det", NULL},		{"\\dim", NULL},
	{"\\exp", NULL},		{"\\hom", NULL},
	{"\\inf", NULL},		{"\\ker", NULL},
	{"\\lg", NULL},			{"\\lim", NULL},
	{"\\liminf", NULL},		{"\\limsup", NULL},
	{"\\Pr", NULL},
	*/

	/* Table 3.10 */

	/* No translations for these characters/commands
	{"\\lfloor", NULL},		{"\\lceil", NULL},
	{"\\langle", NULL},		{"\\rfloor", NULL},
	{"\\rceil", NULL},		{"\\rangle", NULL},
	*/

	/* German/French quote mark characters */

	{"\\glqq", "%fT\\xe3 %f0% "},	{"\\grqq", "%fT\\xd2 %f0"},
	{"\\glq", "%fT\\xe2 %f0% "},	{"\\grq", "%fT\\xd4 %f0"},
	{"\\flqq", "%fT\\xc7 %f0% "},	{"\\frqq", "%fT\\xc8 %f0"},
	{"\\flq", "%fT\\xdc %f0% "},	{"\\frq", "%fT\\xdd %f0"},

	/* Miscellaneous */

	{"\\ldots", "..."},		{"\\bmod", "%fI mod %f0"},
	{"\\left", ""},			{"\\right", ""},

	/* No translations for these characters/commands
	{"\\nonumber", NULL},		{"\\cdots", NULL},
	{"\\vdots", NULL},		{"\\ddots", NULL},
	{"\\bmod", NULL},		{"\\cal", NULL},
	{"\\displaystyle", NULL},	{"\\textstyle", NULL},
	{"\\scriptstyle", NULL},	{"\\scriptscriptstyle", NULL},
	*/

    /* Math commands with one argument */

	/* Table 3.11 */

	/* No translations for these characters/commands
	{"\\hat", NULL},		{"\\check", NULL},
	{"\\breve", NULL},		{"\\acute", NULL},
	{"\\grave", NULL},		{"\\tilde", NULL},
	{"\\bar", NULL},		{"\\vec", NULL},
	{"\\dot", NULL},		{"\\ddot", NULL},
	*/

	/* Miscellaneous */
	{"\\sqrt", "%fS\\xd6 %f0"},
	{ "\\underline", "%sU%p%sP" },
	{"\\pmod", " %fT(%=pmod%@ %p)%f0 "},
	{"\\lefteqn", "%p" },

	/* No translations for these characters/commands
	{"\\overline", NULL},
	{"\\overbrace", NULL},		{"\\underbrace", NULL},
	{"\\widehat", NULL},		{"\\widetilde", NULL},
	*/

    /* Math mode commands with two arguments */

	/* No translations for these characters/commands
	{"\\frac", NULL},		{"\\stackrel", NULL},
	*/


    /* Other commands ... */

	/* No translations for these characters/commands
	{"\\boldmath", NULL},		{"\\unboldmath", NULL},
	*/

    /* Accent command in tabbing environment */

	{ "\a", "%(A)?" },

	/* Table 3.1 -- more accent commands */

	{ "\\u", "%(A)u" },		{ "\\v", "%(A)v" },
	{ "\\H", "%(A)H" },		{ "\\t", "%(A)t" },
	{ "\\c", "%(A)c" },		{ "\\d", "%(A)d" },
	{ "\\b", "%(A)b" },

	/* Table 3.2 */

	{ "\\oe", "%fT\\xcf %f0" },	{ "\\OE", "%fT\\xce %f0" },
	{ "\\ae", "%fT\\xbe %f0" },	{ "\\AE", "%fT\\xae %f0" },
	{ "\\o",  "%fT\\xbf %f0" },	{ "\\O",  "%fT\xaf %f0" },
	{ "\\aa", "%fT\\x8c %f0" },	{ "\\AA", "%fT\\x81 %f0" },
	{ "\\ss", "%fT\\xa7 %f0" },

	/* No translations for these characters/commands
	{"\\l", NULL},			{"\\L", NULL},
	*/

	{ "\\addcontentsline", "%p%p%p" },
	{ "\\address", "%(E)<*address>" },
	{ "\\addtocontents", "%p%p" },
	{ "\\addtocounter", "%x%x" },
	{ "\\addvspace", "%x" },
	{ "\\alph", "%x"},
	{ "\\Alph", "%x"},
	{ "\\appendix", "%(X)" },
	{ "\\arabic", "%x"},
	{ "\\author", "%(E)<*author>" },
	{ "\\begin", "%(E)" },
	{ "\\bf", "% %fB" },
	{ "\\bibitem", "%<HangIndent>%o[%p]\\t% " },
	{ "\\bibliography", "%x" },
	{ "\\bigskip", "%n%n% " },
	{ "\\cal", "" },
	{ "\\caption", "%o%(C)" },
	{ "\\cc", "%n%p%n" },
	{ "\\chapter", "%o%<M1Heading>%p%<B1Text>" },
	{ "\\chapter*", "%<U1Heading>%p%<B1Text>" },
	{ "\\cite", "%o%fT%=pcite{%p}%f0%@" },
	{ "\\clearpage", "%n%n% " },
	{ "\\cleardoublepage", "%n%n% " },
	{ "\\cline", "%x" },
	{ "\\closing", "%(E)<*closing>" },
	{ "\\copyright", "%fT\xa9 %f0" },
	{ "\\dag", "%fT\\xa0 %f0" },
	{ "\\date", "%-%n%p%n%+" },
	{ "\\ddag", "%fT\\xe0 %f0" },
	{ "\\def", "%(F)\\def" },
	/* KJT 04/05/97: added LaTeX2e command */
	{ "\\documentclass", "%+%(Z)" },
	{ "\\documentstyle", "%+%(Z)" },
	{ "\\em", "% %fI" },
	{ "\\encl", "%n%p%n" },
	{ "\\end", "%(D)e" },
	{ "\\fbox", "%=p%fT%p%f0%@" },
	{ "\\fnsymbol", "%x"},
	{ "\\footnote", "%o %fT%=p[Footnote: %p]%f0%@ " },
	{ "\\footnotemark", "%o" },
	{ "\\footnotesize", "%P<Footnote>" },
	{ "\\footnotetext", "%o %fT%=p[Footnote: %p]%f0%@ " },
	{ "\\framebox", "%o%o%fT%=p%p%f0%@" },
	{ "\\frenchspacing", "% " },
	{ "\\fussy", "% " },
	{ "\\hbox", "%=p%fT%p%f0%@" },
	{ "\\hline", "" },
	{ "\\hspace", "%*%x " },
	{ "\\huge", "%P<huge>"},
	{ "\\Huge", "%P<Huge>"},
	{ "\\hyphenation", "%x" },
	{ "\\i", "%fT\\xf5 %f0"},
	{ "\\include", "%(R)c" },
	{ "\\index",   "%(B)  " },
	{ "\\indexa",  "%(B)a " },
	{ "\\indexb",  "%(B) b" },
	{ "\\indexi",  "%(B) i" },
	{ "\\indexc",  "%(B)c " },
	{ "\\indexcb", "%(B)cb" },
	{ "\\indexci", "%(B)ci" },
	{ "\\indexe",  "%(B)e " },
	{ "\\indexeb", "%(B)eb" },
	{ "\\indexei", "%(B)ei" },
	{ "\\indexm",  "%(B)m " },
	{ "\\indexmb", "%(B)mb" },
	{ "\\indexmi", "%(B)mi" },
	{ "\\indexn",  "%(B)n " },
	{ "\\indexs",  "%(B)s " },
	{ "\\indent", "% \\t" },
	{ "\\input", "%(R)p" },
	{ "\\it", "% %fI" },
	{ "\\item", "%(I)%n" },
	{ "\\j", "%fT%=pj%@%f0"},
	{ "\\kill", "%X%!% " },
	{ "\\label", "%x" },
	{ "\\large", "%P<large>"},
	{ "\\Large", "%P<Large>"},
	{ "\\LARGE", "%P<LARGE>"},
	{ "\\LaTeX", "%fTL%sHA%sNT%sLE%sNX%f0" },
	{ "\\linebreak", "%o" },
	{ "\\linethickness", "%x" },
	{ "\\makebox", "%o%o%fT%=p%p%f0%@" },
	{ "\\maketitle", "%I1%n%I2%n% " },
	{ "\\marginpar", "%o%<Extract>%p%n%T" },
	{ "\\markboth", "%x%x" },
	{ "\\markright", "%x" },
	{ "\\mbox", "%=p%fT%p%f0%@" },
	{ "\\medskip", "%n%n% " },
	{ "\\minipage", "%o%x%fT%=p%p%f0%@" },
	{ "\\mit", "" },
	{ "\\multicolumn", "%x%x%p" },
	{ "\\newcommand", "%?p%z%o%(N)1" },
	{ "\\newcounter", "%x%o" },
	{ "\\newenvironment", "%z%o%(N)2" },
	{ "\\newfont", "%x%x" },
	{ "\\newline", "%n% " },
	{ "\\newpage", "%n%n% " },
	{ "\\newsavebox", "%x" },
	{ "\\nocite", "% " },
	{ "\\nofrenchspacing", "% " },
	{ "\\noindent", "%<B1Text>" },
	{ "\\nolinebreak", "%o" },
	{ "\\nopagebreak", "%o" },
	{ "\\normalsize", "%P<rm>" },
	{ "\\opening",
	"%I1%n%n%<FlushR><SpaceBefore 12pt>%#%n%I3%n%<B1Text><SpaceBefore 24pt>%p%n%T" },
	{ "\\onecolumn", "%n%n% " },
	{ "\\P", "%fT\\xa6 " },
	{ "\\pagebreak", "%o%n%<B1Text><ColumnTop Yes>\\x11 %n" },
	{ "\\pagenumbering", "%x" },
	{ "\\pageref", " %fT%=p[Pageref: %p]%f0%@" },
	{ "\\pagestyle", "%x" },
	{ "\\par", "%n%n" },
	{ "\\paragraph", "%o%<M5Heading>%p%<B1Text>" },
	{ "\\paragraph*", "%<U5Heading>%p%<B1Text>" },
	{ "\\parbox", "%o%x%fT%=p%p%f0%@" },
	{ "\\part", "\n\n%o%<Part>%p%<B1Text>" },
	{ "\\part*", "\n\n%<UPart>%p%<B1Text>" },
	{ "\\poptabs", "%!% " },
	{ "\\pounds", "%fT\\xa3 %f0" },
	{ "\\protect", "" },
	{ "\\ps", "%n" },
	{ "\\pushtabs", "%!% " },
	{ "\\raisebox", "%x%o%o%=p%p%@" },
	{ "\\ref", " %fT%=p[Ref: %p]%f0%@ " },
	{ "\\refstepcounter", "%x"},
	{ "\\renewcommand", "%?p%x%o%(N)1" },
	{ "\\renewenvironment", "%x%o%(N)2" },
	{ "\\rm", "% %fT" },
	{ "\\roman", "%x"},
	{ "\\Roman", "%x"},
	{ "\\S", "%fT\\xa4 %f0" },
	{ "\\samepage", "% " },
	{ "\\savebox", "%x%o%o%x" },
	{ "\\sbox", "%x%x" },
	{ "\\sc", "% %fV" },		/* small caps is hard to simulate */
	{ "\\scriptsize", "%P<Script>"},
	{ "\\section", "%o%<M2Heading>%p%<B1Text>" },
	{ "\\section*", "%<U2Heading>%p%<B1Text>" },
	{ "\\setcounter", "%x%x" },
	{ "\\sf", "% %fV" },
	{ "\\signature", "%(E)<*signature>" },
	{ "\\sl", "% %fA" },
	{ "\\sloppy", "% " },
	{ "\\small", "%P<Small>" },
	{ "\\smallskip", "%n%n% " },
	{ "\\stepcounter", "%x"},
	{ "\\subparagraph", "%o%<M6Heading>%p%<B1Text>" },
	{ "\\subparagraph*", "%<M6Heading>%p%<B1Text>" },
	{ "\\subsection", "%o%<M3Heading>%p%<B1Text>" },
	{ "\\subsection*", "%<U3Heading>%p%<B1Text>" },
	{ "\\subsubsection", "%o%<M4Heading>%p%<B1Text>" },
	{ "\\subsubsection*", "%<U4Heading>%p%<B1Text>" },
	{ "\\TeX", "%fTT%sLE%sNX%f0" },
	{ "\\thanks", "%- %fT%=p[Footnote: %p]%f0%@ %+" },
	{ "\\thicklines", "% " },
	{ "\\thinlines", "% " },
	{ "\\thispagestyle", "%x" },
	{ "\\tiny", "%P<Tiny>" },
	{ "\\title", "%(E)<*title>" },
	{ "\\tt", "% %fC" },
	{ "\\twocolumn", "%o%n%n" },
	{ "\\typein", "%o%x" },
	{ "\\typeout", "%x" },
	/* KJT 04/05/97: added LaTeX2e command */
	{ "\\usepackage", "%o%x" },
	{ "\\value", "%x"},
	{ "\\verb", "%(V)" },
	{ "\\vspace", "%*%(S)" },

	{ NULL, NULL }	/* final terminator value */
};


ENV bad_env = { "?", "%T", "%n", "<B2Text>", ' ', 'H', PARA };



/* List of all environments described in Appendix C of LaTeX Manual */
ENV environments[] = {
	{ "abstract", "%<Center><SpaceBefore 20pt>%fBAbstract%f0%n%T",
			"%n", "<AText>", 'N', 'H', PARA },
	{ "*address", "%-%D1%T", "%n%D0%+", "<FlushR>", 'N', 'P', PARA },
	{ "array", "%o%x%T", "%n", "<Equation>", ' ', 'P', MATHARRAY },
	{ "*author", "%-%D2%T", "%n%D0%+", "<Author>", 'N', 'P', PARA },
	{ "center", "%T", "%n", "<Center>",  'N', 'P', PARA },
	{ "*closing", "%n%T", "\n\n\n\n%T%I2%n", "<FlushL>", 'N', 'P', PARA },
	{ "description", "%T%(L)+", "%<LT>\\t%n%(L)-", "<LM1>", 'N', 'H', PARA },
	{ "displaymath", "%T", "%n", "<Equation>", ' ', 'P', MATH },
	{ "document", "%-%T", "%n%I9%+", "<B2Text>", 'N', 'H', PARA },
	{ "enumerate",  "%T%(L)+", "%<LT>\\t%n%(L)-", "<LM1>", 'N', 'H', PARA },
	{ "equation", "%T", "%n", "<Equation>", ' ', 'P', MATH },
	{ "eqnarray", "%T", "%n", "<Equation>", ' ', 'P', MATHARRAY },
	{ "eqnarray*", "%T", "%n", "<Equation>", ' ', 'P', MATHARRAY },
	{ "figure", "%o%n%D9<SpaceBefore 36pt>\\x11 %n",
			"%n%D0%I9", "<B1Text>", ' ', 'P', PARA },
	{ "figure*", "%o%n%D9<SpaceBefore 36pt>\\x11 %n",
			"%n%D0%I9", "<B1Text>", ' ', 'P', PARA },
	{ "flushleft", "%T", "%n", "<FlushL>", 'N', 'P', PARA },
	{ "flushright", "%T", "%n", "<FlushR>", 'N', 'P', PARA },
	{ "itemize", "%T%(L)+", "%<LT>\\t%n%(L)-", "<LM1>", 'N', 'H', PARA },
	{ "letter", "%(E)<*letter>", "%n", "<B1Text>", 'N', 'P', PARA },
	{ "*letter", "%D3%T%p%D0%T", "%n%n", "<FlushL>", 'N', 'P', PARA },
	{ "list", "%x%x%T", "%n", "<CBlockIndent>", 'N', 'H', PARA },
	{ "math", "", "", NULL, ' ', 'P', MATH },
	{ "picture", "%n\n<AFrame <BRect 0 0 6\" 1\">>\n%+",
			"%n%-", NULL, ' ', 'P', PARA },
	{ "quotation", "%T", "%n", "<Extract>", 'N', 'H', PARA },
	{ "quote", "%T", "%n", "<Extract>", 'N', 'H', PARA },
	{ "*signature", "%-%D2%T<SpaceBefore 72pt>", "%n%D0%+",
			"<FlushL>", ' ', 'P', PARA },
	{ "sloppypar", "%T", "%n", "<FlushL>", 'N', 'H', PARA },
	{ "tabbing", "%T", "%n", "<ETable>", ' ', 'P', TABLE },
	{ "table", "%o%D9<SpaceBefore 36pt>\\x11 %n",
			"%n%D0%I9", "<B1Text>", ' ', 'P', PARA },
	{ "table*", "%oD9<SpaceBefore 36pt>\\x11 %n",
			"%n%D0%I9", "<B1Text>", ' ', 'P', PARA },
	{ "tabular", "%o%x%T", "%n", "<ETable>", ' ', 'P', TABLE },
	{ "tabular*", "%x%o%o%x%T", "%n", "<ETable>", ' ', 'P', TABLE },
	{ "thebibliography", "%x%<1Heading*>\nReferences%<B1Text>",
		"%n", "<B2Text>", 'N', 'H', TABLE },
	{ "theindex", "%+", "%-", NULL, 'N', 'P', PARA },
	{ "*title", "%-%D1%T", "%n%D0%+", "<Title>", ' ', 'H', PARA },
	{ "titlepage", "%T", "%n", "<B2Text>", 'N', 'H', PARA },
	{ "trivlist", "%T", "%n", "<CBlockIndent>", 'N', 'H', PARA },
	{ "verbatim", "%T", "%n", "<Code>", 'P', 'P', VERBATIM },
	{ "verbatim*", "%T", "%n", "<Code>", 'P', 'P', VERBATIM },
	{ "verse", "%T", "%n", "<Extract>", 'P', 'P', PARA },

	{ NULL, NULL, NULL, NULL, ' ', ' ', UNKNOWN }	/* final terminator value */
};


static char ALLTABS[] = "0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0 5.5 6.0 6.5";
static char MANYTABS[] = "1.0 2.0 3.0 4.0 5.0 6.0 7.0";


static char L[] = "Left";
static char LR[] = "LeftRight";
static char C[] = "Center";
static char R[] = "Right";

/* Definitions of all the paragraph tags that *might* get defined in the
   mml translation.  Normally, only those that are used get defined.	*/

/* KJT 29/03/08:
     o FALSE value added to initialise "used" field
     o last (sentinel) field fully initialised
*/

PARAFORMAT paratable[] = {
    { "<A1Heading>",	H1, L,	1.6, 0.0, 0.0, 5, 18, 36, FALSE,
      "A:Appendix +\\t", "1.6", FALSE },
    { "<A2Heading>",	H2, L,	0.4,   0,   0, 3, 17,  7, FALSE,
      "A:<A\\>< \\>< \\>.+\\t", "0.4", FALSE },
    { "<A3Heading>",	H3, L,	0.4,   0,   0, 2, 13,  6, FALSE,
      "A:<A\\>< \\>< \\>.<n\\>.+\\t", "0.4", FALSE },
    { "<A4Heading>",	H4, L,	0.4,   0,   0, 2,  9,  4, FALSE,
      "A:<A\\>< \\>< \\>.<n\\>.<n\\>.+ ", "0.4", FALSE },
    { "<A5Heading>",	H5, L,	0.4,   0,   0, 2,  6,  4, FALSE,
      "A:<A\\>< \\>< \\>.<n\\>.<n\\>.<n\\>.+ ", "0.4", FALSE },
    { "<A6Heading>",	H6, L,	0.6,   0,   0, 2, 12,  2, FALSE,
      "A:<A\\>< \\>< \\>.<n\\>.<n\\>.<n\\>.<n\\>.+ ", "0.7", FALSE },
    { "<AText>",	Ab, L,	0.4, 0.6, 0.4, 2,  0,  0, TRUE, NULL, NULL,
      FALSE },
    { "<Author>",	Au, C,	 0,    0,   0, 4, 12, 18, FALSE, NULL, NULL,
      FALSE },
    { "<B1Text>",	RM, LR,	  0,   0,   0, 2,  0,  0, TRUE, NULL,
      "0.5 1.0 1.5 2.0", FALSE },
    { "<B2Text>",	RM, LR,	  0, 0.2,   0, 2,  0,  0, TRUE, NULL,
      "0.5 1.0 1.5 2.0", FALSE },
    { "<Center>",	RM, C,	  0,   0,   0, 2,  0,  0, FALSE, NULL, NULL,
      FALSE },
    { "<Code>",		TT, L,	  0,   0,   0, 2,  0,  0, FALSE, NULL, ALLTABS,
      FALSE },
    { "<CStep>",	RM, LR,	0.2, 0.2,   0, 2,  4,  0, TRUE, NULL, NULL,
      FALSE },
    { "<Equation>",	eq, C,	  0,   0,   0, 0, 10,  6, FALSE, NULL, NULL,
      FALSE },
    { "<ETable>",	et, L,	  0,   0,   0, 2,  4,  4, FALSE, NULL, MANYTABS,
      FALSE },
    { "<Extract>",	RM, LR, 0.8, 0.8, 0.8, 2,  6,  0, TRUE, NULL, NULL,
      FALSE },
    { "<CAFigure>",	BF, C,	  0,   0,   0, 2,  0, 12, FALSE,
       "A:Figure <A>.+< \\>< \\>< \\>< \\>< \\> ", NULL, FALSE },
    { "<CATable>",	BF, C,	  0,   0,   0, 2,  0, 12, FALSE,
      "A:Table <A>< >.+< \\>< \\>< \\>< \\> ", NULL, FALSE },
    { "<CMFigure>",	BF, C,	  0,   0,   0, 2,  0, 12, FALSE,
      "M:Figure <n>.+< \\>< \\>< \\>< \\>< \\> ", NULL, FALSE },
    { "<CMTable>",	BF, C,	  0,   0,   0, 2,  0, 12, FALSE,
      "M:Table <n>< >.+< \\>< \\>< \\>< \\> ", NULL, FALSE },
    { "<FlushL>",	RM, L,	  0,   0,   0, 2,  0,  0, FALSE, NULL, NULL,
      FALSE },
    { "<FlushR>",	RM, R,	  0, 0.5,   0, 2,  0,  0, FALSE, NULL, NULL,
      FALSE },
    { "<LI1Bullet>",	RM, LR,	0.4, 0.2,   0, 2,  6,  0, TRUE, "\\xa5 \\t",
      "0.4", FALSE },
    { "<LI2Bullet>",	RM, LR,	0.7, 0.5,   0, 2,  6,  0, TRUE, "\\xa5 \\t",
      "0.7", FALSE },
    { "<LI3Bullet>",	RM, LR,	1.0, 0.8,   0, 2,  6,  0, TRUE, "\\xa5 \\t",
      "1.0", FALSE },
    { "<LI4Bullet>",	RM, LR,	1.3, 1.1,   0, 2,  6,  0, TRUE, "\\xa5 \\t",
      "1.3", FALSE },
    { "<LI1Enumerate>",	RM, LR,	0.4, 0.1,   0, 2,  6,  0, TRUE,
      "E:(+)\\t", "0.4", FALSE },
    { "<LI2Enumerate>",	RM, LR,	0.7, 0.4,   0, 2,  6,  0, TRUE,
      "E:(+)\\t", "0.7", FALSE },
    { "<LI3Enumerate>",	RM, LR,	1.0, 0.7,   0, 2,  6,  0, TRUE,
      "E:(+)\\t", "1.0", FALSE },
    { "<LI4Enumerate>",	RM, LR,	1.3, 1.0,   0, 2,  6,  0, TRUE,
      "E:(+)\\t", "1.3", FALSE },
    { "<LI1Label>",	RM, LR,	0.4, 0.1,   0, 2,  6,  0, TRUE, NULL, "0.4",
      FALSE },
    { "<LI2Label>",	RM, LR,	0.7, 0.4,   0, 2,  6,  0, TRUE, NULL, "0.7",
      FALSE },
    { "<LI3Label>",	RM, LR,	1.0, 0.7,   0, 2,  6,  0, TRUE, NULL, "1.0",
      FALSE },
    { "<LI4Label>",	RM, LR,	1.3, 1.0,   0, 2,  6,  0, TRUE, NULL, "1.3",
      FALSE },
    { "<LM1>",		RM, LR,	0.4, 0.4,   0, 2,  0,  0, TRUE, NULL, NULL,
      FALSE },
    { "<LM2>",		RM, LR,	0.7, 0.7,   0, 2,  0,  0, TRUE, NULL, NULL,
      FALSE },
    { "<LM3>",		RM, LR,	1.0, 1.0,   0, 2,  0,  0, TRUE, NULL, NULL,
      FALSE },
    { "<LM4>",		RM, LR,	1.3, 1.3,   0, 2,  0,  0, TRUE, NULL, NULL,
      FALSE },
    { "<LT>",		tn, LR,	0.4, 0.1,   0, 0,  0,  0, TRUE,
      "E:0", "0.4", FALSE },
    { "<M1Heading>",	H1, L,	1.6, 0.0, 0.0, 5, 18, 36, FALSE,
      "M:Chapter +\\t", "1.6", FALSE },
    { "<M2Heading>",	H2, L,	0.4,   0,   0, 3, 17,  7, FALSE,
      "M:<n\\>< \\>< \\>.+\\t", "0.4", FALSE },
    { "<M3Heading>",	H3, L,	0.4,   0,   0, 2, 13,  6, FALSE,
      "M:<n\\>< \\>< \\>.<n\\>.+\\t", "0.4", FALSE },
    { "<M4Heading>",	H4, L,	0.4,   0,   0, 2,  9,  4, FALSE,
      "M:<n\\>< \\>< \\>.<n\\>.<n\\>.+ ", "0.4", FALSE },
    { "<M5Heading>",	H5, L,	0.4,   0,   0, 2,  6,  4, FALSE,
      "M:<n\\>< \\>< \\>.<n\\>.<n\\>.<n\\>.+ ", "0.4", FALSE },
    { "<M6Heading>",	H6, L,	0.6,   0,   0, 2, 12,  2, FALSE,
      "M:<n\\>< \\>< \\>.<n\\>.<n\\>.<n\\>.<n\\>.+ ", "0.7", FALSE },
    { "<Part>",		H0, C,	1.0,   0,   0, 6,  0, 18, FALSE,
      "P:Part <R+\\>\\t", "1.0", FALSE },
    { "<UPart>",	H0, C,	  0,   0,   0, 6,  0, 18, FALSE, NULL, NULL,
      FALSE },
    { "<Title>",	Ti, C,	  0,   0,   0, 5, 45, 18, FALSE, NULL, NULL,
      FALSE },
    { "<Table>",	BF, C,	  0,   0,   0, 2,  8,  4, FALSE,
      "T:Table +  ", NULL, FALSE },
    { "<U1Heading>",	H1, L,	1.6, 0.0, 0.0, 5, 18, 36, FALSE, NULL, NULL,
      FALSE },
    { "<U2Heading>",	H2, L,	0.4,   0,   0, 3, 17,  7, FALSE, NULL, NULL,
      FALSE },
    { "<U3Heading>",	H3, L,	0.4,   0,   0, 2, 13,  6, FALSE, NULL, NULL,
      FALSE },
    { "<U4Heading>",	H4, L,	0.4,   0,   0, 2,  9,  4, FALSE, NULL, NULL,
      FALSE },
    { "<U5Heading>",	H5, L,	  0,   0,   0, 2, 12,  2, FALSE, NULL, NULL,
      FALSE },
    { "<U6Heading>",	H6, L,	  0,   0,   0, 2, 12,  2, FALSE, NULL, NULL,
      FALSE },
    { NULL, NULL, NULL,		  0,   0,   0, 0,  0,  0, FALSE, NULL, NULL,
      FALSE }						/* terminator record */
};


/* Tables of all the font macros that *might* get defined in the mml
   output.  Normally, only those that are used get defined.  */

/* KJT 29/03/08:
     o FALSE value added to initialise "used" field
     o last (sentinel) field fully initialised
*/

CHARFORMAT chfmttable[] = {
    { RM, TIMESFAMILY,	10,	PLAIN, FALSE },
    { BF, TIMESFAMILY,	10,	BOLD, FALSE },
    { BI, TIMESFAMILY,	10,	BOLD & ITALIC, FALSE },
    { TT, COURIERFAMILY,10,	PLAIN, FALSE },
    { EM, TIMESFAMILY,	10,	ITALIC, FALSE },
    { SY, SYMBOLFAMILY,	10,	PLAIN, FALSE },
    { Ti, TIMESFAMILY,	30,	BOLD, FALSE },		/* Title size */
    { Au, TIMESFAMILY,	20,	BOLD, FALSE },		/* Author size */
    { Ab, TIMESFAMILY,	9,	PLAIN, FALSE },		/* Abstract size */
    { H0, TIMESFAMILY,	30,	BOLD, FALSE },		/* Part size */
    { H1, TIMESFAMILY,	25,	BOLD, FALSE },		/* 1Heading size */
    { H2, TIMESFAMILY,	14,	BOLD, FALSE },		/* 2Heading size */
    { H3, TIMESFAMILY,	12,	BOLD, FALSE },		/* 3Heading size */
    { H4, TIMESFAMILY,	11,	BOLD, FALSE },		/* 4Heading size */
    { H5, TIMESFAMILY,	10,	BOLD & ITALIC, FALSE },	/* 5Heading size */
    { H6, TIMESFAMILY,	10,	ITALIC, FALSE },	/* 6Heading size */
    { Hg, TIMESFAMILY,	25,	PLAIN, FALSE },		/* Huge size */
    { hg, TIMESFAMILY,	20,	PLAIN, FALSE },		/* huge size */
    { LA, TIMESFAMILY,	17,	PLAIN, FALSE },
    { La, TIMESFAMILY,	14,	PLAIN, FALSE },
    { la, TIMESFAMILY,	12,	PLAIN, FALSE },
    { et, TIMESFAMILY,	10,	PLAIN, FALSE },
    { eq, TIMESFAMILY,	10,	PLAIN, FALSE },
    { sm, TIMESFAMILY,	 9,	PLAIN, FALSE },		/* small size */
    { fn, TIMESFAMILY,	 8,	PLAIN, FALSE },		/* footnote size */
    { sc, TIMESFAMILY,	 7,	PLAIN, FALSE },		/* script size */
    { tn, TIMESFAMILY,	 6,	PLAIN, FALSE },		/* tiny size */
    { NULL, NULL,	 0,	PLAIN, FALSE }		/* terminator record */
};
