/* tables.h */

/*
 * Copyright (c) 1991-1993  R. Nigel Horspool.
 * All rights reserved.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND WITHOUT ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
*/

#ifndef BOOL
#define BOOL	char
#define TRUE	1
#define FALSE	0
#endif

/* Codes for all possible font styles -- mapped into bit positions */
#define ITALIC		 64
#define BOLD		 32
#define UNDERLINE	 16
#define STRIKE		  8
#define OBLIQUE		  4
#define SUBSCRIPT	  2
#define SUPERSCRIPT	  1

#define PLAIN		  0	/* none of the above bits is set */
#define STYLEMASK	(ITALIC|BOLD|UNDERLINE|STRIKE|OBLIQUE)
#define SCRIPTMASK	(SUBSCRIPT|SUPERSCRIPT)

/* All the font families used */
extern char TIMESFAMILY[];
extern char SYMBOLFAMILY[];
extern char COURIERFAMILY[];
extern char HELVETICAFAMILY[];

/* Standard font-style combinations */
extern char RM[], TT[], SY[];


/* Special token types that are distinguished */
typedef enum {
	NULLCMD,		/* special code */
	EOFCMD,			/* end of file */
	LSQCMD, RSQCMD,		/* \[ and \] */
	LSQ, RSQ,		/* [ and ] */
	LPARCMD, RPARCMD,	/* \( and \) */
	ENDCMD,			/* \end */
	LBRACE, RBRACE,		/* { and }  */
	DOLLAR_START,		/* $ -- opening a group */
	DOLLAR_END,		/* $ -- ending a group */
	DOLLARDOLLAR_START,	/* $$ -- opening a group */
	DOLLARDOLLAR_END,	/* $$ -- ending a group */
	OTHER			/* anything else */
    } TOKEN;


/* The mode for reading the current text.  Note that PARA mode includes
   LR mode.  TABLE == any PARA mode in which `&' is legal; MATHARRAY ==
   any MATH mode in which `&' is legal. */
typedef enum { MATH, VERBATIM, PARA, MATHARRAY, TABLE, UNKNOWN } TEXTMODE;


typedef struct {
	    char	*cmd;
	    char	*code;
	} *ACTIONPTR, ACTION;


typedef struct es {
	    char	*name;
	    char	*startcmd,	/* control string for start of env. */
			*endcmd,	/* control string for end of env. */
			*conttag;	/* tag to use when resuming para */
	    char	nlmode,		/* action for newline:  P -> new para,
					   N -> normal, ' ' -> ignore */
			slmode;		/* action for \\ command: P -> new para,
					   H -> hard return, ' ' -> ignore */
	    TEXTMODE	kind;
    } ENV, *ENVPTR;

typedef struct {
	char 	*tagname, *font, *alignment;
	float	left, first, right;
	short	leading, before, after;
	BOOL	hyphenate;
	char	*autoformat, *tabstops;
	BOOL	used;
    } PARAFORMAT;


typedef struct {
	char	*name, *family;
	short	size, style;
	BOOL	used;
    } CHARFORMAT;

/* KJT 29/03/08: "eof" renamaed "endoffile" to avoid MingW clash */

extern ACTION commands[], special_chars[], slash_chars[], accent_tab[];
extern ACTION dollardollar, dashdash, dashdashdash, leftdquote, rightdquote,
	endoffile, other, untranslated;
extern PARAFORMAT paratable[];
extern CHARFORMAT chfmttable[];

extern ENV bad_env;
extern ENV environments[];
extern ENVPTR math_env, displaymath_env, tabbing_env;


