%{

/*****************************************************************************

  "miflex.l"	P. C. Hsu, K. J. Turner	27/09/94

  This is a lex program to break the input MIF file into tokens.

*****************************************************************************/

#include "y.tab.h"
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define PROG			"miflex"

#undef YYLMAX
#define YYLMAX 1024		/* max. input token size */

extern int lineno;

%}

Comment         #.*
Graphic		&.*
Ident		[a-zA-Z][a-zA-Z0-9]*
Newline		\n
Number		([0-9]*)|([0-9]*\.[0-9]+)|(\-[0-9]*)|(\-[0-9]*\.[0-9]+)
Special_line	=.*
String		`[^\']*\'
WhiteSpace      [ \t]

%%

ATbl		return ATBL;
Cell		return CELL;
Char		return CHAR;
FNote	 	return FNOTE;
FontCatalog	return FONTCATALOG;
FTag		return FTAG;
ID		return ID;
MIFFile		return MIF;
Notes		return NOTES;
Para		return PARA;
ParaLine	return PARALINE;
PgfCatalog	return PGFCATALOG;
PgfTag		return PGFTAG;
Row		return ROW;
String		return STRING;
Tbl		return TBL;
TblID		return TBLID;
TblTag		return TBLTAG;
TblNumColumns	return TBLNUMCOLUMNS;
TblTitleContent	return TBLTITLECONTENT;
TextFlow	return TEXTFLOW;
VariableFormat	return VARIABLEFORMAT;
VariableDef	return VARIABLEDEF;
VariableName	return VARIABLENAME;

{Comment}	;
{Graphic}	;
{Ident} 	{
		 yylval.txt = yytext;
		 return IDENT;
		}
{Number}	{
                  yylval.txt = yytext;
                  return (NUM);
                }
{Newline}	lineno++;
{Special_line}	;
{String}	{
		  yylval.txt = &yytext[1];
		  yytext[yyleng - 1] = '\0';
		  return STR;
                }
{WhiteSpace}	;

.		return yytext[0];
