/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.PlugwiseDriver;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.TimeZone;
import javax.comm.SerialPort;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;
import org.osgi.util.tracker.ServiceTracker;
import uk.ac.stir.cs.PlugwiseDriver.DeviceParameters;
import uk.ac.stir.cs.PlugwiseDriver.EventAdminPostEventService;
import uk.ac.stir.cs.PlugwiseDriver.PlugwiseAction;
import uk.ac.stir.cs.PlugwiseDriver.PlugwiseTransceiver;
import uk.ac.stir.cs.PlugwiseDriver.PostEventService;
import uk.ac.stir.cs.device.serial.SerialService;

public class Activator
implements BundleActivator {
    private static String BUNDLE_PROPERTIES = "PlugwiseDriver.properties";
    private static final String[] DEVICE_TOPICS = new String[]{"uk/ac/stir/cs/accent/device_out"};
    private Hashtable<DeviceParameters, String> actionMapping = new Hashtable();
    private ServiceRegistration actionRegistration;
    private String controllerAddress = null;
    private int energyInterval;
    private static boolean errorFound = false;
    private String portEntity;
    private String portName;
    private int powerInterval;
    private PostEventService postEventService;
    private PlugwiseTransceiver plugwiseTransceiver;
    private int retryLimit;
    private SerialPort serialPort;
    private Hashtable<String, DeviceParameters> sensorMapping = new Hashtable();
    private String startAddress;
    private ServiceTracker trackerEventAdmin;

    public static String getTime() {
        Calendar cal = Calendar.getInstance(TimeZone.getDefault());
        String df = "yyyy-MM-dd HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(df);
        sdf.setTimeZone(TimeZone.getDefault());
        return sdf.format(cal.getTime());
    }

    public static void logError(String source, String message) {
        errorFound = true;
        String text = String.valueOf(Activator.getTime()) + " [Error] PlugwiseDriver." + source + ": " + message;
        System.out.println(text);
    }

    public static void logError(String message) {
        errorFound = true;
        String text = String.valueOf(Activator.getTime()) + " [Error] PlugwiseDriver: " + message;
        System.err.println(text);
    }

    public static void logNote(String source, String message) {
        String text = String.valueOf(Activator.getTime()) + " [Note] PlugwiseDriver." + source + ": " + message;
        System.out.println(text);
    }

    public static void logNote(String message) {
        String text = String.valueOf(Activator.getTime()) + " [Note] PlugwiseDriver: " + message;
        System.out.println(text);
    }

    private void setProperties(BundleContext context) throws Exception {
        int pos;
        String osgiRoot = context.getBundle().getLocation();
        String dataDirectory = context.getDataFile("").toString();
        if (dataDirectory != null && (pos = dataDirectory.indexOf("osgi")) != -1) {
            osgiRoot = dataDirectory.substring(0, pos + 5);
        }
        String propertyFileName = String.valueOf(osgiRoot) + BUNDLE_PROPERTIES;
        Properties properties = new Properties();
        try {
            File propertiesFile = new File(propertyFileName);
            FileInputStream propertyStream = new FileInputStream(propertiesFile);
            properties.load(propertyStream);
        }
        catch (IOException e) {
            Activator.logError("could not read properties file '" + propertyFileName + "'");
        }
        try {
            this.retryLimit = Integer.parseInt(properties.getProperty("plugwise.retry.limit"));
        }
        catch (NumberFormatException exception) {
            this.retryLimit = 3;
            Activator.logError("property 'plugwise.retry.limit' must be an integer");
        }
        if (this.retryLimit <= 0) {
            Activator.logError("property 'plugwise.retry.limit' must be greater than 0");
        }
        try {
            this.energyInterval = Integer.parseInt(properties.getProperty("plugwise.energy.interval"));
        }
        catch (NumberFormatException exception) {
            this.energyInterval = 60;
            Activator.logError("property 'plugwise.energy.interval' must be an integer");
        }
        if (this.energyInterval <= 0) {
            Activator.logError("property 'plugwise.energy.interval' must be greater than 0");
        }
        try {
            this.powerInterval = Integer.parseInt(properties.getProperty("plugwise.power.interval"));
        }
        catch (NumberFormatException exception) {
            this.powerInterval = 10;
            Activator.logError("property 'plugwise.power.interval' must be an integer");
        }
        if (this.powerInterval <= 0) {
            Activator.logError("property 'plugwise.power.interval' must be greater than 0");
        }
        this.startAddress = properties.getProperty("plugwise.address.start");
        this.portName = properties.getProperty("plugwise.port");
        this.portEntity = properties.getProperty("plugwise.entity");
        if (this.portName == null || this.portEntity == null || this.startAddress == null) {
            Activator.logError("properties 'plugwise.entity', 'plugwise.port' and 'plugwise.address.start' needed");
        }
        Enumeration<?> propertyNames = properties.propertyNames();
        while (propertyNames.hasMoreElements()) {
            String property = ((String)propertyNames.nextElement()).trim();
            if (property.startsWith("plugwise.")) continue;
            String value = properties.getProperty(property).trim();
            if (property.matches("^[0-9A-F]+\\+?$") && value.matches("^[^,]+,[^,]+$")) {
                String sensorId = property.trim().toUpperCase();
                int position = sensorId.indexOf(43);
                if (position != -1) {
                    sensorId = sensorId.substring(0, position);
                    if (this.controllerAddress == null) {
                        this.controllerAddress = sensorId;
                    } else {
                        Activator.logError("duplicate Circle+ address '" + sensorId + "'");
                    }
                }
                String[] triggerValues = value.split("\\s*,\\s*");
                String entityName = triggerValues[0].trim();
                String entityInstance = triggerValues[1].trim();
                DeviceParameters triggerParameters = new DeviceParameters(entityName, entityInstance);
                this.sensorMapping.put(sensorId, triggerParameters);
                this.actionMapping.put(triggerParameters, sensorId);
                continue;
            }
            Activator.logError("invalid mapping: " + property + " = " + value);
        }
        if (this.controllerAddress == null) {
            Activator.logError("Circle+ address not defined");
        }
    }

    public void start(BundleContext context) throws Exception {
        this.trackerEventAdmin = new ServiceTracker(context, EventAdmin.class.getName(), null);
        this.trackerEventAdmin.open();
        EventAdmin eventAdminService = (EventAdmin)this.trackerEventAdmin.getService();
        this.postEventService = new EventAdminPostEventService(eventAdminService);
        this.setProperties(context);
        if (!errorFound) {
            this.plugwiseTransceiver = new PlugwiseTransceiver(this.portName, this.startAddress, this.controllerAddress, this.retryLimit, this.energyInterval, this.powerInterval, this.sensorMapping, this.postEventService);
            PlugwiseAction actionHandler = new PlugwiseAction(context, this.plugwiseTransceiver, this.actionMapping);
            Hashtable<String, String[]> dictionary = new Hashtable<String, String[]>();
            dictionary.put("event.topics", DEVICE_TOPICS);
            this.actionRegistration = context.registerService(EventHandler.class.getName(), (Object)actionHandler, dictionary);
            ServiceReference[] serviceReferences = context.getServiceReferences("uk.ac.stir.cs.device.serial.SerialService", "(Port=" + this.portName + ")");
            if (serviceReferences != null && serviceReferences.length == 1) {
                ServiceReference serviceReference = serviceReferences[0];
                SerialService serialService = (SerialService)context.getService(serviceReference);
                this.serialPort = serialService.getPort();
                if (!this.plugwiseTransceiver.initialise(this.portEntity, this.serialPort)) {
                    this.plugwiseTransceiver.close();
                    Activator.logError("could not initialise port - try restarting CommAccess");
                } else {
                    Activator.logNote("started port " + this.portName);
                }
            } else {
                Activator.logError("port " + this.portName + " not found - start CommAccess");
            }
        }
    }

    public void stop(BundleContext context) throws Exception {
        if (this.serialPort != null) {
            this.plugwiseTransceiver.close();
        }
        this.actionRegistration.unregister();
        Activator.logNote("stopped port " + this.portName);
    }
}

