/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.PlugwiseDriver;

import java.util.Hashtable;
import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;
import uk.ac.stir.cs.PlugwiseDriver.Activator;
import uk.ac.stir.cs.PlugwiseDriver.DeviceParameters;
import uk.ac.stir.cs.PlugwiseDriver.PlugwiseTransceiver;

public class PlugwiseAction
implements EventHandler {
    private Hashtable<DeviceParameters, String> actionMapping;
    private PlugwiseTransceiver plugwiseTransceiver;

    public PlugwiseAction(BundleContext context, PlugwiseTransceiver plugwiseTransceiver, Hashtable<DeviceParameters, String> actionMapping) {
        this.plugwiseTransceiver = plugwiseTransceiver;
        this.actionMapping = actionMapping;
    }

    public String getProperty(Event event, String property) {
        String value = (String)event.getProperty(property);
        if (value == null) {
            value = "";
        }
        return value;
    }

    public void handleEvent(Event event) {
        String entityInstance;
        String messageType = this.getProperty(event, "arg1");
        String entityName = this.getProperty(event, "arg2");
        DeviceParameters deviceParameters = new DeviceParameters(entityName, entityInstance = this.getProperty(event, "arg3"));
        String circleAddress = this.actionMapping.get(deviceParameters);
        if (circleAddress != null) {
            if (messageType.equals("off")) {
                this.plugwiseTransceiver.requestChange(circleAddress, false);
            } else if (messageType.equals("on")) {
                this.plugwiseTransceiver.requestChange(circleAddress, true);
            } else {
                Activator.logError("handleEvent", "unknown message type '" + messageType + "'");
            }
        }
    }
}

