/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.stir.cs.PlugwiseDriver;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.comm.SerialPort;
import javax.comm.UnsupportedCommOperationException;
import uk.ac.stir.cs.PlugwiseDriver.Activator;
import uk.ac.stir.cs.PlugwiseDriver.Calibration;
import uk.ac.stir.cs.PlugwiseDriver.DeviceParameters;
import uk.ac.stir.cs.PlugwiseDriver.Energy;
import uk.ac.stir.cs.PlugwiseDriver.PostEventService;

public class PlugwiseTransceiver {
    private static final int BIT_RATE = 115200;
    private static final String CLOCK_TASK = "clock";
    private static int CRC_POLYNOMIAL = 4129;
    private static boolean ERROR_DEBUG = false;
    private static final String ENERGY_TASK = "energy";
    public static final String EVENT_TOPIC = "uk/ac/stir/cs/accent/device_in";
    private static final String POWER_TASK = "power";
    private static final String GENERAL_RESPONSE = "0000";
    private static final String CLOCK_GET_REQUEST = "003E";
    private static final String CLOCK_GET_RESPONSE = "003F";
    private static final String CLOCK_SET_REQUEST = "0016";
    private static final String CLOCK_SET_RESPONSE = "0000";
    private static final String DEVICE_CALIBRATION_REQUEST = "0026";
    private static final String DEVICE_CALIBRATION_RESPONSE = "0027";
    private static final String DEVICE_INFORMATION_REQUEST = "0023";
    private static final String DEVICE_INFORMATION_RESPONSE = "0024";
    private static final String POWER_BUFFER_REQUEST = "0048";
    private static final String POWER_BUFFER_RESPONSE = "0049";
    private static final String POWER_CHANGE_REQUEST = "0017";
    private static final String POWER_CHANGE_RESPONSE = "0000";
    private static final String POWER_INFORMATION_REQUEST = "0012";
    private static final String POWER_INFORMATION_RESPONSE = "0013";
    private static final String PROTOCOL_ACK = "00C1";
    private static final String PROTOCOL_HEADER = "\u0005\u0005\u0003\u0003";
    private static final String PROTOCOL_TRAILER = "\r\n";
    private static final float PULSE_FACTOR = 2.1324759f;
    private static final int RECEIVE_DELAY = 1;
    private static final int RECEIVE_TIMEOUT = 2;
    private static final String STICK_INITIALISE_REQUEST = "000A";
    private static final String STICK_INITIALISE_RESPONSE = "0011";
    private Calibration calibrationDefault = new Calibration(1.0f, 0.0f, 0.0f, 0.0f);
    private Hashtable<String, Calibration> calibrationMapping = new Hashtable();
    private int clockOffset;
    private PollTask clockTask = null;
    private String controllerAddress;
    private int[] crcTable;
    private int energyInterval;
    private PollTask energyTask = null;
    private InputStream inputStream;
    private OutputStream outputStream;
    private Timer pollTimer = null;
    private String portEntity = null;
    private String portName;
    private PostEventService postEventService;
    private int powerInterval;
    private PollTask powerTask = null;
    private int retryLimit;
    private Hashtable<String, DeviceParameters> sensorMapping = new Hashtable();
    private SerialPort serialPort = null;
    private String startAddress;

    public PlugwiseTransceiver(String portName, String startAddress, String controllerAddress, int retryLimit, int energyInterval, int powerInterval, Hashtable<String, DeviceParameters> sensorMapping, PostEventService postEventService) {
        this.portName = portName;
        this.startAddress = startAddress;
        this.controllerAddress = controllerAddress;
        this.energyInterval = energyInterval;
        this.powerInterval = powerInterval;
        this.retryLimit = retryLimit;
        this.sensorMapping = sensorMapping;
        this.postEventService = postEventService;
        this.crcTable = this.getCRCTable();
        Calendar calendar = Calendar.getInstance();
        this.clockOffset = (calendar.get(15) + calendar.get(16)) / 60000;
    }

    public void close() {
        if (this.serialPort != null && this.inputStream != null && this.outputStream != null) {
            try {
                this.inputStream.close();
                this.outputStream.close();
            }
            catch (IOException exception) {
                Activator.logError("close", "I/O error on port '" + this.portName + "' - " + exception);
            }
            try {
                this.serialPort.removeEventListener();
            }
            catch (IllegalStateException exception) {
                Activator.logError("close", "port " + this.portName + " already closed");
            }
        }
        if (this.clockTask != null && this.energyTask != null && this.powerTask != null) {
            this.clockTask.cancel();
            this.energyTask.cancel();
            this.powerTask.cancel();
        }
        if (this.pollTimer != null) {
            this.pollTimer.cancel();
        }
    }

    public String checkData(String command, String buffer) {
        String response = null;
        String code = "0000";
        String header = PROTOCOL_HEADER + code;
        int position1 = buffer.indexOf(header);
        if (position1 != -1) {
            code = buffer.substring(position1 + 12, position1 + 16);
            if (code.equals(PROTOCOL_ACK)) {
                code = this.responseCode(command);
                header = PROTOCOL_HEADER + code;
                if (!code.equals("0000")) {
                    position1 = buffer.indexOf(header, position1 + 20);
                }
                if (position1 != -1) {
                    int position2 = buffer.indexOf(PROTOCOL_TRAILER, position1 += PROTOCOL_HEADER.length());
                    if (position2 != -1) {
                        String crcExpected = this.getCRCString(buffer.substring(position1, position2 -= 4));
                        String message = buffer.substring(position1, position2);
                        String content = buffer.substring(position1 += code.length(), position2);
                        String crcActual = buffer.substring(position2, position2 + 4);
                        if (crcExpected.equals(crcActual)) {
                            response = content;
                            if (ERROR_DEBUG) {
                                Activator.logNote("checkData", "receiving '" + this.formatBuffer(message) + "'");
                            }
                        } else if (ERROR_DEBUG) {
                            Activator.logNote("checkData", "protocol response to " + this.commandName(command) + " ignored due to invalid checksum");
                        }
                    } else if (ERROR_DEBUG) {
                        Activator.logError("checkData", "protocol response to " + this.commandName(command) + "lacks trailer");
                    }
                } else if (ERROR_DEBUG) {
                    Activator.logError("checkData", "protocol response header for " + this.commandName(command) + " not received");
                }
            } else if (ERROR_DEBUG) {
                Activator.logError("checkData", "protocol response to " + this.commandName(command) + " is negative");
            }
        } else if (ERROR_DEBUG) {
            Activator.logError("checkData", "protocol response header for " + this.commandName(command) + " not received");
        }
        return response;
    }

    public String commandName(String command) {
        String name = "?";
        if (command.equals(POWER_BUFFER_REQUEST)) {
            name = "power buffer request";
        } else if (command.equals(DEVICE_CALIBRATION_REQUEST)) {
            name = "calibration request";
        } else if (command.equals(DEVICE_INFORMATION_REQUEST)) {
            name = "device information request";
        } else if (command.equals(CLOCK_GET_REQUEST)) {
            name = "clock get request";
        } else if (command.equals(CLOCK_SET_REQUEST)) {
            name = "clock set request";
        } else if (command.equals(POWER_CHANGE_REQUEST)) {
            name = "power change request";
        } else if (command.equals(POWER_INFORMATION_REQUEST)) {
            name = "power information request";
        } else if (command.equals(STICK_INITIALISE_REQUEST)) {
            name = "stick initialisation request";
        }
        return name;
    }

    public String deviceName(String address) {
        String name = "unknown device";
        if (address != null) {
            DeviceParameters trigger = this.sensorMapping.get(address);
            if (trigger != null) {
                name = String.valueOf(trigger.getEntityName()) + " in " + trigger.getEntityInstance();
            }
        } else {
            name = "Circle+";
        }
        return name;
    }

    public String formatBuffer(String buffer) {
        String hexString = "";
        if (buffer != null) {
            int i = 0;
            while (i < buffer.length()) {
                if (i > 0 && i % 4 == 0) {
                    hexString = String.valueOf(hexString) + " ";
                }
                hexString = String.valueOf(hexString) + buffer.charAt(i);
                ++i;
            }
        }
        return hexString;
    }

    public Calibration getCalibration(String circleAddress) {
        Calibration calibration = this.calibrationMapping.get(circleAddress);
        if ((calibration == null || calibration.equals(this.calibrationDefault)) && (calibration = this.requestCalibration(circleAddress)) == null) {
            calibration = this.calibrationDefault;
        }
        return calibration;
    }

    public String getCRCString(String buffer) {
        byte[] bytes;
        int work = 0;
        byte[] byArray = bytes = buffer.getBytes();
        int n = bytes.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            work = (this.crcTable[(b ^ work >>> 8) & 0xFF] ^ work << 8) & 0xFFFF;
            ++n2;
        }
        return Integer.toHexString(work).toUpperCase();
    }

    private int[] getCRCTable() {
        int[] crcTable = new int[256];
        int i = 0;
        while (i < 256) {
            int fcs = 0;
            int d = i << 8;
            int k = 0;
            while (k < 8) {
                fcs = ((fcs ^ d) & 0x8000) != 0 ? fcs << 1 ^ CRC_POLYNOMIAL : (fcs <<= 1);
                d <<= 1;
                fcs &= 0xFFFF;
                ++k;
            }
            crcTable[i] = fcs;
            ++i;
        }
        return crcTable;
    }

    private float getFloat(String buffer, int start, int length) {
        float number = 0.0f;
        if (length == 8) {
            int floatBits = this.getInt(buffer, start, length);
            number = Float.intBitsToFloat(floatBits);
        } else {
            Activator.logError("getFloat", "float length for '" + length + "' not 8");
        }
        return number;
    }

    private int getInt(String buffer, int start, int length) {
        int number = 0;
        if (1 <= length && length <= 8) {
            String numberString = buffer.substring(start, start + length);
            try {
                long numberLong = Long.parseLong(numberString, 16);
                number = (int)(numberLong & 0xFFFFFFFFFFFFFFFFL);
            }
            catch (NumberFormatException exception) {
                Activator.logError("getInt", "incorrect format for integer '" + numberString + "'");
            }
        } else {
            Activator.logError("getInt", "integer length for '" + length + "' not 1 to 8");
        }
        return number;
    }

    public float getPower(Calibration calibration, int pulses, int period) {
        float power = 0.0f;
        if (period > 0) {
            if (pulses != 0 && pulses != 65535 && pulses != -1) {
                float gainA = calibration.getGainA();
                float gainB = calibration.getGainB();
                float offsetNoise = calibration.getOffsetNoise();
                float offsetTotal = calibration.getOffsetTotal();
                float pulsesAverage = (float)pulses / (float)period;
                float pulsesOffsetNoise = pulsesAverage + offsetNoise;
                float pulsesCorrected = pulsesOffsetNoise * pulsesOffsetNoise * gainB + pulsesOffsetNoise * gainA + offsetTotal;
                power = 2.1324759f * pulsesCorrected;
            }
        } else {
            Activator.logError("getPower", "period '" + period + "' must be positive");
        }
        return power;
    }

    private String getTime(int minutes) {
        int hour = (minutes %= 1440) / 60;
        int minute = minutes % 60;
        String time = String.format("%02d:%02d:00", hour, minute);
        return time;
    }

    private String getTime(int hour, int minute, int second, int offset) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.add(12, offset);
        hour = calendar.get(11);
        minute = calendar.get(12);
        String time = String.format("%02d:%02d:%02d", hour, minute, second);
        return time;
    }

    public boolean initialise(String portEntity, SerialPort serialPort) {
        this.portEntity = portEntity;
        this.serialPort = serialPort;
        boolean result = false;
        try {
            this.inputStream = serialPort.getInputStream();
            this.outputStream = serialPort.getOutputStream();
            serialPort.setSerialPortParams(115200, 8, 1, 0);
            serialPort.enableReceiveTimeout(2000);
        }
        catch (IOException exception1) {
            Activator.logError("initialise", "I/O error on port '" + this.portName + "' - " + exception1);
            serialPort.close();
            return result;
        }
        catch (IllegalStateException exception2) {
            Activator.logError("initialise", "port '" + this.portName + "' already closed - restart CommAccess");
            return result;
        }
        catch (UnsupportedCommOperationException exception4) {
            Activator.logError("initialise", "port '" + this.portName + "' unsupported operation");
            return result;
        }
        serialPort.setDTR(false);
        serialPort.setRTS(false);
        result = this.initialisePort();
        return result;
    }

    public boolean initialisePort() {
        boolean online = false;
        try {
            if (this.inputStream.available() > 0) {
                if (ERROR_DEBUG) {
                    Activator.logNote("initialisePort", "discarding old data from port '" + this.portName + "'");
                }
                while (this.inputStream.available() > 0) {
                    this.inputStream.read();
                }
            }
            if (online = this.requestInitialisation()) {
                this.startThreads();
            } else {
                Activator.logError("initialisePort", "Plugwise network offline");
            }
        }
        catch (IOException exception) {
            Activator.logError("initialisePort", "I/O exception - " + exception);
        }
        return online;
    }

    public void pollCircles(String taskType) {
        if (taskType.equals(CLOCK_TASK)) {
            this.requestSetting(this.controllerAddress, null);
        } else if (taskType.equals(ENERGY_TASK)) {
            String messageType = taskType;
            String messagePeriod = "";
            String parameterValues = "";
            int total = 0;
            Enumeration<String> circleAddresses = this.sensorMapping.keys();
            while (circleAddresses.hasMoreElements()) {
                String circleAddress = circleAddresses.nextElement();
                DeviceParameters trigger = this.sensorMapping.get(circleAddress);
                String entityName = trigger.getEntityName();
                String entityInstance = trigger.getEntityInstance();
                Energy energy = this.requestEnergy(circleAddress);
                if (energy == null) continue;
                messagePeriod = energy.getTime();
                int consumption = energy.getEnergy();
                total += consumption;
                parameterValues = Integer.toString(consumption);
                this.postEvent(messageType, entityName, entityInstance, messagePeriod, parameterValues);
            }
            parameterValues = Integer.toString(total);
            this.postEvent(messageType, "", "", messagePeriod, Integer.toString(total));
        } else if (taskType.equals(POWER_TASK)) {
            String messageType = taskType;
            String messagePeriod = "";
            String parameterValues = "";
            int total = 0;
            Enumeration<String> circleAddresses = this.sensorMapping.keys();
            while (circleAddresses.hasMoreElements()) {
                String circleAddress = circleAddresses.nextElement();
                DeviceParameters trigger = this.sensorMapping.get(circleAddress);
                String entityName = trigger.getEntityName();
                String entityInstance = trigger.getEntityInstance();
                int consumption = this.requestPower(circleAddress);
                if (consumption < 0) continue;
                messagePeriod = "";
                total += consumption;
                parameterValues = Integer.toString(consumption);
                this.postEvent(messageType, entityName, entityInstance, messagePeriod, parameterValues);
            }
            parameterValues = Integer.toString(total);
            this.postEvent(messageType, "", "", messagePeriod, parameterValues);
        } else {
            Activator.logError("pollCircles", "unknown task type '" + taskType + "'");
        }
    }

    public void postEvent(String messageType, String entityName, String entityInstance, String messagePeriod, String parameterValues) {
        Hashtable<String, Object> eventProperties = new Hashtable<String, Object>();
        eventProperties.put("arg1", messageType);
        eventProperties.put("arg2", entityName);
        eventProperties.put("arg3", entityInstance);
        eventProperties.put("arg4", messagePeriod);
        eventProperties.put("arg5", parameterValues);
        eventProperties.put("user", this.portEntity);
        String deviceParameters = String.valueOf(messageType) + "," + entityName + "," + entityInstance + "," + messagePeriod + "," + parameterValues;
        String deviceMessage = "trigger - " + deviceParameters;
        eventProperties.put("message", deviceMessage);
        if (ERROR_DEBUG) {
            String deviceIn = "uk/ac/stir/cs/accent/device_in(" + deviceParameters + ")";
            Activator.logNote("postEvent", deviceIn);
        }
        this.postEventService.postEvent(EVENT_TOPIC, eventProperties);
    }

    public String receiveData(String command) {
        String response = null;
        try {
            Vector<Byte> bytes = new Vector<Byte>();
            int byteLength = 0;
            while (this.inputStream.available() != 0) {
                byte b = (byte)this.inputStream.read();
                ++byteLength;
                bytes.add(b);
            }
            if (byteLength != 0) {
                StringBuffer buffer = new StringBuffer(byteLength);
                int i = 0;
                while (i < byteLength) {
                    byte b = (Byte)bytes.get(i);
                    buffer.append((char)b);
                    ++i;
                }
                response = this.checkData(command, buffer.toString());
            } else if (ERROR_DEBUG) {
                Activator.logError("receiveData", "protocol response to " + this.commandName(command) + " not received");
            }
        }
        catch (IOException exception) {
            Activator.logError("receiveData", "I/O exception reading response to " + this.commandName(command) + " - " + exception);
        }
        return response;
    }

    public Calibration requestCalibration(String circleAddress) {
        Calibration calibration = null;
        String response = this.sendCommand(DEVICE_CALIBRATION_REQUEST, circleAddress, null);
        if (response != null) {
            float gainA = this.getFloat(response, 20, 8);
            float gainB = this.getFloat(response, 28, 8);
            float offsetNoise = this.getFloat(response, 44, 8);
            float offsetTotal = this.getFloat(response, 36, 8);
            calibration = new Calibration(gainA, gainB, offsetNoise, offsetTotal);
        }
        return calibration;
    }

    protected void requestChange(String circleAddress, boolean power) {
        String parameters = power ? "01" : "00";
        String response = this.sendCommand(POWER_CHANGE_REQUEST, circleAddress, parameters);
        if (response == null && ERROR_DEBUG) {
            Activator.logError("requestChange", "could not change power state for " + this.deviceName(circleAddress));
        }
    }

    public String requestClock(String circleAddress) {
        String time = null;
        String response = this.sendCommand(CLOCK_GET_REQUEST, circleAddress, null);
        if (response != null) {
            int hour = this.getInt(response, 20, 2);
            int minute = this.getInt(response, 22, 2);
            int second = this.getInt(response, 24, 2);
            time = this.getTime(hour, minute, second, this.clockOffset);
        }
        return time;
    }

    public Energy requestEnergy(String circleAddress) {
        Energy energy = null;
        int logAddress = this.requestInformation(circleAddress);
        if ((logAddress -= 8) != 0) {
            String response;
            String logAddressString = String.format("%08X", logAddress);
            Calibration calibration = this.getCalibration(circleAddress);
            if (calibration != null && (response = this.sendCommand(POWER_BUFFER_REQUEST, circleAddress, logAddressString)) != null) {
                int minutes = this.getInt(response, 24, 4);
                String time = this.getTime(minutes);
                int pulses = this.getInt(response, 28, 8);
                int energyConsumption = Math.round(this.getPower(calibration, pulses, 3600));
                energy = new Energy(time, energyConsumption);
                if (ERROR_DEBUG) {
                    Activator.logNote("circle " + this.deviceName(circleAddress), "time " + time + " energyConsumption " + energyConsumption);
                }
            }
        }
        return energy;
    }

    public int requestInformation(String circleAddress) {
        int logAddress = 0;
        String response = this.sendCommand(DEVICE_INFORMATION_REQUEST, circleAddress, null);
        if (response != null) {
            logAddress = this.getInt(response, 28, 8);
        }
        return logAddress;
    }

    public boolean requestInitialisation() {
        boolean networkStatus = false;
        String response = this.sendCommand(STICK_INITIALISE_REQUEST, null, null);
        if (response != null) {
            networkStatus = this.getInt(response, 22, 2) == 1;
        }
        return networkStatus;
    }

    public int requestPower(String circleAddress) {
        String response;
        float powerConsumption = -1.0f;
        Calibration calibration = this.getCalibration(circleAddress);
        if (calibration != null && (response = this.sendCommand(POWER_INFORMATION_REQUEST, circleAddress, null)) != null) {
            int pulseCount = this.getInt(response, 24, 4);
            powerConsumption = this.getPower(calibration, pulseCount, 8);
        }
        return Math.round(powerConsumption);
    }

    private void requestSetting(String circleAddress, String logAddress) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(12, -this.clockOffset);
        int year = calendar.get(1);
        int month = calendar.get(2) + 1;
        int day = calendar.get(5);
        int hour = calendar.get(11);
        int minute = calendar.get(12);
        int second = calendar.get(13);
        int weekDay = calendar.get(7) - 1;
        int minutes = 1440 * (day - 1) + 60 * hour + minute;
        String date = String.format("%02X%02X%04X", year - 2000, month, minutes);
        if (logAddress == null) {
            logAddress = "FFFFFFFF";
        }
        String time = String.format("%02X%02X%02X%02X", hour, minute, second, weekDay);
        String parameters = String.valueOf(date) + logAddress + time;
        String response = this.sendCommand(CLOCK_SET_REQUEST, circleAddress, parameters);
        if (response == null && ERROR_DEBUG) {
            Activator.logError("requestSetting", "could not set clock for " + this.deviceName(circleAddress));
        }
    }

    public String responseCode(String command) {
        String response = "0000";
        if (command.equals(POWER_BUFFER_REQUEST)) {
            response = POWER_BUFFER_RESPONSE;
        } else if (command.equals(DEVICE_CALIBRATION_REQUEST)) {
            response = DEVICE_CALIBRATION_RESPONSE;
        } else if (command.equals(CLOCK_GET_REQUEST)) {
            response = CLOCK_GET_RESPONSE;
        } else if (command.equals(CLOCK_SET_REQUEST)) {
            response = "0000";
        } else if (command.equals(DEVICE_INFORMATION_REQUEST)) {
            response = DEVICE_INFORMATION_RESPONSE;
        } else if (command.equals(POWER_CHANGE_REQUEST)) {
            response = "0000";
        } else if (command.equals(POWER_INFORMATION_REQUEST)) {
            response = POWER_INFORMATION_RESPONSE;
        } else if (command.equals(STICK_INITIALISE_REQUEST)) {
            response = STICK_INITIALISE_RESPONSE;
        }
        return response;
    }

    private synchronized String sendCommand(String command, String address, String parameters) {
        String response = null;
        String message = "";
        if (command != null) {
            message = String.valueOf(message) + command;
        }
        if (address != null) {
            message = String.valueOf(message) + this.startAddress + address;
        }
        if (parameters != null) {
            message = String.valueOf(message) + parameters;
        }
        if (ERROR_DEBUG) {
            Activator.logNote("sendCommand", "sending '" + this.formatBuffer(message) + "'");
        }
        String crc = this.getCRCString(message);
        String request = PROTOCOL_HEADER + message + crc + PROTOCOL_TRAILER;
        byte[] bytes = this.stringToBytes(request);
        int retryCount = 0;
        while (response == null) {
            try {
                ++retryCount;
                this.outputStream.write(bytes);
                this.wait(1);
                response = this.receiveData(command);
                if (response != null) continue;
                if (retryCount >= this.retryLimit) {
                    Activator.logError("sendCommand", "retry limit reached with " + this.commandName(command) + " for " + this.deviceName(address));
                    break;
                }
                if (!ERROR_DEBUG) continue;
                Activator.logNote("sendCommand", "retrying " + this.commandName(command) + " for " + this.deviceName(address));
            }
            catch (IOException exception) {
                Activator.logError("sendCommand", "could not send message - " + exception);
            }
        }
        return response;
    }

    private void setPolling() {
        long powerStart;
        this.pollTimer = new Timer();
        this.clockTask = new PollTask(CLOCK_TASK);
        long clockStart = 0L;
        long clockPeriod = 86400000 * this.energyInterval;
        this.pollTimer.scheduleAtFixedRate((TimerTask)this.clockTask, clockStart, clockPeriod);
        this.energyTask = new PollTask(ENERGY_TASK);
        Calendar energyStart = Calendar.getInstance();
        energyStart.add(10, 1);
        energyStart.set(12, 1);
        energyStart.set(13, 0);
        long energyPeriod = 60000 * this.energyInterval;
        this.pollTimer.scheduleAtFixedRate((TimerTask)this.energyTask, energyStart.getTime(), energyPeriod);
        this.powerTask = new PollTask(POWER_TASK);
        long powerPeriod = powerStart = (long)(60000 * this.powerInterval);
        this.pollTimer.scheduleAtFixedRate((TimerTask)this.powerTask, powerStart, powerPeriod);
    }

    public void startThreads() {
        Thread calibrationThread = new Thread(){

            @Override
            public void run() {
                Enumeration circleAddresses = PlugwiseTransceiver.this.sensorMapping.keys();
                while (circleAddresses.hasMoreElements()) {
                    Calibration calibration;
                    String circleAddress = (String)circleAddresses.nextElement();
                    if (ERROR_DEBUG) {
                        Activator.logNote("startThreads", "getting calibration for " + PlugwiseTransceiver.this.deviceName(circleAddress));
                    }
                    if ((calibration = PlugwiseTransceiver.this.requestCalibration(circleAddress)) == null) {
                        calibration = PlugwiseTransceiver.this.calibrationDefault;
                    }
                    PlugwiseTransceiver.this.calibrationMapping.put(circleAddress, calibration);
                }
                PlugwiseTransceiver.this.setPolling();
            }
        };
        calibrationThread.start();
    }

    private byte[] stringToBytes(String text) {
        int count = text.length();
        byte[] bytes = new byte[count];
        int i = 0;
        while (i < count) {
            byte value;
            char ch = text.charAt(i);
            bytes[i] = value = (byte)(ch & 0xFF);
            ++i;
        }
        return bytes;
    }

    private void wait(int wait) {
        try {
            Thread.sleep(1000 * wait);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public class PollTask
    extends TimerTask {
        private String taskType;

        public PollTask(String taskType) {
            this.taskType = taskType;
        }

        @Override
        public void run() {
            PlugwiseTransceiver.this.pollCircles(this.taskType);
        }
    }
}

