package uk.ac.stir.cs.PlugwiseDriver;

/**
  Device parameters for PlugwiseDriver.

  @author	Kenneth J. Turner
  @version	1.0: 15/05/11 (KJT)
*/

public class DeviceParameters {

  /** Entity name */
  private String entityName;

  /** Entity instance */
  private String entityInstance;

  /**
    Constructor for a DeviceParameters object.

    @param entity	entity name
    @param instance	entity instance
  */
  public DeviceParameters(String entity, String instance) {
    entityName = entity;
    entityInstance = instance;
  }

  /**
    Compares current object to the given object.

    @param object	object to be compared
    @return		true if equal
  */
  public boolean equals(Object object) {
    boolean result = false;
    if (object != null && object.getClass().equals(this.getClass())) {
      DeviceParameters triggerParameters = (DeviceParameters) object;
      result =
	triggerParameters.getEntityName().equals(entityName) &&
	triggerParameters.getEntityInstance().equals(entityInstance);
    }
    return(result);
  }

  /**
    Return the hash code for the trigger parameters.

    @return	hash code
  */
  public int hashCode() {
    return(17 * entityName.hashCode() + entityInstance.hashCode());
  }

  /**
    Return the entity instance.

    @return	entity instance
  */
  public String getEntityInstance() {
    return(entityInstance);
  }

  /**
    Return the entity name.

    @return	entity name
  */
  public String getEntityName() {
    return(entityName);
  }

  /**
    Set the entity instance.

    @param instance	entity instance
  */
  public void setEntityInstance(String instance) {
    entityInstance = instance;
  }

  /**
    Set the entity name

    @param entity	entity name
  */
  public void setEntityName(String entity) {
    entityName = entity;
  }

}

