package uk.ac.stir.cs.PlugwiseDriver;

import java.util.Hashtable;
import java.util.Map;

import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventConstants;

/**
  OSGi event administration service for PlugwiseDriver.

  @author	Kenneth J. Turner
  @version	1.0: 15/05/11 (KJT)
*/
public class EventAdminPostEventService implements PostEventService {

  private EventAdmin eventAdmin;

  /**
    Constructor for the EventAdminPostEventService object.

    @param admin	event admin
  */
  public EventAdminPostEventService(EventAdmin admin) {
    eventAdmin = admin;
  }

  /**
    Create and post event.

    @param eventTopic	event topic
    @param properties	properties
  */
  public void postEvent(String eventTopic,
   Hashtable<String, Object> properties) {
    if (eventAdmin != null) {
      if (properties != null) {
	properties.put(
	  EventConstants.TIMESTAMP, new Long(System.currentTimeMillis()));
	Event event = setupEvent(eventTopic, properties);
	eventAdmin.postEvent(event);
      }
      else
	Activator.logError("no event properties for posting event");
    }
    else
      Activator.logError("no event admin for posting event");
  }

  /**
    Set up event.

    @param eventTopic	event topic
    @param properties	properties
    @return		event
  */
  private Event setupEvent(String eventTopic, Map<String,Object> properties) {
    Event event = new Event(eventTopic, properties);
    return(event);
  }

}

