package uk.ac.stir.cs.PlugwiseDriver;

import java.util.Hashtable;

import org.osgi.framework.BundleContext;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

/**
  Plugwise action handler.

  @author	Kenneth J. Turner
  @version	1.0: 15/05/11 (KJT)
*/
public class PlugwiseAction implements EventHandler {

  /** Action mapping (entity name/instance to Circle address) */
  private Hashtable<DeviceParameters, String> actionMapping;

  /** Plugwise receiver instance */
  private PlugwiseTransceiver plugwiseTransceiver;

  /**
    Constructor for a PlugwiseAction object.

    @param context		bundle context
    @param actionMapping	action mapping
    @param actionMapping	action mapping
  */
  public PlugwiseAction(BundleContext context,
   PlugwiseTransceiver plugwiseTransceiver,
   Hashtable<DeviceParameters, String> actionMapping) {
    this.plugwiseTransceiver = plugwiseTransceiver;
    this.actionMapping = actionMapping;
  }

  /**
    Return event property value.

    @param event	event
    @param property	property name
    @return		property value ("" if missing)
  */
  public String getProperty(Event event, String property) {
    String value = (String) event.getProperty(property);
    if (value == null)
      value = "";
    return(value);
  }

  /**
    Handle Plugwise action event. Ignore this if the entity name/instance in the
    event are not found in the mapping (e.g. the action refers to a device
    handled by a different driver).

    @param event	event
  */
  public void handleEvent(Event event) {
    String messageType = getProperty(event, "arg1");
    String entityName = getProperty(event, "arg2");
    String entityInstance = getProperty(event, "arg3");
    DeviceParameters deviceParameters =
      new DeviceParameters(entityName, entityInstance);
    String circleAddress = actionMapping.get(deviceParameters);
    if (circleAddress != null) {		// entity name/instance mapped?
      if (messageType.equals("off"))
	plugwiseTransceiver.requestChange(circleAddress, false);
      else if (messageType.equals("on"))
	plugwiseTransceiver.requestChange(circleAddress, true);
      else
	Activator.logError("handleEvent",
	  "unknown message type '" + messageType + "'");
    }
  }

}

