package uk.ac.stir.cs.PlugwiseDriver;

import java.util.Hashtable;

/**
  The interface to the PostEventService.

  <p>
    In the MATCH project, the policy server communicates with the managed system
    through sending and receiving events. This interface is defined to enable
    changing the event service provider. The EventAdmin service is provided by
    the OSGi platform (version 4).
  </p>

  @author	Kenneth J. Turner
  @version	1.0: 15/05/11 (KJT)
*/
public interface PostEventService {

  /**
    Notify event.

    @param eventTopic	event topic
    @param properties	event properties
  */
  public void postEvent(String eventTopic, Hashtable<String,Object> properties);

}

