package uk.ac.stir.cs.terrawiz;

import java.awt.*;
import java.awt.event.*;

import javax.swing.*;

/**
  Class for initializing settings such as language and mode. A settings file is
  created in the user's home directory ('My Documents' under Microsoft Windows).

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class Initialize extends JFrame implements ActionListener {

  // widgets
  private JLabel labLang, labNote;
  private JRadioButton radioEN, radioCN, radioBeginner, radioAdvanced;
  private JButton btnSelect, btnExit;
  private ButtonGroup aButtonGroup;
  private JPanel panelUp, panelDown;

  // modes
  private Advanced advanced;
  private Beginner beginner;

  /** Construct initialization object. */

  public Initialize() {
    this.setTitle(Common.initTitle);
    this.setSize(Common.initWidth, Common.initHeight);
    int w = (Toolkit.getDefaultToolkit().getScreenSize().width -
      Common.initWidth) / 2;
    int h = (Toolkit.getDefaultToolkit().getScreenSize().height -
      Common.initHeight) / 2;
    this.setLocation(w, h);			// centre window on screen
    createGUI();
    this.pack();				// pack widgets
    this.setVisible(true);
  }

  /** Create GUI. */

  private void createGUI() {

    // disable the close button
    setDefaultCloseOperation(JDialog.DO_NOTHING_ON_CLOSE);
    setResizable(false);			// set window not resizable
    Container window = getContentPane();
    window.setLayout(new BorderLayout());

    // set the icon
    ImageIcon titleIcon = new ImageIcon(Common.iconPath);
    setIconImage(titleIcon.getImage());

    // panel for buttons
    panelDown = new JPanel();
    panelDown.setPreferredSize(new Dimension(400, 50));
    panelDown.setLayout(new FlowLayout());

    // panel for options
    panelUp = new JPanel();
    panelUp.setPreferredSize(new Dimension(400, 300));
    panelUp.setLayout(new GridBagLayout());
    GridBagConstraints constraints = new GridBagConstraints();

    // language setting
    labLang = new JLabel("Please select your language and mode.");
    constraints.anchor = GridBagConstraints.WEST;
    constraints.gridx = 0;
    constraints.gridy = 0;
    constraints.gridwidth = 4;
    panelUp.add(labLang, constraints);

    // constraints
    constraints.gridwidth = 1;
    constraints.gridx = 0;
    constraints.gridy = 1;
    panelUp.add(new Label(), constraints);
    constraints.gridx = 0;
    constraints.gridy = 2;
    panelUp.add(new Label(), constraints);
    constraints.gridx = 0;
    constraints.gridy = 3;
    panelUp.add(new Label(), constraints);

    // English option
    radioEN = new JRadioButton("English");
    constraints.gridx = 1;
    constraints.gridy = 4;
    panelUp.add(radioEN, constraints);

    // Chinese option
    radioCN = new JRadioButton("中     文");
    constraints.gridx = 1;
    constraints.gridy = 5;
    panelUp.add(radioCN, constraints);

    aButtonGroup = new ButtonGroup();
    aButtonGroup.add(radioEN);
    aButtonGroup.add(radioCN);

    // constraints
    constraints.gridx = 2;
    constraints.gridy = 4;
    panelUp.add(new Label("          "), constraints);
    constraints.gridx = 2;
    constraints.gridy = 5;
    panelUp.add(new Label("          "), constraints);

    // beginner mode
    radioBeginner = new JRadioButton("Beginner");
    constraints.gridx = 3;
    constraints.gridy = 4;
    panelUp.add(radioBeginner, constraints);

    // advanced mode
    radioAdvanced = new JRadioButton("Advanced");
    constraints.gridx = 3;
    constraints.gridy = 5;
    panelUp.add(radioAdvanced, constraints);

    aButtonGroup = new ButtonGroup();
    aButtonGroup.add(radioBeginner);
    aButtonGroup.add(radioAdvanced);

    // constraints
    constraints.gridx = 0;
    constraints.gridy = 6;
    panelUp.add(new Label(), constraints);
    constraints.gridx = 0;
    constraints.gridy = 7;
    panelUp.add(new Label(), constraints);

    // note
    constraints.anchor = GridBagConstraints.WEST;
    labNote = new JLabel("<html>" +
      "<p>Note:</p>" +
      "<p>These options appear only on the first running.</p>" +
      "<p>You can change the settings later on.</p>" +
      "</html>");
    labNote.setForeground(Color.GRAY);
    constraints.gridwidth = 5;
    constraints.gridx = 0;
    constraints.gridy = 8;
    panelUp.add(labNote, constraints);

    // buttons
    btnSelect = new JButton("Next");
    btnSelect.addActionListener(this);
    panelDown.add(btnSelect);

    btnExit = new JButton("Exit");
    btnExit.addActionListener(this);
    panelDown.add(btnExit);

    window.add("North", panelUp);
    window.add("South", panelDown);
  }

  /**
    Respond to action event.

    @param e  action event
  */

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == btnSelect) {
      if (radioBeginner.isSelected()) {
	this.setVisible(false);			// hide initialize window
	if (radioEN.isSelected())
	  beginner = new Beginner("en-GB");	// beginner mode with English
	else if (radioCN.isSelected())
	  beginner = new Beginner("zh-CN");	// beginner mode with Chinese
	beginner.setVisible(true);		// show beginner window
      }
      else if (radioAdvanced.isSelected()) {
	this.setVisible(false);			// hide initialize window
	if (radioEN.isSelected())
	  advanced = new Advanced("en-GB");	// advanced mode with English
	else if (radioCN.isSelected())
	  advanced = new Advanced("zh-CN");	// advanced mode with Chinese
	advanced.setVisible(true);		// show advanced window
      }
    }
    else if (e.getSource() == btnExit)
      System.exit(0);				// exit application
  }

}

