package uk.ac.stir.cs.terrawiz;

import java.io.IOException;

import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/**
  Class for loadings settings such as language and mode. A settings file is
  found in the user's home directory ('My Documents' under Microsoft Windows).

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class LoadSetting {
  private DOMParser parser;
  private String homeDirectory;
  private String settingsFullPath;
  private Document domSetting;
  private Element rootSetting;

  /** Construct a LoadSetting object. */

  public LoadSetting() {
  }

  /**
    Load settings.

    @param fileName	settings file name
    @return		+1 if advanced settings loaded, 0 if beginner settings
			loaded, -1 if settings not loaded
  */

  public int loadSettingDOM(String fileName) {
    parser = new DOMParser();
    try {
      homeDirectory = System.getProperty("user.home");
      settingsFullPath = homeDirectory + fileName;
      parser.parse(settingsFullPath);
    }
    catch (SAXException e1) {
      return -1;
    }
    catch (IOException e1) {
      return -1;
    }

    domSetting = parser.getDocument();
    rootSetting = domSetting.getDocumentElement();
    NodeList nodeList1 = rootSetting.getElementsByTagName("Mode");
    if (nodeList1.item(0).getFirstChild().getNodeValue().equals(
	  "Beginner"))
      return 0;
    else if (nodeList1.item(0).getFirstChild().getNodeValue().equals(
	       "Advanced"))
      return 1;
    return -1;
  }

}

