/**
 * This is the banner class.<br/>
 * It shows a banner with specific seconds.<br/>
 * After that,it will decide next step (initialize language and mode, enter into
 * Beginner mode, or enter into Advanced mode) according to the setting file.
 * <br/>
 *
 */
package uk.ac.stir.cs.terrawiz;

import java.awt.*;
import java.awt.event.*;
import java.net.URL;

import javax.swing.*;

/**
  Class for displaying splash screen. After that, it will decide the next step
  according to the settings file: initialize language and mode, enter into
  beginner mode, or enter into advanced mode).

  @author	Tao (Fred) Lu, Kenneth J. Turner
  @version	1.0 (6th April 2009)
*/

public class TerraWiz extends JFrame implements ActionListener {

  /** How long the banner is shown */
  private Timer timer = new Timer(Common.bannerTime, this);

  /** Logo panel */
  private JPanel panelLogo;

  /** LoadSetting object */
  private LoadSetting loadSetting;

  /**
    The main program for the TerraWiz class.

    @param args		command-line arguments
  */

  public static void main(String[] args) {
    TerraWiz wizard = new TerraWiz();
    wizard.setSize(Common.startupWidth, Common.startupHeight);
    int w = (Toolkit.getDefaultToolkit().getScreenSize().width -
      Common.startupWidth) / 2;
    int h = (Toolkit.getDefaultToolkit().getScreenSize().height -
      Common.startupHeight) / 2;
    wizard.setLocation(w, h);			// centre window on screen
    wizard.createGUI();				// create GUI
    wizard.setVisible(true);			// show window
  }

  /** Create GUI. */

  private void createGUI() {
    setDefaultLookAndFeelDecorated(true);
    setUndecorated(true);			// no control menu
    setDefaultCloseOperation(EXIT_ON_CLOSE);	// exit app on close button

    ImageIcon titleIcon = new ImageIcon(getResource(Common.iconPath));
    setIconImage(titleIcon.getImage());

    Container window = getContentPane();
    // draw startup banner in a panel
    panelLogo = new PicPanel("res/banner.png", 0);
    window.add(panelLogo);
    timer.start();
  }

  /**
    Respond to action event.

    @param e  action event
  */

  public void actionPerformed(ActionEvent e) {
    if (e.getSource() == timer) {
      timer.stop();
      this.setVisible(false);			// hide the banner
      loadSetting = new LoadSetting();

      // loadSettingDOM and return an integer:
      // +1 for Advanced mode, 0 for Beginner mode,
      // -1 for no setting (first time running)
      int setting = loadSetting.loadSettingDOM(Common.settingsFile);
      if (setting == 0)
	new Beginner();
      else if (setting == 1)
	new Advanced();
      else if (setting == -1)
	new Initialize();
    }
  }

  /**
    Get URL for resource/library file.

    @param fileName	file name relative to program base directory
    @return		file input stream
  */

  private URL getResource(String fileName) {
    return(getClass().getClassLoader().getResource(fileName));
  }

}

