# define PUBLIC
# define SHARED  extern
# define PRIVATE static

/*****  Includes  *****/
# include <stdio.h>
# include <assert.h>
# include <ctype.h>
# include "rag.hh"
# include "nodes.h"

/*****  constants  *****/
# define c_grnl		1
# define c_lexv		2
# define c_line		3
# define c_ll		4

#ifndef TRUE
# define FALSE 0
# define TRUE  1
#endif

/*****  exported types  *****/
typedef struct stname {
        int     name;
        int*    line;
        char*   ckey;
        char*   cval;
        } yystype;

typedef struct  {
        int     type;
        yystype yylval;
        } token;

/*****  exported variables  *****/
SHARED  char    sfile[BUFSIZ];
SHARED  int     nfname;

SHARED  FILE*   sfp;            /* source file */
SHARED  FILE*   lfp;            /* listing file */
SHARED  FILE*   cfp;            /* comment file */

SHARED  int     yydebug;
SHARED  int     lexdebug;
SHARED	int	flagp;
SHARED	int	flagc;
SHARED	int	flage;

SHARED  char*   progname;
SHARED	int	errorcount;

SHARED  HT      hidtbl; /* for SymbolTable */
SHARED  IAT*    grnl;

/*****  exported functions  *****/

PUBLIC token*
gtk ();

PUBLIC TNODE*
bast ();

PUBLIC char*
emalloc ();

PUBLIC FILE*
efopen  ();

/*****  *****/
