/***********************************************************************
     "err_handl.o": ERRor HANDLing functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: err_handl.c,v $
 * Revision 1.5  1993/01/12  18:18:34  eps
 * portability issues
 *
 * Revision 1.4  1993/01/12  16:37:01  eps
 * portability issues
 *
 * Revision 1.3  1992/05/06  17:28:49  eps
 * shut up lint complaints about exit()
 *
 * Revision 1.2  92/01/14  15:45:35  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:50:47  eps
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

#ifndef lint
static char rcsid[]= "$Id: err_handl.c,v 1.5 1993/01/12 18:18:34 eps Exp $";
#endif

/* LINTLIBRARY */

#define err_handl_IMP

#include <stdio.h>
#include <stdarg.h>
#include "bsc_dcls.hh"
#include "lnt_pass.hh"
#include "err_handl.hh"


/* prints an error message with a varargs argument list */

#define vprint_error(msg, args)				\
	{						\
	  if (prog_name != NULL &&			\
	      *prog_name != '\0')			\
	    (void) fprintf(stderr, "%s: ", prog_name);	\
	  (void) vfprintf(stderr, msg, args);		\
	  (void) fprintf(stderr, "\n");			\
	}

PUBLIC void xerror (int xcode, char *msg, ...)
{
  va_list args;
  va_start(args, msg);
  vprint_error(msg, args);
  va_end(args);
  if (xcode == 0)
    return;
  else
    exit(xcode);
}

PUBLIC void berror (char *msg, ...)
{
  va_list args;
  va_start(args, msg);
  vprint_error(msg, args);
  va_end(args);
  abort();
}

PUBLIC void error (char *msg, ...)
{
  va_list args;
  va_start(args, msg);
  vprint_error(msg, args);
  va_end(args);
  exit(1);
}
