#ifndef mem_alloc_HH
#define mem_alloc_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "mem_alloc.hh": MEMory ALLOCation functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: mem_alloc.desc,v $
 * Revision 1.6  1993/01/12  18:32:50  eps
 * use free from stdlib
 *
 * Revision 1.5  1993/01/12  18:18:26  eps
 * portability issues
 *
 * Revision 1.4  1993/01/12  16:36:35  eps
 * portability issues
 *
 * Revision 1.3  1992/09/02  14:28:24  eps
 * remove casts in LHS of assignments
 *
 * Revision 1.2  92/01/14  15:45:11  eps
 * distribution issues
 * 
 * Revision 1.1  91/07/11  12:48:58  eps
 * Initial revision
 * 
 ***********************************
 $Id: mem_alloc.desc,v 1.6 1993/01/12 18:32:50 eps Exp $
 ***********************************/


/* allocates typed memory and if cannot, writes a message and exits */

void _alloc_error();

#define _talloc(lptr, rptr, nelem)				\
	  (((lptr)= ALIN(void, malloc((unsigned)		\
				      sizeof(*(rptr)) *		\
				      (nelem)))) == NULL?	\
	     _alloc_error(): NOOP()				\
	  )

#ifndef lint
#  define talloc(ptr, nelem)	_talloc(ptr, ptr, nelem)
#else
#  define talloc(ptr, nelem)	_talloc(ALIN(void, ptr), ptr, nelem)
#endif

/* reallocates typed memory and if cannot, writes a message and exits */

void _alloc_error();

#define _trealloc(lptr, rptr, nelem)				\
	  (((lptr)= ALIN(void, realloc(ALIN(char, rptr),	\
				       (unsigned)		\
				       sizeof(*(rptr)) *	\
				       (nelem)))) == NULL?	\
	     _alloc_error(): NOOP()				\
	  )

#ifndef lint
#  define trealloc(ptr, nelem)	_trealloc(ptr, ptr, nelem)
#else
#  define trealloc(ptr, nelem)	_trealloc(ALIN(void, ptr), ptr, nelem)
#endif

/* releases a previously allocated typed memory */

#define tfree(ptr)	((void) free(ALIN(char, ptr)))
#endif
