#ifndef rec_query_HH
#define rec_query_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "rec_query.hh": RECord QUERY functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************
 $Log: rec_query.desc,v $
 * Revision 1.3  1993/01/12  16:36:54  eps
 * portability issues
 *
 * Revision 1.2  1992/01/14  15:45:25  eps
 * distribution issues
 *
 * Revision 1.1  91/07/11  12:50:29  eps
 * Initial revision
 * 
 ***********************************
 $Id: rec_query.desc,v 1.3 1993/01/12 16:36:54 eps Exp $
 ***********************************/

#include "rec_basic.hh"


/* returns the type of a field */

#define fldty(rec, ndx)					\
	  eval_if((rec) != NULL &&			\
	          (rec)->fld != NULL &&			\
		  1 <= EVAL(ndx) && (ndx) <= (rec)->NF,	\
		  (rec)->fld[ndx].FT)

/* returns a field of a record */

#define field(rec, ndx, type)					\
	  eval_if((rec) != NULL &&				\
	          (rec)->fld != NULL &&				\
		  1 <= EVAL(ndx) && (ndx) <= (rec)->NF &&	\
		  (rec)->fld[ndx].FT == type,			\
		  (rec)->fld[ndx].F.type)

/* returns the number of fields of a record */

#define nofld(rec)	eval_if((rec) != NULL, ((rec)->NF))

/* returns the number of a record */

#define recno(rec)	eval_if((rec) != NULL, ((rec)->NR)
#endif
