/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: astio.c,v $
 * Revision 2.3  1993/01/12  16:33:58  eps
 * portability issues
 *
 * Revision 2.2  1992/01/14  15:42:40  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:32:03  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 *
 * Revision 1.5  90/03/16  15:41:00  eps
 * minor beautifying
 *
 * Revision 1.4  90/02/19  19:05:30  eps
 * call new_node for memory allocation
 *
 * Revision 1.3  90/02/12  10:52:41  eps
 * save and restore made iterative
 * (as much as possible)
 * plus miscellaneous cleanup
 *
 * Revision 1.2  90/01/29  14:51:20  eps
 * fixing license details
 *
 * Revision 1.1  90/01/25  17:58:58  eps
 * Initial revision
 *
 **********************************************/

#ifndef lint
static char rcsid[]= "$Id: astio.c,v 2.3 1993/01/12 16:33:58 eps Exp $";
#endif

/***********************************************************************
	Tomas P. de Miguel Moro
	Jose A. Manas
	dpt. Ingenieria Telematica
	E.T.S.I. Telecomunicacion
	Ciudad Universitaria
	E-28040  MADRID

	tmiguel@dit.upm.es
	jmanas@dit.upm.es
 **********************************************************************/

/* LINTLIBRARY */

# define cast_IMP
# include "cast.hh"

# include <stdio.h>

#define BROTHER	2
#define SON	4

PUBLIC void
save_tree (fp, tree)
  FILE* fp;
  TNODE* tree;
{
  char pntrs;
  TNODE* tb;
  TNODE* ts;

  while (tree != NULL) {
    tb= tree->brothers;
    ts= tree->sons;
    pntrs= '@';
    if (tb != NULL)
      pntrs |= BROTHER;
    if (ts != NULL)
      pntrs |= SON;
    (void) fprintf (fp, "%d%c", tree->type, pntrs);
    putattrs (fp, tree); /* up to a new.line */

    if (tb != NULL)
      save_tree (fp, tb);
    tree= ts;
  }
} /* end of save_tree */

PRIVATE TNODE*
restor_node (fp)
  FILE* fp;
{
  TNODE* nodep;
  int c;

  nodep= new_node (0);
  (void) fscanf (fp, "%d", &(nodep->type));
  c= getc (fp);
  nodep->brothers= (c & BROTHER) ? (TNODE*) TRUE : NULL;
  nodep->sons=     (c & SON)     ? (TNODE*) TRUE : NULL;
  nodep->attrs= NULL;
  getattrs (fp, nodep); /* reads until end of line */
  return nodep;
} /* end of restor_node */

PRIVATE void
restor_tree (fp, root)
  FILE* fp;
  TNODE* root;
{
  TNODE* newp;

  while (root != NULL) {
    if (root->brothers) {
      newp= root->brothers= restor_node (fp);
      newp->father= root->father;
      restor_tree (fp, newp);
    }
    if (root->sons) {
      newp= root->sons= restor_node (fp);
      newp->father= root;
    }
    root= root->sons;
  }
} /* end of restor_tree */

PUBLIC TNODE*
restore(fp)
  FILE* fp;
{
  TNODE* root;

  if ((root= restor_node (fp)) == NULL)
    return NULL;
  root->father= NULL;
  restor_tree (fp, root);
  return root;
} /* end of restore */
