/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: clrlib.c,v $
 * Revision 2.3  1993/01/12  16:34:17  eps
 * portability issues
 *
 * Revision 2.2  1992/01/14  15:42:54  eps
 * distribution issues
 *
 * Revision 2.1  90/10/30  08:32:25  eps
 * hardwired colours added
 * new colours I2, IAT, AT
 * ! is no longer used as colour delimiter
 * still some bugs are known w.r.t. colour deallocation
 *
 * Revision 1.4  90/03/16  15:51:09  eps
 * new funtion fadd_attr
 * new_attr () allocates memory in chunks of 128 records
 *
 * Revision 1.3  90/02/19  19:11:43  eps
 * buck allocation of memory
 * new function set_attr
 * attributes are freed iteratively, rather than recursively
 *
 * Revision 1.2  90/01/29  14:51:43  eps
 * fixing license details
 *
 * Revision 1.1  90/01/25  17:59:48  eps
 * Initial revision
 *
 **********************************************/

#ifndef lint
static char rcsid[]= "$Id: clrlib.c,v 2.3 1993/01/12 16:34:17 eps Exp $";
#endif

/***********************************************************************
	Tomas P. de Miguel Moro
	Jose A. Manas
	dpt. Ingenieria Telematica
	E.T.S.I. Telecomunicacion
	Ciudad Universitaria
	E-28040  MADRID

	tmiguel@dit.upm.es
	jmanas@dit.upm.es

	colouring management
 **********************************************************************/

/* LINTLIBRARY */

# define cast_IMP
# include "cast.hh"

# include <stdio.h>
# include <string.h>

PUBLIC TATTR*
add_attr (attr, nodep)
     int attr;
     TNODE* nodep;
{
  TATTR *p, *q;

  if (nodep == NULL)
    return NULL;
  if (nodep->attrs == NULL) {
    q= new_attr ();
    q->atype= attr;
    nodep->attrs= q;
    q->next= NULL;
    return q;
  }
  else {
    p= nodep->attrs;
    for (;;) {
      if (p->atype == attr)
	if (attr != others) /* others for extra colours */
	  return NULL;
      if (p->next == NULL) {
	q= new_attr ();
	q->atype= attr;
	p->next= q;
	q->next= NULL;
	return q;
      }
      p= p->next;
    }
  }
}

PUBLIC void
set_attr (attr, nodep, val)
     int attr;
     TNODE* nodep;
     CLR_TYPE val;
{
  TATTR* p;

  if ((p= add_attr (attr, nodep)) == NULL) {
    (void) fprintf (stderr, "set_attr, duplicated colour\n");
    exit (1);
  }
  p->value= val;
}

PUBLIC TATTR*
find_attr (attr, nodep)
     int attr;
     TNODE* nodep;
{
  TATTR* p;

  if (nodep == NULL)
    return NULL;
  for (p= nodep->attrs; p != NULL; p= p->next)
    if (p->atype == attr)
      return p;
  return NULL;
}

PUBLIC TATTR*
fadd_attr (attr, nodep)
     int attr;
     TNODE* nodep;
{
  TATTR *p, *q;

  if (nodep == NULL)
    return NULL;
  if (nodep->attrs == NULL) {
    q= new_attr ();
    nodep->attrs= q;
  }
  else {
    for (q= nodep->attrs; q != NULL; q= q->next)
      if (q->atype == attr)
	return q;
      else
	p= q;
      q= new_attr ();
      p->next= q;
  }
  q->atype= attr;
  q->value= NULL;
  q->next= NULL;
  return q;
}

PUBLIC TATTR*
take_attr (attr, nodep)
     int attr;
     TNODE* nodep;
{
  TATTR *p, *q;

  if (nodep == NULL)
    return NULL;
  p= nodep->attrs;
  if (p == NULL)
    return NULL;
  if (p->atype == attr) {
    q= p;
    nodep->attrs= q->next;
    q->next= NULL;
    return q;
  }
  for (p= nodep->attrs; p->next != NULL; p= p->next)
    if (p->next->atype == attr) {
      q= p->next;
      p->next= q->next;
      q->next= NULL;
      return q;
    }
  return NULL;
}

