/***********************************************
 (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   EPS General Public License (see file LICENSE)
 ***********************************************
 $Log: swbus.h,v $
 * Revision 2.7  1993/01/12  16:36:04  eps
 * portability issues
 *
 * Revision 2.6  1992/11/17  11:48:41  eps
 * fix definition of *alloc for PC portability
 *
 * Revision 2.5  1992/05/06  17:27:14  eps
 * shut up lint complaints about exit()
 *
 * Revision 2.4  92/01/14  15:44:22  eps
 * distribution issues
 * 
 * Revision 2.3  92/01/14  15:27:39  eps
 * adapt to case independent cast
 * 
 * Revision 2.2  91/04/10  10:04:07  eps
 * adapted for HP
 * 
 * Revision 2.1  90/10/30  08:40:42  eps
 * lag + rag -> lag
 * allowed productions are simplified (i.e. reduced)
 * 
 **********************************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

/*****  Includes  *****/

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <assert.h>
# include "cast.hh"
# include "rag.hh"
# include "nodes.h"

/*****  constants  *****/

# define c_grn          0
# define c_class        1
# define c_lexv         2
# define c_line         3
# define c_ll           4
# define c_grnl         5
# define c_nrule        6
# define c_type         7
# define c_nterms       8
# define c_nsec         9
# define c_intid        10
# define c_tndx         11
# define c_ndid         12
# define c_ngrc         13
# define c_idgrc        14
# define c_rlhs         15
# define c_start        16
# define c_block        17

# define ST_SIZE	100

# define lfclr(clr, nd) (find_attr (clr, nd) != NULL)

# define R_EMPTY        0
# define R_PHYLA        1
# define R_NODE         (1 << 1)
# define R_REPP         (1 << 2)
# define R_REPA         (1 << 3)
# define R_REPP_SEP     (1 << 4)
# define R_REPA_SEP     (1 << 5)
# define R_SEC          (1 << 6)
# define R_SEC_PH       (1 << 7)
# define R_SEC_TERM     (1 << 8)
# define R_OPT          (1 << 9)

/*****  exported types  *****/

typedef struct stname {
        int	name;
        int*	line;
        } yystype;

typedef struct  {
        int     type;
        yystype yylval;
        } token;

/*****  exported variables  *****/

/* KJT 12/02/12: Omitted
SHARED	char    sfile[BUFSIZ];
SHARED	char    lfile[BUFSIZ];
SHARED	char    cfile[BUFSIZ];
*/

SHARED	char    filename[BUFSIZ];
SHARED	int     nfname;

SHARED	FILE*   sfp;
SHARED	FILE*   lfp;
SHARED	FILE*   fgrm;
SHARED	FILE*   fgrc;
SHARED	FILE*   fndl;

SHARED	ST*     idlist;

SHARED	int     flagc;
SHARED	int     flage;
SHARED	int     flagl;
SHARED	int     flagp;
SHARED	int     flagd;

SHARED  int     errorcount;
// KJT 12/02/12: Omitted SHARED  int     lineno;
SHARED  int     pos;
SHARED  int     fcomm;
SHARED  char*   comm;
SHARED  ST*     blocktbl;
SHARED  char*   block;

SHARED int	nrules;

SHARED	HT	hidtbl;
SHARED	IT*	term_lis;
SHARED	IT*	ndl;
SHARED	ST*	grcl;


/*****  exported functions  *****/

PUBLIC  int	yyerror ();
PUBLIC  int	pwar ();
PUBLIC  token*	gtk ();
PUBLIC	TNODE*	bast();
PUBLIC	void	linkbrothers ();
PUBLIC	void	psyntax ();
PUBLIC	char*	bintid ();
PUBLIC	void	grheader ();
PUBLIC	void	grtail ();
PUBLIC	int	buildgrc ();
PUBLIC	int	lastgrc ();
PUBLIC	void	actions ();
PUBLIC	void	opena ();
PUBLIC	void	closea ();

/*****  *****/
