/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

#ifndef lint
static char rcsid[]= "$Id$";
#endif

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *
 *  5 Dec 1990
 *
 *  Definition and Management of the meta-bool expressions.
 *  
 *  COMPILATION FLAGS:
 *  
 *  LOG:
 *
 ******************************************************************/

/* LINTLIBRARY */


#include "limisc.h"
#include "baexpr.h"
#include "babool.h"
#include "badefca.h"
#include "batyperw.h"
#include "batables.h"


static int nd_bool, nd_equal, nd_true, nd_false;

/*----------------------------------------------------------------*/

/* InitBool
 * Initialization of this module.
 * This function must be called before a new load.
 */
void InitBool()
{
  nd_bool  = Declare_sort("M_BOOL");
  nd_true  = Declare_opn("M_TRUE",(ListTyp)NULL,nd_bool,FALSE,Create_list());
  nd_false = Declare_opn("M_FALSE",(ListTyp)NULL,nd_bool,FALSE,Create_list());
  nd_equal = Declare_opn("=",(ListTyp)NULL,nd_bool,TRUE,Create_list());
}

/*----------------------------------------------------------------*/

/* IsMetaBool
 * Return TRUE if the operation d is a meta-bool operation.
 */
boolean IsMetaBool( d )
     int d;  
{
  return  ((d == nd_equal) || (d == nd_true) || (d == nd_false));
}

/*----------------------------------------------------------------*/

/* GetBool
 * Return the descriptor of the meta sort meta-bool
 */
int GetBool()
{ 
  return nd_bool;
}

/*----------------------------------------------------------------*/

/* PutBool
 * Store  the name of the meta sort bool.
 */
void PutBool( d )
     int d;
{
  nd_bool = d;
}

/*----------------------------------------------------------------*/

/* GetEqual
 * Return the name of the semantic equality operation (=).
 */
int GetEqual()
{
  return  nd_equal;
}

/*----------------------------------------------------------------*/

/* IsEqual
 * Return true if ve is the meta equal operation.
 */
boolean IsEqual(  ve  )
     ExprTyp  ve;  
{
  boolean res;
  
  LASSERT(ve!=NULL);
  res = IsOperationE(ve) && (GetEqual()==LookNameE(ve));
  return res;
}

/*----------------------------------------------------------------*/

/* MakeEqual
 * Make the expression e1=e2
 */
ExprTyp MakeEqual( e1, e2 )
     ExprTyp  e1;  
     ExprTyp  e2;  
{
  ExprTyp e;
  
  ToMake("MakeEqual");
  e = MakeE(GetEqual(),OperationC);
  AddArgE(e,e1);
  AddArgE(e,e2);
  return FalseIfConst(e);
}

/*----------------------------------------------------------------*/

/* GetTrue
 * Return the name the meta operation TRUE.
 */
int GetTrue()
{
  return nd_true;
}

/*----------------------------------------------------------------*/

/* IsTrue
 * Return TRUE if ve is the meta TRUE operation.
 */
boolean IsTrue(  ve  )
     ExprTyp  ve;  
{
  boolean res;
  
  LASSERT(ve!=NULL);
  res = IsOperationE(ve) && (GetTrue()==LookNameE(ve));
  return res;
}

/*----------------------------------------------------------------*/

/* MakeTrue
 * Make an expression with the meta TRUE operation.
 */
ExprTyp MakeTrue()
{
  ExprTyp e;
  
  e = MakeE(GetTrue(),OperationC);
  return e;
}

/*----------------------------------------------------------------*/

/* GetFalse
 * Return the name of the meta operation FALSE.
 */
int GetFalse()
{
  return nd_false;
}

/*----------------------------------------------------------------*/

/* IsFalse
 * Return true if ve is the meta FALSE operation.
 */
boolean IsFalse(  ve  )
     ExprTyp  ve; 
{
  boolean res;
  
  LASSERT(ve!=NULL);
  res = IsOperationE(ve) && (GetFalse()==LookNameE(ve));
  return res;
}

/*----------------------------------------------------------------*/

/* MakeFalse
 * Make the expression false.bool
 */
ExprTyp MakeFalse()
{
  ExprTyp e;
  
  e = MakeE(GetFalse(),OperationC);
  return e;
}

/*----------------------------------------------------------------*/


