/******************************************************************
 *  (C) Copyright 1994; dit/upm
 *  Distributed under the conditions stated in the
 *  TOPO General Public License (see file LICENSE)
 ******************************************************************
 *  $Log$
 ******************************************************************/

/******************************************************************
 *  
 *  Santiago Pavon Gomez
 *
 *  30 Nov 1990
 *
 *  Elements used in lotos specifications
 *  
 *  COMPILATION FLAGS:
 *  
 *  TYPE DEFINITIONS:
 *  
 *  FUNCTION DEFINITIONS:
 *
 *  LOG:
 *
 ******************************************************************/

#ifndef badefca_H
#define badefca_H


/*
 *  Cell types
 *
 */

#define RelabellingC    0
#define HidingC         1
#define ChoiceC         2
#define PletC           3
#define LetC            4
#define EnablingC       5
#define DisablingC      6
#define ParallelC       7
#define AlternativeC    8
#define GuardC          9
#define GateC          10
#define IC             11
#define ExitC          12 
#define StopC          13
#define ProcessInstC   14
#define ProcessDefC    15
#define SpecificationC 16
#define GateChoiceC    17
#define ParC           18

#define BehaviourC     19
#define InterleavedC   20
#define TerminationC   21
#define ContSetC       22

#define TletC          23

/* Number of defined cells is: */
#define N_DEF_CELLS  24


/*
 *  Synchronization types :
 *
 *     INTER_SYNC  -> interleaving.
 *     FULL_SYNC   -> full synchronization.
 *     PART_SYNC   -> synchronization in a gate set.
 *
 */

#define  INTER_SYNC  100
#define  FULL_SYNC   101
#define  PART_SYNC   102


/*
 *  Atributes Types:
 *
 *    GLA   -> Gate List Attribute.
 *    GSA   -> Gate Set Attribute.
 *    PA    -> Predicate Attribute.
 *    ELA   -> Expr List Attribute. 
 *    OLA   -> Offer List Attribute.
 *    RFLA  -> Relab Func List Attribute.
 *    VALA  -> Var Assign List Attribute.
 *    GDLA  -> Gate Declaration List Attribute.
 *    ITCLA -> Interleaved Continuation list Attribute.
 *    SSLA  -> Source Specification Line Attribute
 *    STA   -> Synchronization Tree Attibute.
 *    BHT1A -> Behaviour Hash Table One Attribute.
 *    BHT2A -> Behaviour Hash Table Two Attribute.
 *    TA    -> Time Attribute
 *
 */

#define GLA    0 
#define GSA    1 
#define PA     2 
#define ELA    3 
#define OLA    4 
#define RFLA   5
#define VALA   6
#define GDLA   7

#define ITCLA  8
#define STA    9
#define SSLA  10
#define BHT1A 11
#define BHT2A 12
#define TA    13


/*
 * Number of defined attributes is:
 *
 */

#define N_DEF_ATTRS  14

/* InitLotosK
 * Init the module cell with LOTOS values.
 */
extern void InitLotosK();



#endif










