/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  25-04-91
  
  Repeated Variations calculation for
  gd= ( a[1],...,a[m] in [b[1],..,b[n]] )
  
  This module generates a n-module counter of m digits.
  Each digit is an index in b[].
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  TYPE DEFINITIONS:
  
  FUNCTION DEFINITIONS:
  Initialize_Counter : clears sets number of digits and module of counter
  Increment : increments counter
  
  ************************************/


#include "listdh.h"

#define MAXDIGITS 50   /* Should be >= MAXFORMALGATES */

/* The Counter :
   digits  = number of digits,
   module  = module,
   counter = counter.
   
   Each digit is a position in the array */

extern int counter[MAXDIGITS];


/* Initialize_Counter
 * Clears counter[] & Sets the number of digits for it, and its module.
 */
extern void Initialize_Counter( /* digits, module */);
/*       int digits, module;*/


/* Increment
 * Increments counter ("module"-module).
 * if it succeeds :
 return true
 * If the counter overflows (over "digits" digits)
 *    there is no increment & return false.
 */
extern boolean Increment();


