/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  David Larrabeiti Lopez
  
  18-02-91
  
  Enabling operator one-level expansion.
  
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  ************************************/


#include "limisc.h"
#include "badefca.h"
#include "baattr.h"
#include "eximmed.h"
#include "expre_br.h"


/*----------------------------------------------------------------*/


/* Enabling_Expand
 * Expansion of the Enabling behaviour b.
 *
 *      b = b1 >> b2
 *
 * where b1 is a 1-immediate behaviour.
 */
BehTyp Enabling_Expand( b )
     BehTyp b;
{
  int              NumArg,i;
  ExprListTyp      enabel,chel;
  VarAssignListTyp val;
  OfferListTyp     exitol;
  BehTyp           beh1,beh2,branch,bi,enab,act,preact,let,choice,iact;
  PAttrTyp         ola,sla,sta;
#ifdef TIME 
   PAttrTyp         ta;
#endif 
  LASSERT( LookTypeB(b)==EnablingC );
  
  beh1 = GetArgB(b,1);
  beh2 = GetArgB(b,2);
  
  NumArg = NumArgIB(beh1);
  for ( i=1; i<=NumArg; i++ ) {
    branch = GetArgIB( beh1, i );
    act    = LookActionUB( branch );
    switch ( LookTypeB(act) )
      {
      case TerminationC:
      case StopC:
        break;
	
      case ExitC:
        preact = LookPreActionUB( branch );
        iact = MakeB(-1,IC);
        if ( preact==NULL )
          branch = iact;
        else {
          act = GetArgB( preact, 1 );
          PutArgB( preact, iact, 1 );
        }
        val    = NULL;
        chel   = NULL;
        enabel = (ExprListTyp)LookAInfo(LookA(b,ELA));
        exitol = (OfferListTyp)LookAInfo(LookA(act,OLA));
        while ( exitol != NULL ) {
          if ( LookKindOffer( exitol ) == EXCLAMATION )
            val = AddVAL( val, LookNameE((ExprTyp)LookInfo_list(enabel)),
                         CopyE(LookExprOffer(exitol)) );
          else     /*mse*/
            chel = AddEL( CopyE((ExprTyp)LookInfo_list(enabel)), chel );
          exitol = MvNextOffer( exitol );
          enabel = Next_list(enabel);
        }
        let = NULL;
        if ( val!= NULL ) {
          let = MakeB( 0, LetC );
          PutA( let, MakeA((AttrValueTyp)val,VALA) );
        }
        choice=NULL;
        if ( chel!= NULL ) {
          choice = MakeB( 0, ChoiceC );
          PutA( choice, MakeA((AttrValueTyp)chel,ELA) );
        }
        branch = ConcatUB(ConcatUB(ConcatUB(branch,let),choice),beh2);
#ifdef TIME
	if ( (ta=LookA(act,TA))!=NULL )
	  PutA(iact,ta);
#endif	
        if ( (ola=LookA(act,OLA))!=NULL ){
          /*      Convert_to_AdmirationOL((OfferListTyp)LookAInfo(ola)); */
          PutA( iact, ola );
        }
        
        if ( IS_STEP_EXP ) {
          if ( (sla = LookA(act,SSLA))!=NULL ) {
            PutA( iact, sla );
          }
          if ( (sta = LookA(act,STA))!=NULL ) {
            PutA( iact, sta );
          }
        }
        
        FreeB( act );
        break;
        
      default:
        bi   = GetArgB( act, 1 );
        enab = CopyB( b );
        PutArgB( enab, bi,   1 );
        PutArgB( enab, beh2, 2 );
        PutArgB( act,  enab, 1 );
        break;
      }
    if (NumArg>1)
      PutArgB( beh1, branch, i );
    else {
      beh1 = branch;
    }
  }
  FreeB(b);
  FreeB(beh2);
  return beh1;
}

/*----------------------------------------------------------------*/





