/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/************************************************
  
  Miguel Angel Palomares Ortega   
  
  10-9-1992
  
  This module contains  functions that implement
  a Inverse Expansion algorithm. This decomposition
  will be posible with all type of behaviours 
  (even recursive or deterministic). The behaviours
  will be decomposed into two behaviours that will
  communicate each other with visible and invisible
  (hidden) actions.
  
  
  FUNCTION DEFINITIONS:
  Kdecomp : Decomposes a behaviour into two sub-
  behaviours which jointly evolve with visible
  and invisible communication.
  
  ****************************************************/



#ifndef ie_k_H
#define ie_k_H

#ifdef INVEXP


/*****************************************************
 *
 * Visible and Invisible communication decomposition
 *
 ******************************************************/



/* Kdecomp
 * Decomposes behaviour "b" into two behaviours ,one
 * with gates of "gs1" and the other with gates of 
 * "gs2" and composes these in parallel with visible
 * and invisible communication.
 */ 
extern void Kdecomp(/* b,gs1,gs2 */);
/* BehTyp b; */
/* GateSetTyp gs1,gs2; */


#endif /* INVEXP */

#endif
