/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/*************************************************
  
  Miguel Angel Palomares Ortega   
  
  22-4-1992
  
  This module contains two functions that implement 
  Inverse Expansion algorithms. The restrictions on 
  the behaviour to be decomposed are that no internal
  actions may be present and the behaviour must not
  be recursive (and it must be deterministic if we
  are going to decompose by Visible Communication).      
  
  
  FUNCTION DEFINITIONS:
  VC_nrec : decompose a monolithic behaviour
  into two sub-behaviours which jointly evolve
  with visible communication.   
  
  PI_nrec : decompose a monolithic behaviour
  into two sub-behaviours composed in pure
  interleaving.
  
  
  *******************************************************/



#ifndef ie_nrec_H
#define ie_nrec_H

#ifdef INVEXP


/******************************************************************
 *
 *  constants and type definitions 
 *
 *******************************************************************/


#define NAMESIZE 8           /* size of the processes names */


typedef enum { PIM,           /* refers to Pure Interleaving */
		 VCM } IEmode;  /* refers to Visible Communication */





/*****************************************************************
 *
 *    Pure Interleaving Decomposition
 *
 ******************************************************************/


/* PI_nrec
 * Decompose the behaviour "b" into two sub-behaviours
 * composed in pure interleaving if it is posible: one
 * sub-behaviour with the gates contained in "gs1" and
 * the other with the others gates.
 * If the decomposition is not posible it will be 
 * indicated with a message.
 */
extern void PI_nrec( /* b,gs1 */ );
/* BehTyp b; 
   GateSetTyp gs1; */




/*************************** EXAMPLE *******************************
  
  
  INPUTS:
  
  gs1 = {a,b}
  
  
  b =  a;(c;b;stop
  []
  d;b;stop
  []
  b;(c;stop
  []
  d;stop))
  []
  b;(c;a;stop
  []
  d;a;stop
  []
  a;(c;stop
  []
  d;stop))
  []
  c;(a;b;stop
  []
  b;a;stop)
  []
  d;(a;b;stop
  []
  b;a;stop)
  
  
  
  OUTPUT:
  
  
  (a;b;stop
  []
  b;a;stop)  
  
  |||
  
  (c;stop
  []
  d;stop)
  
  
  ***************************************************************/        




/*****************************************************************
 *
 *    Visible communication Decomposition
 *
 ******************************************************************/

/* VC_nrec
 * Decompose the behaviour "b" into two sub-behaviours
 * communicating with the common gates of "gs1" and 
 * "gs2" if it is posible: one sub-behaviour with the
 * gates contained in "gs1" and the other with the gates
 * of "gs2".
 * If the decomposition is not posible it will be 
 * indicated with a message.
 */
extern void VC_nrec( /* b,gs1,gs2 */ );
/* BehTyp b; 
   GateSetTyp gs1,gs2; */



/*************************** EXAMPLE **************************
  
  
  INPUTS:
  
  gs1 = {a1,a2,c1,c2}
  
  gs2 = {b1,b2,c1,c2}
  
  
  b = a1;c1;(b1;a2;stop
  []
  a2;b1;stop)
  []
  a2;c2;(a1;b2;stop
  []
  b2;a1;stop)
  
  
  
  OUTPUT:
  
  (a1;c1;a2;stop
  []
  a2;c2;a1;stop)
  
  | [c1,c2] |
  
  (c1;b1;stop
  []
  c2;b2;stop)
  
  
  *******************************************************************/


#endif /* INVEXP */

#endif
