/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Miguel Angel Palomares Ortega   
  
  11-11-1992
  
  This module contains  functions that implement Inverse Expansion 
  algorithms. The restrictions on the behaviour to be decomposed are
  that no internal actions may be present and it must be determinis-
  tic. Recursive behaviours can be decomposed.
  
  
  ************************************/



#ifndef ie_vc_H
#define ie_vc_H

#ifdef INVEXP


#include "baattr.h"

#define REST 1
#define SYNCR 3
#define GS1 0
#define GS2 1
#define NUM_DESC 5


typedef int GateSet_Mode;
typedef int Decomp_Mode;


typedef struct { DescriptorTyp rest1;
                 DescriptorTyp rest2;
                 DescriptorTyp sync1;
                 DescriptorTyp sync2;
               } DTableEntryTyp;

typedef   DTableEntryTyp*   DTableTyp;




/* Rec_InvExp
 * Decompose the behaviour "b" into two sub-behaviours communicating with
 * the common gates of "gs1" and "gs2" (if they have , if not , by pure
 * interleaving) if it is posible: one sub-behaviour with the gates contained
 * in "gs1" and the other with the gates of "gs2".
 * If the decomposition is not posible it will be indicated with a message.
 */
extern void Rec_InvExp( /* b,gs1,gs2 */);
/* BehTyp b; */
/* GateSetTyp gs1,gs2; */


#endif /* INVEXP */


#endif
