/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Miguel Angel Palomares Ortega
  
  12-11-1992
  
  This module contains complementary functions which are
  used in the Inverse Expansion algorithms.
  
  
  ************************************/


#ifndef iefunc_H
#define iefunc_H

#ifdef INVEXP


#include "babeh.h"
#include "baattr.h"
#include "lilists.h"


/* Equal_Sortlist
 * Returns the boolean: "list l1 == list l2".
 * The order of the elements must be the same.
 * eq is a function that returns the equality of two elements of the list
 * boolean eq( e1, e2 )
 */
extern boolean Equal_Sortlist( /* l1, l2, eq */ );
/* register ListTyp l1,l2;
   boolean (*eq)();  */



/* Sort_Add_IfNotIn_list
 * Unlike Add_list the element is not Added if it is already in the list.
 * The new element is added sortly (with integer comparison).
 * f == NULL => integer comparison.
 */
extern ListTyp Sort_Add_IfNotIn_list( /* e, l, f */ );
/* DataListTyp  e;
   ListTyp l;
   boolean (*f)(); */




/* PutStopCell
 * Puts a Stop Cell the first argument of "b".
 */
extern void PutStopCell( /* b */ );
/* BehTyp b; */




/* PutNewCell
 * Put "newcell" the first argument of "b" (if b is not NULL) and 
 * returns newcell.
 */
extern BehTyp PutNewCell( /* b,newcell */ );
/* BehTyp b,newcell; */




/* Get_Branches
 * Returns the actions that offers "b" in a sorted list.
 */
extern ListTyp Get_Branches( /* b,l */ );
/* BehTyp b;
   ListTyp l; */




/* Call_Is_Determ
 * Returns TRUE is behaviour "b" is deterministic (FALSE if not).
 */
extern boolean Call_Is_Determ( /* b */ );
/* BehTyp b; */




/* FreeProcTable
 * Frees the processes behaviours from "first" position to "last" 
 * position of the Process Table and puts a stop cell.
 */
extern void FreeProcTable( /* first,last */ );
/* DescriptorTyp first,last; */



/* NewProc
 * Creates a new process called "proc" and returns its descriptor.
 */
extern DescriptorTyp NewProc();




/* MakeProcInst
 * Makes a process Instantiation cell with name "desc" and returns it.
 */
extern BehTyp MakeProcInst( /* desc */ );
/* DescriptorTyp desc; */



/* Call_Cmp_Rec_Beh
 * Returns if "b1" and "b2" offers the same actions (if they are equivalents).
 */
extern boolean Call_Cmp_Rec_Beh( /* b1,b2 */ );
/* BehTyp b1;
   BehTyp b2; */


#endif /* INVEXP */

#endif

