/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Miguel Angel Palomares Ortega
  
  11-11-1992
  
  This module manages a hash table used for storing states in 
  the comparison functions "Call_Cmp_Rec_Beh" and
  "Cmp_Rec_Beh" which are defined in "iefunc.c".
  
  
  ************************************/


#ifdef INVEXP

#include "iefunc.h"
#include "ietables.h"
#include "listdh.h"
#include "limisc.h"
#include "lihash.h"


/***************************************************************
 *
 *         HASH TABLE MANAGEMENT FUNCTIONS
 *
 ****************************************************************/




/* MakeKey
 * Returns the hash table key.
 */
int MakeKey(pair)
     EntryTyp pair;
{
  
  return (int)LookInfo_list(pair->l1);
  
}


/*--------------------------------------------------------------*/


/* CmpPair
 * Returns if two states are equal.
 */
boolean CmpPair(pa,pb)
     EntryTyp pa,pb;
{
  
  if ( Equal_Sortlist(pa->l1,pb->l1,(boolean (*) ())NULL) && Equal_Sortlist(pa->l2,pb->l2,(boolean (*) ())NULL) )
    return TRUE;
  else
    return FALSE;
}



/*--------------------------------------------------------------*/




/* FreeEntry
 * Frees a hash table element.
 */
void FreeEntry(pair)
     EntryTyp pair;
     
{
  Disp_list(pair->l1);
  Disp_list(pair->l2);
  Free2Words((void*)pair);
}



/*--------------------------------------------------------------*/



/* CreateHTab
 * Creates a hash table.
 */
HashDTyp CreateHTab()
     
{
  
  return Create_HT(TABLE_SIZE,FreeEntry,MakeKey,CmpPair,(void(*) ())NULL);
  
}


#endif /* INVEXP */
