/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Miguel Angel Palomares Ortega   
  
  11-11-1992
  
  This module manages a hash table used for storing states in 
  the comparison functions "Call_Cmp_Rec_Beh" and
  "Cmp_Rec_Beh" which are defined in "iefunc.c".
  
  ************************************/



#ifndef ietables_H
#define ietables_H

#ifdef INVEXP


#include "listdh.h"
#include "lilists.h"
#include "lihash.h"


#define TABLE_SIZE 5024


/* every state stored in the table will have two lists of actions offered
   by both behaviours */

typedef struct { ListTyp l1;
                 ListTyp l2;
               } *EntryTyp;


/***************************************************************
 *
 *         TABLE MANAGEMENT FUNCTIONS
 *
 ****************************************************************/


/* MakeKey
 * Returns the hash table key.
 */
extern int MakeKey( /* pair */ );
/* PPairbeh pair; */



/* CmpPair
 * Returns if two states are equal.
 */
extern boolean CmpPair( /* pa,pb */ );
/* EntryTyp pa,pb; */



/* FreeEntry
 * Frees a hash table element.
 */
extern void FreeEntry( /* pair */ );
/* EntryTyp pair; */



/* CreateHTab
 * Creates a hash table.
 */
extern HashDTyp CreateHTab();


#endif /* INVEXP */

#endif

