/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon Gomez
  Francisco Monfort Martin
  David Larrabeiti Lopez
  
  25-07-1990
  
  Commands
  
  ************************************/

#ifndef INcomm_H
#define INcomm_H


/* ECload
 * Executes the command load.
 * spec is the filename of the specification.
 * libr is the library file name.
 * returns -1 if there is an error.
 */
extern int ECload( /* spec,libr */ );
/*  char *spec, *libr; */


/* ECprint
 * Executes the command print.
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 * depth is the depth of the print.
 * outfile is the output file.
 * "pstr" is a function to print strings (if outfile is "") 
 */
extern void ECprint( /* contopcio,lst_opcio,depth,outfile,pstr */ );
/*  int depth,contopcio;
    char *outfile, *lst_opcio; 
    void (*pstr)(); */


/* ECsave
 * Executes the execution of the command save.
 * outfile is the output file.
 * "pstr" is a function to print strings (if outfile is "") 
 */
extern void ECsave( /* outfile,pstr */ );
/* char *outfile; 
   void (*pstr)(); */


/* ECdata
 * Executes the command dataTable.
 * table indicates the table to print (g, v, o, p or s).
 * l and h are the first and the last positions to print.
 */
extern void ECdata( /* table,l,h */ );
/* char  table;
   int   l,h; */


/* ECexpand
 * Executes the command expand.
 * depth is the expansion depth.
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 */
extern void ECexpand( /* depth,contopcio,lst_opcio */ );
/* int depth,contopcio; 
   char *lst_opcio; */


/* ECfree
 * Executes the command freeExpand.
 * depth is the expansion depth.
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 */
extern void ECfree( /* depth,contopcio,lst_opcio */ );
/* int depth,contopcio; 
   char *lst_opcio; */


/* ECvar
 * Executes the command varExpand.
 * depth is the expansion depth.
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 */
extern void ECvar( /* depth,contopcio,lst_opcio */ );
/* int depth,contopcio; 
   char *lst_opcio; */


/* ECtest
 * Executes the command TestExpand.
 * depth is the expansion depth.
 * success is the name of the success event.
 * process is the name of the test process.
 * n_opt is the number of options and opt_lst is the list of options.
 * exp_resp is the expected response.
 * vl is the verbose level
 *
 * bhtsz,seed,percent correspond to a partial testexpansion when
 * bhtsz!=0 or percent!=100%
 * bhtsz (Mb) is the size of the table for bit state hashing
 * percent is the % of alternatives to be explored in every state
 * seed is the random generator seed when percent<100%
 */
extern void ECtest( /* n_opt,depth,success,process,
                       opt_lst,exp_resp,bhtsz,seed,percent,vl */ );
/*     int   n_opt,depth,bhtsz,seed,percent,vl;
       char *success, *process, *opt_lst, *exp_resp; */


/* ECone
 * Executes the command oneExpand.
 * depth is the expansion depth.
 * success is the name of the success event.
 * process is the name of the test process.
 * seed is the seed for a ramdon number generator.
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 */
extern int ECone( /* depth,success,process,seed,contopcio,lst_opcio */ );
/*  int  depth,seed,contopcio;
    char *success,*lst_opcio,*process;   */


/* ECit
 * Executes the command it.
 * contopcio is the number of options and lst_opcio is the list
 * of options.
 */
extern void ECit( /* contopcio,lst_opcio */ );
/*  int contopcio;
    char *lst_opcio; */


/* ECstat
 * Executes the command statistic.
 */
extern void ECstat();


/* ECquit
 * Executes the command quit.
 */
extern void ECquit();


/* ECrewrite
 * Executes the command rewrite.
 * expr is a data value expression.
 */
extern void ECrewrite( /* expr */ );
/* ExprTyp expr; */


#ifdef INVEXP

/* ECvis_com
 * Executes the command for visible communication decomposition.
 * lgl1 and lgl2 are the number of names in gl1 and gl2.
 * gl1 and gl2 are arrays with the names of the gates belonging
 * to the sub-behaviours to obtain.
 */
extern void ECvis_com( /* lgl1, gl1, lgl2, gl2 */ );
/* char *gl1[], *gl2[]; 
   int   lgl1, lgl2; */


/* ECvc_nrec
 * Executes the command for non recursive visible communication decomposition.
 * lgl1 and lgl2 are the number of names in gl1 and gl2.
 * gl1 and gl2 are arrays with the names of the gates belonging
 * to the sub-behaviours to obtain.
 */
extern void ECvc_nrec( /* lgl1, gl1, lgl2, gl2 */ );
/* char *gl1[], *gl2[]; 
   int   lgl1, lgl2; */


/* ECk
 * Executes the command for k decomposition.
 * lgl1 and lgl2 are the number of names in gl1 and gl2.
 * gl1 and gl2 are arrays with the names of the gates belonging
 * to the sub-behaviours to obtain.
 */
extern void ECk( /* lgl1, gl1, lgl2, gl2 */ );
/* char *gl1[], *gl2[]; 
   int   lgl1, lgl2; */


/* ECpure_int
 * Executes the command for pure interleaving decomposition.
 * lgl is the number of names in gl.
 * gl is an array with the names of the gates belonging to the first 
 * sub-behaviours to obtain.
 */
extern void ECpure_int( /* lgl,gl */ );
/* char * gl[]; 
   int    lgl;  */

#endif /* INVEXP */


/* IsRemovedDepInfo
 * return TRUE if the depuration attributes have been deleted
 */
extern boolean IsRemovedDepInfo();


/* Default
 * return the defult value being given by the LoLa customization variables
 */
extern void * Default(/* var */);
/*       char * var; */


/* ECset
 * Executes the command Set.
 * Set a LoLa customization variable to a value.
 */
extern void ECset(/* var, value */);
/*     char *var, *value; */


/* ECcmd
 * Execute the command Cmd which executes a file cmd_file.
 */
extern void ECcmd(/* cmd_file */);
/*     char *cmd_file; */


#endif
