/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************

 *
 * Copyright (C) 1991 by Chris Thewalt
 *
 * Permission to use, copy, modify, and distribute this software
 * for any purpose and without fee is hereby granted, provided
 * that the above copyright notices appear in all copies and that both the
 * copyright notice and this permission notice appear in supporting
 * documentation.  This software is provided "as is" without express or
 * implied warranty.
 *

 1991/11/09 20:27:48


 * Fairly portable (ANSI C),  emacs style line editing input package.
 * This package uses \b to move, and \007 to ring the bell.
 * It uses a fixed screen width, as initialized in the gl_init() call,
 * and does not draw in the last location to avoid line wraps.
 * The only non-portable part is how to turn off character echoing.
 * This code works for *NIX of BSD or SYSV flavor, as well as MSDOS (MSC6.0).
 * No TERMCAP features are used, so long lines are scrolled on one line
 * rather than extending over several lines.  The function getline2
 * returns a pointer to a static buffer area which holds the input string,
 * including the newline. On EOF the first character is set equal to '\0'.
 * The caller supplies a desired prompt, as shown in the prototype:
 *
 *     char *getline2(char *prompt)
 *
 * Getline is different from GNU readline in that:
 *   - getline2 has much more limited editing capabilities, but it
 *     is also much smaller and doesn't need termcap.
 *   - you don't free the buffer when done, since it is static
 *     (make a copy yourself if you want one)
 *   - the newline is appended to the buffer
 *   - you don't add lines to history, it is done automatically.
 *
 * The function gl_init(int screen_width) should be called before
 * calling getline2(char *prompt), and gl_cleanup(void) should be
 * called before before exiting.  The function gl_redraw(void) may also
 * be called to redraw the screen (as is done when ^L or ^R are read).
 *
 * The editing keys are:
 * ^A, ^E   - move to beginnning or end of line, respectively.
 * ^F, ^B   - nondestructive move forward or back one location, respectively.
 * ^D       - delete the character currently under the cursor, or
 *            send EOF if no characters in the buffer.
 * ^H, DEL  - delete character left of the cursor.
 * ^K       - delete from cursor to end of line.
 * ^P, ^N   - move through history, previous and next, respectively.
 * ^L, ^R   - redraw the current line.
 * TAB      - call user defined function if bound, or insert spaces
 *            to get to next TAB stop (just past every 8th column).
 * NL, CR   - places line on history list if nonblank, calls output
 *            cleanup function if bound, appends newline and returns
 *            to the caller.
 *
 * In addition, the caller can modify the buffer in certain ways, which
 * may be useful for things like auto-indent modes.  There are three
 * function pointers which can be bound to user functions.
 * Each of these functions must return the index of the first location
 * at which the buffer was modified, or -1 if the buffer wasn't modified.
 * Each of the functions receive the current input buffer as the first
 * argument.  The screen is automatically cleaned up if the buffer is changed.
 * The user is responsible for not writing beyond the end of the static
 * buffer.  The function pointer prototypes are:
 *
 *  int (*gl_in_hook)(char *buf)
 *      - called on entry to getline2, and each time a new history
 *        string is loaded, from a ^P or ^N. Initally NULL.
 *  int (*gl_out_hook)(char *buf)
 *      - called when a \n or \r is read, before appending \n and
 *        returning to caller. Initally NULL.
 *  int (*gl_tab_hook)(char *buf, int offset, int *loc)
 *      - called whenever a TAB is read.  The second argument is
 *        the current line offset due to the width of the prompt.
 *        The third argument is a pointer to the variable holding the
 *        current location in the buffer.  The location may be reset
 *        by the user to move the cursor when the call returns.
 *        Initially a built in tabbing function is bound.
 *
 * Please send bug reports, fixes and enhancements to Chris Thewalt,
 * thewalt@ce.berkeley.edu



 ************************************/

#ifndef LIgetline2_H
#define LIgetline2_H


#define BUF_SIZE 2000
#define SCROLL   30

/* gl_init
 * set up variables and terminal
 */
extern void gl_init(/* scrn_wdth */);
/*     int scrn_wdth; */

/* gl_cleanup
 * undo effects of gl_init, as necessary
 */
extern void gl_cleanup();

/* KJT 15/02/12: renamed "getline22" to avoid clash with standard "getline2" */
/* getline2
 */
extern char *getline2(/* prompt */);
/* char *prompt; */


/* gl_redraw
 * emit a newline, reset and redraw prompt and current input line
 */
extern void gl_redraw();


#endif

