/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Juan carlos Berrocal Colmenarejo
  
  2 Nov 90
  
  Hash tables management module.
  Creation and management of hash tables of any size.
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  TYPE DEFINITIONS:
  HashDTyp : hash table descriptor
  DataHashTyp : elements' type
  
  FUNCTION DEFINITIONS:
  Create_HT : creates a hash table
  Free_HT : frees a hash table
  Clean_HT : cleans a hash table
  Insert_HT : inserts an element in a hash table inconditionally
  Insert_IfNotIn_HT : inserts an element in a hash table if it had not
  been inserted yet.
  In_HT : says if an element is in a hash table.
  Remove_HT : removes an element from the hash table.
  LookFor_HT : searchs for an element in a hash table.
  Print_HT : print all the information of a hash table.
  Stat_HT : number of slots used and total of elements in a hash table.
  
  
  ************************************/


#ifndef LIhash_H
#define LIhash_H

#include "listdh.h"


/* 
 * Descriptor of a hash table.
 */
typedef void* HashDTyp;


/*
 * Type of the elements to store in the hash tables.
 */
typedef void* DataHashTyp;



/* Create_HT
 * Create a hash table.
 * Return the descriptor of the table.
 * Attached functions:
 *  FreeF  -> To free the information in the table.
 *  KeyF   -> To compute the hash key of an element.
 *  CompF  -> To compare 2 elements.
 *  PrintF -> To print an element with "pstr"(a function to print strings).
 */ 
extern HashDTyp Create_HT( /* size, FreeF, KeyF, CompF, PrintF */);
/* int     size;
   void    (*FreeF)();
   int     (*KeyF)();
   boolean (*CompF)();
   void    (*PrintF)(pstr,data); */



/* Free_HT
 * Free the memory allocated to the hash table d and its data.
 */
extern void Free_HT( /* d */ );
/*  HashDTyp  d; */



/* Clean_HT
 * Clean hash table d. ( release all stored data ).
 */
extern void Clean_HT(/* d */);
/* HashDTyp d; */



/* Insert_HT
 * Insert an element in hash table d inconditionally
 * ( no matter if the element is already in the table).
 * d    is the hash table descriptor.
 * elem is the data to insert.
 */
extern void Insert_HT( /* d, elem */ );
/* HashDTyp     d;
   DataHashTyp  elem; */



/* Insert_IfNotIn_HT
 * Insert an element in hash table d, only if it is not at the table yet.
 * Otherwise : no insertion is performed.
 * d    is the hash table descriptor.
 * elem is the data to insert.
 */
extern void Insert_IfNotIn_HT( /* d, elem */ );
/*     HashDTyp    d;
       DataHashTyp elem; */



/* In_HT
 * returns TRUE if elem is in the hash table.
 * d     is the hash table descriptor.
 * elem  is the data to be looked for.
 */
extern boolean In_HT( /* d,elem */ );
/* HashDTyp    d;
   DataHashTyp elem; */




/* Remove_HT
 * Removes an element from a hash table d.
 */   
extern void Remove_HT( /* d, elem */ );
/*  HashDTyp    d;
    DataHashTyp elem; */



/* LookFor_HT
 * Look for an element equal to elem in the hash table.
 * If not found return NULL.
 */
extern DataHashTyp LookFor_HT( /* d, elem */ );
/* HashDTyp    d;
   DataHashTyp elem; */



/* Print_HT
 * Print a hash table d.
 * "pstr" is the function used to print strings.
 */
extern void Print_HT( /* d, pstr */ );
/* HashDTyp d;
   void (*pstr)(); */



/* Stat_HT
 * Returns the number of slots used
 * and the total number of elements stored in the hash table.
 */
extern void Stat_HT( /* d, slotsUsed, nelem */ );
/* HashDTyp d;
   int *slotsUsed, *nelem; */



#endif

