/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************

  Santiago Pavon Gomez

  11-1-1990

  This module defines a set of functions of general interest

  emilla modification (9-6-92): erealloc function included.

  COMPILATION OPTIONS: The behaviour of this module can be modified
  By the following compilation flags:

  (none)

  TYPE DEFINITIONS:

  (none)

  FUNCTION DEFINITIONS:

  emalloc : memory allocator call for words. on error halts program.
  erealloc : memory reallocator call for words. on error halts program.
  ecalloc : memory allocator call for arrays. on error halts program.
  Emalloc2Words : gets two words of memory.
  Free2Words : deallocated a block obtained with Emalloc2Words.
  Stat_2W : statistics about 2-words nodes usage.
  EqInt : integer equality
  VoidF : returns NULL
  EchoInt : returns its argument
  PrintInt : prints an integer into a file
  Error : prints a error message and halts.
  Warning : prints a warning message
  ToMake : prints a warning message for calls to unimplemented functions
  Assert : Halts the program is a condition is not satisfied
  Halt : halts the execution
  System : system function call
  CopyString : copies a string
  StringToInt : string-integer conversion
  IntToString : integer-string conversion
  LowerString : uppercase to lowercase
  PrintString : prints a string into the standard output
  PrintError  : prints a string into the standard error output
  Power : power x**y
  PrintInt : prints an integer into a file
  InitM : inits memory small block allocator
  NewCellM : returns a new cell
  FreeCellM : frees a cell

  ************************************/


#ifndef LImisc_H
#define LImisc_H

#include "listdh.h"
#include "listdout.h"

/* KJT 25/01/23: added header */
#include <stdint.h>

/*
 * definition of an undefined value for integer variables constrained to
 * positive values.
 *
 */
#define UNDEFINED -666

/******************************************************************
 *
 *  Functions to manage memory.
 *
 *******************************************************************/

/* avoid memory alignment lint complaints */
#ifndef lint
#  define ALIGN(p)       (p)
#else
#  define ALIGN(p)       ((int)&*(p))
#endif

/* KJT 29/10/04: include "u_long" for no CygWin */

/* typedef unsigned long u_long ; */

/* InitM()
 * Inits this module.
 * This function must be invoked when the application starts.
 */
extern void InitM();


/* emalloc
 * Gets memory from the system for n integers.
 * If there is an error then it halts the program.
 */
extern void* emalloc( /* n */ );
/* int  n;  */


/* erealloc
 * Reallocs memory pointed by "ptr" from the system for "size" integers.
 * If there is an error then it halts the program.
 */
extern void* erealloc( /* ptr, size */ );
/* void *ptr;
   int  size;  */


/* ecalloc
 * Get memory from the system for an array of n elements of size
 * "size" bytes.
 * If there is an error then it halts the program.
 */
extern void * ecalloc ( /* n, size */ );
/* unsigned n,size; */


/* Emalloc2Words
 * Gets two words of memory from the system.
 * These memory is deallocated with Free2Words. In fact, this memory
 * is maintained in a list of unused 2-word-size block of memory.
 */
extern void * Emalloc2Words();


/* Free2Words
 * Deallocated a block obtained with Emalloc2Words.
 * This memory is maintained in a list of unused 2-word-size block of
 * and it will be used when Emalloc2Words was called.
 */
extern void Free2Words( /* c */ );
/* void * c; */


/* Stat2W
 * Number of asked  and released 2w nodes
 */
extern void Stat2W(/* new, released */);
/*       int * new, *released; */


/******************************************************************
 *
 *  Functions used as parameters in several places.
 *
 *******************************************************************/


/* EqInt
 * Returns TRUE if x and y are equal, else FALSE.
 */
extern boolean EqInt( /* x,y */ );
/* int x,y; */


/* VoidF
 * Void function. Returns NULL.
 */
extern int VoidF();


/* EchoInt
 * Echoes its argument.
 */
/* KJT 25/01/23: changed return type from "int" to "intptr_t" */
extern intptr_t EchoInt( /* i */ );
/* int i; */


/* PrintInt
 * prints the integer "i".
 * "pstr" is the function used to print strings.
 */
extern void PrintInt( /* pstr, i */ );
/*  void (*pstr)();
    int    i;    */


/******************************************************************
 *
 *  Program quitting functions
 *
 *******************************************************************/

/*
 *
 * LOLA exit value
 *
 */
#define NORMALQUIT 0
#define ERRORQUIT -1
#define UTRQUIT    1

#ifndef lint
#define EXITLOLA(n) {gl_cleanup(); exit(n);}
#else
#define EXITLOLA(n) return;
#endif

/* Halt
 * Halts the program.
 */
extern void Halt();

/* Error
 * Prints a error message and halts.
 * It uses "printError" (listdout)
 *
 * void Error( m )
 *    char * m ;
 */
#define Error(m) {LASSERT(printError!=NULL);\
		    (void)fprintf(stderr,\
				  "\n      ERROR ( file %s; stop at %d ): %s\n",\
				  __FILE__,__LINE__,m);\
		    Halt();}


/* Warning
 * Prints a warning message using "printMsgs" (listdout)
 */
extern void Warning( /* m */ );
/*  char * m ; */


/* ToMake
 * Prints the message "The function <s> is not implemented yet" and halts.
 */
extern void ToMake( /* m */ );
/*  char * m ; */


/* Assert
 * Prints a message with "printError"(listdout) and halts the application
 * if the condition "ex" is false.
 * In "file" and "line" shoulb be passed the name of the file that
 * calls to Assert and the line number. Note that can be used the
 * cpp macros __FILE__ and __LINE__.
 */
extern void Assert( /* ex, file, line */ );
/* boolean ex;
   char    *file;
   int     line;   */


/******************************************************************
 *
 *  Strings
 *
 *******************************************************************/


/* CopyString
 * Allocates memory and copies a string.
 */
extern char* CopyString( /* s */ );
/* char *s; */


/* StringToInt
 * Returns the integer represented by the string s.
 */
extern int StringToInt( /* s */ );
/* char *s;  */


/* IntToString
 * Returns the integer i as a string.
 */
extern char *IntToString( /* i */ );
/* int i;  */


/* LowerString
 * Transforms the uppercase letters of the string "s" to lowercase
 * letters.
 */
extern void LowerString( /* s */ );
/* char *s; */


/* PrintString
 * Print a string into the standard output
 */
extern void PrintString( /* str */ );
/*       char * str; */


/* PrintError
 * Print a string into the standard error output
 */
extern void PrintError( /* str */ );
/*       char * str; */

/******************************************************************
 *
 *  Miscellaneous
 *
 *******************************************************************/

/* Power
 * Returns the power x**n.
 * n must be greater or equal than 0
 */
extern int Power( /* x, n */ );
/* int x, n;  */


/* System
 * "system" function call.
 * If "runtimeConfig" is "TextMode" then it executes a system call, else
 * a process connected with a fifo is created to execute "cmd"
 */
extern int System( /* cmd */ );
/* char * cmd; */

/******************************************************************
 *                                                                *
 *                      Cell management                           *
 *                                                                *
 *******************************************************************/


/* min. and max. size of blocks (in bytes) managed by this module.
 * The minimum must be greater than the word size
 */

#define MINBLOCKSIZE   8
#define MAXBLOCKSIZE 100


/* InitCellM()
 * Initializes the cell manager
 */
extern void InitCellM();


/* StatCellM
 * return the maximum number of cells of size "size" used and
 * how many of them are disposed.
 */
extern void StatCellM(/* size, total, disposed */);
/*       int * total, * disposed; */


/* NewCellM
 * return a new cell
 */
extern void * NewCellM(/* size */);
/*       int size; */


/* FreeCellM
 * free a cell c of size "size"
 */
extern void FreeCellM(/* c, size */);
/*       void * c;
	 int    size; */

/******************************************************************
 *                                                                *
 *         Statistics on Memory and Time Consumption              *
 *                                                                *
 ******************************************************************/


/* UsageMemoTime
 * Return the memory used by the program, the user and system time
 * spent by the program until now.
 */
extern void UsageMemoTime(/* user_time, sys_time, memory */);
/*     float *user_time, *sys_time;
       long int   *memory; */


/* PrintUsageMemoTime
 * Print the memory used by the program, the user and system time
 * spent by the program until now.
 */
extern void PrintUsageMemoTime();


#endif

