/***********************************
  (C) Copyright 1992-1993; dit/upm
  Distributed under the conditions stated in the
  TOPO General Public License (see file LICENSE)
  ***********************************/

/***********************************
  
  Santiago Pavon Gomez
  
  december 2, 1992
  
  This module defines variables:
  - to specify the runtime configuration of LOLA
  - to assign the printing functions used by all the functions
  
  COMPILATION OPTIONS: The behaviour of this module can be modified
  by the following compilation flags:
  
  (none)
  
  TYPE DEFINITIONS: (none)
  
  FUNCTION DEFINITIONS: (none)
  
  VARIABLE DEFINITIONS: 
  
  runtimeConfig : Runtime configuration.
  
  printTarget: How and where the main information is printed.
  flushTarget: flushes the target.
  printError : How and where the main information is printed.
  printMsgs  : How and where unbuffered messages are printed.
  printPos   : As printTarget, but it print the information in 
  a determined position of the output.
  printCursor: How and where the selection menues are printed.
  
  ************************************/

#ifndef listdout_H
#define listdout_H

/*----------------------------------------------------------------*/

#define XWindowsMode 1
#define TextMode     2

/* runtimeConfig
 * This variable stores the runtime configuration mode.
 * Values allowed are XWindowsMode and TextMode. 
 */
extern int runtimeConfig;

/*----------------------------------------------------------------*/

/* printTarget
 * This variable is set with a function to print the main information.
 */
extern void (*printTarget)( /* s */ );
     /* char *s; */
     
     
     /* flushTarget
      *  Flushes the target.
      */
     extern void (*flushTarget)();
     
     
     /* printError
      *  This variable is set with a function to print the error output.
      */
     extern void (*printError)( /* s */ );
     /* char *s; */
     
     
     /* printMsgs
      *  This variable is set with a function to print unbuffered messages.
      */
     extern void (*printMsgs)( /* s */ );
     /* char *s; */
     
     
     /* printPos
      *  This variable is set with a function to print messages.
      *  It is equal to printTarget, but it print the information in 
      *  a determined position of the output.
      */
     extern long (*printPos)( /* s , pos */ );
     /* char *s; 
	long  pos; */
     
     
     /* printCursor
      *  This variable is set with a function to print the selection menues.
      */
     extern void (*printCursor)( /* s */ );
     /* char *s; */
     
     /*----------------------------------------------------------------*/
     
#endif
     
