/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************/

/***********************************

   Santiago Pavon Gomez

   16 October 1992

   Commands related with the STEP mode.

 ************************************/


#ifndef ststep_H
#define ststep_H

#include "listdh.h"

/*----------------------------------------------------------------*/


/* ECstep_start_CheckBehEventTest
 * This is the first function to invoke when switching LOLA into 
 * the simulation mode.
 * This function checks that both the success event and the test process
 * exist, that a specification has been loaded.
 * Returns TRUE if these conditions are satisfied.
 * In "psed" and "pproc" returns the descriptors of the success event and 
 * the test process.
 * It also calls to Rw_Spec() and Expandable().
 * undos is the number of undo's allowed during a simulation session.
 */
extern boolean ECstep_start_CheckBehEventTest(/* success, process, psed, pproc,
						 contopcio, lst_opcio, undos */);
/*     char *success, *process;
       DescriptorTyp *psed, *pproc;
       int contopcio; 
       char *lst_opcio; 
       int undos; */


/* ECstep_start_GetUnassignedVars
 * If the current behaviour (cursor) is either a process definition or 
 * a specification cell, then this function returns a list with all the 
 * descriptors of the variables defined in the formal parameter list.
 * If not, returns NULL.
 */
extern ListTyp ECstep_start_GetUnassignedVars();


/* ECstep_start_ReadParameters
 * Read values (strings) for the variables in the list "varList"
 * and fills the SVdescriptorTyp table "psv" with the values read.
 */
extern void ECstep_start_ReadParameters( /* varList,psv */ );
         /* ListTyp varList;
            SVdescriptorTyp *sv; */


/* ECstep_start_Behaviour
 * If "psv" is not empty then creates a "let" with the values in "psv"
 * and add the "let" operator before the current behaviour. Then returns
 * the behaviour: let + the current behaviour.
 * If it is empty then return the current behaviour.
 */
extern BehTyp ECstep_start_Behaviour( /* psv */ );
          /* SVdescriptorTyp *psv; */


/* ECstep_start_ComposeWithTest
 * This function composes the behavior "b" with the test process
 * if it is specified. If the test process is not specified then it
 * returns "b".
 * If there is any problem the function returns NULL, otherwise 
 * returns the behaviour to simulate.
 */
extern BehTyp ECstep_start_ComposeWithTest( /* b, sed, proc */ );
         /* BehTyp b;
            DescriptorTyp sed,proc; */


/* ECstep_start_Expan
 * "b" is the behaviour in the first step of the simulation process.
 * This function calculates the first set of transitions offered.
 * undos_num is a limit to the number of undo's available during a simulation.
 */
extern void ECstep_start_Expan( /* b, undos_num */ );
/* BehTyp b; 
   int    undos_num; */


/*----------------------------------------------------------------*/

/* ECstep_branch_GetUnassignedVars
 * Returns a list with all the descriptors of the unassigned variables in 
 * the choices and gate operators of the branch "n".
 */
extern ListTyp ECstep_branch_GetUnassignedVars( /* n */ );
     /* int n; */


/* ECstep_branch_exec
 * Executes the n-th transition of the current simulation behaviour.
 * "n" must be a valid transition.
 * The Table "sv" is applied to the transition.
 */
extern void ECstep_branch_exec( /* n,sv */ );
     /* int             n;
            SVdescriptorTyp sv; */


/* ECstep_branch
 * Executes the n-th transition of the current simulation behaviour.
 */
extern void ECstep_branch( /* n */ );
    /* int n; */

/*----------------------------------------------------------------*/

/* ECstep_sync
 * Displays the synchronization tree of a menu option.
 */
extern void ECstep_sync(/* branch, proc */);
   /* int           branch;
      DescriptorTyp proc;   */

/*----------------------------------------------------------------*/

/* ECstep_menu
 * Displays a menu with the possible transitions.
 */
extern void ECstep_menu();

/*----------------------------------------------------------------*/

/* ECstep_ExistRefused 
 * Returns TRUE is there are any refused synchronizations.
 */
extern boolean ECstep_ExistRefused ();


/* ECstep_refused
 * Display the synchronizations refused due to data values menu.
 */
extern void ECstep_refused();

/*----------------------------------------------------------------*/

/* ECstep_trace
 * Displays all the simulated events.
 */
extern void ECstep_trace();

/*----------------------------------------------------------------*/

/* ECstep_undo
 * Undo the last simulation step.
 * Returns TRUE if there was a step to be undone.
 */
extern boolean ECstep_undo();

/*----------------------------------------------------------------*/

/* ECstep_print
 * Executes the command print (step mode).
 * contopcio is the number of options in lst_opcio.
 * lst_opcio is the list of options.
 * depth is the depth of the print.
 * outfile is the output file.
 */
extern void ECstep_print( /* contopcio,lst_opcio,depth,outfile */ );
     /*  int depth,contopcio;
         char *outfile, *lst_opcio; */

/*----------------------------------------------------------------*/

/* ECstep_help
 * Display Step mode help.
 */
extern void ECstep_help();

/*----------------------------------------------------------------*/

/* ECstep_exit
 * Finish simulation mode and return the lola mode.
 */
extern void ECstep_exit();

/*----------------------------------------------------------------*/

/* ECstep_select
 * Select the subset of transitions from the menu option, given by the
 * list of alternatives numbers opts.
 */
extern void ECstep_select(/* opts */);
/*     ListTyp opts; */


#endif

