#include "nat.h"

extern kdatum true ();
extern kdatum false ();

extern kdatum zero ();
extern kdatum succ ();
extern kdatum pred ();

kdatum one ()
{
  static kdatum v= NULL;

  if (v == NULL)
  { v= succ(zero());
    (void) kd_const(v);
  }
  return v;
}

kdatum plus (p1, p2)
  kdatum p1, p2;
{
  kdatum v;

  if (kd_gequal(p1, zero(), 0x2))
    v= kd_copy(p2);
  else if (kd_gequal(zero(), p2, 0x1))
    v= kd_copy(p1);
  else
    v= succ(succ(plus(pred(kd_copy(p1)), pred(kd_copy(p2)))));
  kd_free(p1);
  kd_free(p2);
  return v;
}

kdatum lt (p1, p2)
  kdatum p1, p2;
{
  kdatum v;

  if (kd_equal(p1, p2))
    v= false();
  else if (kd_gequal(p1, zero(), 0x2))
    v= true();
  else if (kd_gequal(zero(), p2, 0x1))
    v= false();
  else
    v= lt(pred(kd_copy(p1)), pred(kd_copy(p2)));
  kd_free(p1);
  kd_free(p2);
  return v;
}
