#ifndef inter_HH
#define inter_HH

#define PUBLIC
#define PRIVATE static

#line 2 "inter.desc"
/**************************************************************
 *       inter.desc - LBM Interpreter Public Interfaz
 **************************************************************/
/***********************************************
 (C) Copyright 1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************************
 $Log: inter.desc,v $
   Revision 1.8  1994/11/14  11:24:45  lotos
   avoid name collision

   Revision 1.7  1994/10/17  16:41:47  lotos
   cosmetics

   Revision 1.6  1993/12/22  17:20:53  lotos
   Changed a number of names in the interface
   Added function  to work with instances of processes and their gates
   CLOSING BASIC LOTOS VERSION OF LIBRARY!

   Revision 1.5  1993/10/19  19:35:18  lotos
   intkaos.hh becomes public

   Revision 1.4  1993/10/19  15:31:44  lotos
   use kaos.h from ildi

   Revision 1.3  1993/10/18  17:47:53  lotos
   cleanup interface

   Revision 1.2  1993/10/16  11:00:22  lotos
   clean it a bit

   Revision 1.1  1993/10/16  10:54:48  lotos
   Initial revision

 **********************************************
 $Id: inter.desc,v 1.8 1994/11/14 11:24:45 lotos Exp $
 **********************************************/

#ifndef inter_desc_HH
#define inter_desc_HH

/* LOTOS data */
#include "ldi.hh"
/*************** TYPES    ******************/
/*  spe        :=  especificaci'on en un estado determinado.
 *  set_off    :=  ofertas de una especificaci'on en un estado.
 *  offert     :=  una oferta de la lista.
 *  gate       :=  puerta de un evento u oferta.
 *  predi      :=  predicado asociado a un evento u oferta.
 */

#ifndef TRUE
# define FALSE 0
# define TRUE  1
#endif

typedef int     boolean;    /* To simplify life?                */

typedef int     Gte;        /* Gate Identifier                  */

typedef INTlist gtelist;    /* Gate Identifier List             */

typedef int     Var;        /* Variable Identifier              */

typedef INTlist varlist;    /* Variable Identifier List         */

typedef int     proc;       /* Process Instance Identifier      */

typedef INTlist proclist;   /* Process Instance Identifier List */

typedef int     Sort;       /* Sort Identifier                  */

typedef INTlist sortlist;   /* Sort Identifier List             */

typedef I2T*    xnviron;    /* Environ: idref & ldi ui          */

/* Conditions (guards and predicates) */

typedef struct Cond {
  kdatum val1;
  kdatum val2;
} *cond;

typedef struct CondList {
         cond     c;
  struct CondList *next;
} *CNDlist;

/* Experiments */

#define NOTYPE 0  /* unknown */
#define EXCLAM 1  /* !       */
#define INTERR 2  /* ?       */

#define NOVAR  0  /* not a valid variable identifier */
#define NOSORT 0  /* not a valid sort identifier */

typedef struct Exper {
  int     type;       /* ? or !                */
  Sort    sort;       /* when matching exp, only the sort may be known */
  int     var;        /* unique id of variable */
  int     ldiui;      /* unique id for ldi     */
  varlist vrlst;      /* (ldiui) variables which participate as ? */
  kdatum  val;        /* if constant offered   */
} *exper;

/* Actions and offers */

#define LEXITG    -1  /* exit, "delta" gate */
#define LINTERG   -2  /* "i", internal gate */
#define LNOGATE   -3  /* gate no defined or unknown */

typedef int     offert;

typedef INTlist set_off;

/* The offerts types. Should they be opaque? */

typedef struct soffert {  /* the simplest a ? x:sort, i, b, etc         */
	 int      OffId;  /* Offert Identifier                          */
	 boolean  ready;  /* If the offert is ready (executable)        */
	 Gte      g;      /* unique id of gate                          */
	 int      nexp;   /* number of experiments (values and vars)    */
	 exper    *expl;  /* experiment list (values and vars)          */
	 CNDlist  prdl;   /* predicate list                             */
	 INTlist  ktl;    /* action list: participant list              */
  struct soffert *next;
} soffert;

/* The Kernel Tree. This should be opaque. */

/* Relabeling info */
typedef struct rlbset {
  gtelist actual;
  gtelist formal;
} rlbset;

/* NODES */

typedef struct Krnlt {
	 int          uid;    /* Unique Identifier of the Node         */
	 int          class;  /* Identifies the node                   */
	 xnviron      env;    /* environment (var id & ldi unique id)  */
	 TNODE        *lb;    /* LBM reference for debugging, etc      */
  struct Krnlt *fth;	      /* For simplicity                        */
  struct Krnlt *son1;
  struct Krnlt *son2;
	 int          xto;    /* Indicates if this leave was choosen   */
	 int          BUT;    /* Indicates the LOTOS process           */
	 proc         pi;     /* Process Instance Identifier           */
	 TNODE        *ph;    /* Process Hierarchy, if built           */
	 CNDlist      grdl;   /* Guards List, if built                 */
	 soffert      *soffs; /* offers collected by offer_propagation */
			      /* Info for every kind of node           */
	 Gte          g;      /* gate identifier (if aplicable)        */
	 gtelist      gtes;   /* info for hide, synch,...              */
	 rlbset       *rlb;   /* info for relabeling                   */
} *krnlt;

/* specifications */

typedef struct Spe {
  long int code;            /* Internal specification identifier */
  char     *name;           /* The name of the specification.    */
  TNODE    *lbmroot;        /* The LBM specification (Reference) */
  TNODE    *BUTlist;        /* The _BUT_definition_list          */
  TNODE    *alroot;         /* Info of the LBM                   */
  AT       *ATable;         /* Table of the LBM                  */
  ST       *SymbolTable;    /* Lexical values of the ATable      */
  int      ldi;             /* Data Intepreter Error (identifier when available  */
  int      lastBUTnumber;   /* Number of BUTs                    */
  int      lastPI;          /* Number of Process Instances       */
  int      lastOffId;       /* Last Offert Identifier            */
  int      lastUID;         /* Last Unique Id of Kt Nodes        */
  IAT      *grnl;           /* Node linking info of the LBM      */

  krnlt    kt;              /* The Kernel Tree (synchronization) */
  boolean  keepguards;      /* Keeps UNDEFINED guards            */
  boolean  doph;            /* if hierarchy should be produced   */
  TNODE    *ph;             /* Hierarchy of proceses. Optional   */
  soffert  *soffs;          /* Currents offers                   */
  struct {                  /* Configuration                     */
    long   (*rndm)();       /* Random Numer Generator            */
  } cfg;
}* spe;

/*************** COMPOSITIONAL FUNTIONS ******************/
/* from "spec.c" */

/* Builds and Initializes a specification
 * "name" is the name of the specification file (without ".lot"
 * "pars" is string  containing the parameters of the spec
 * (separated by blanks, no blanks between operations and arguments)
 * "doph"indicates if the process hierarchy is to be created
 * "keepgrd" indicates if the guards are to be kept
 */
spe	spe_init ();

/* It kill and frees the memory used by a specification
 * S is no longer a valid specification
 */
void	free_spe ();

/* It returns a copy of a specification
 */
spe	cp_spe ();

/* It returns the evolution of "S"
 * by offering the event "off"
 */
void	step ();

/* It returns the offerts
 * in which the specification may synchronize
 */
set_off	get_spec_offers ();

/* It returns the offerts in a given state
 */
set_off	get_proc_offers ();

/* It returns the hierarchy of instantiated processes
 * This hierarchy should be understood as a history
 * of instantiation, rather than the current view
 * of instantiated processes
 */
TNODE*	get_ph ();

/* It returns a list of active processes
 */
proclist	get_act_proc ();

/* change the random number generator
 */
void	set_spe_random ();

/*************** OFFER SET HANDLING   ******************/
/* from "offerset.c" */

/* Returns an offer from the set "offs"
 * choosen randomly
 */
offert	one_off ();

/* Returns the first offert in "offs"
 *   PUBLIC offert
 *   first_off (offs)
 *     set_off offs;
 */

#define first_off(offs) (INThead (offs))

/* Returns the "n"th offer from the set "offs"
 *   PUBLIC offert
 *   getnoff (n, offs)
 *     int      n;
 *     set_off offs;
 */

#define getnoff(n, offs) (INTnth (n, offs))

/* Removes an offert "of" from the set "offs"
 */
set_off	del_off ();

/* Returns rest of list, dropping first item
 *   PUBLIC set_off
 *   rest_set_off (offs)
 *     set_off offs;
 */

#define rest_set_off(offs) (INTtail (offs))

/* Return the number of elements in "offs"
 *   PUBLIC int
 *   card_set_off (offs)
 *     set_off offs;
 */

#define card_set_off(offs) (INTlength (offs))

/* Frees a set of offerts *
 *   PUBLIC void
 *   free_set_off (offs)
 *     set_off offs;
 */
#define free_set_off(offs) (fIL ((CLR_TYPE) offs))

/* Matches two offerts from the SAME specification
 * and two different states S1 and S2;
 */
boolean	match_offerts ();

/*************** CONDITION HANDLING   ******************/
/* From "cond.c" */

/* Returns the number of elements in list cl
 */
int	CNDlen ();

/* Insert an element in a list as is
 */
CNDlist	CNDcons ();

/* insert an element in a list without duplication
 */
CNDlist	CNDadd ();

/* Delete element cnd from list cl
 * the resulting list is returned
 */
CNDlist	CNDdel ();

/* Duplicate a list
 */
CNDlist	CNDcopy ();

/* It returns the first element of a list
 */
cond	CNDfirst ();

/* It returns the list without the first element
 */
CNDlist	CNDtail ();

/* Append two list.
 * First list is duplicated.
 * Second is shared (can be viewed as freeded)
 * It does not duplicate!
 */
CNDlist	CNDappend ();

/* Check if element cnd is in cl
 */
boolean	CNDIsIn ();

/* Check if element cnd is NOT in cl
 * PUBLIC boolean
 * CNDIsIn (cnd, cl)
 *   cond   cnd;
 *   CNDlist cl;
 */

#define NOTCNDIsIn(cnd, cl) (!CNDIsIn (cnd, cl))

/*************** DRAWING FUNTIONS     ******************/
/* from "draw.c" */

void	fdraw_gatelist ();

void	draw_gatelist ();

void	fdraw_varlist ();

void	draw_varlist ();

void	fdraw_cond ();

void	draw_cond ();

void	fdraw_CNDlist ();

void	draw_CNDlist ();

void	fdraw_off ();

void	draw_off ();

void	fdraw_set_off ();

void	draw_set_off ();

void	fdraw_spe ();

void	draw_spe ();

/* From "drawkrnl.c" */

void	fdraw_hierarchy ();

void	draw_hierarchy ();

void	fdraw_proclist ();

void	draw_proclist ();

void	fdraw_state ();

void	draw_state ();

void	fdraw_proc_state ();

void	draw_proc_state ();

/*************** CONVERSIONS INTO STRINGS ******************/

/* From "str.c" */

char*	off2str ();

char*	CNDlist2str ();

char*	PRDlist2str ();

/*************** INFORMATION FUNTIONS ******************/

/* From "info.c" */

/* Returns the name of a sort
 */
char*	sortname ();

/* Returns the name of a variable
 *    PUBLIC char*
 *    varname (v)
 *      Var  v;
 */

#define varname(var) (getvname (var))

/* Returns the name of a gate
 */
char*	gatename ();

/* Returns the last renamed gate identifier
 * from an offert
 */
Gte	offertgate ();

/* Returns the last renamed gate name
 * from an offert
 */
char*	offertname ();

/* Returns the list of gates
 * which compound an event
 */
gtelist	get_gates ();

/* Returns the list of process instantiations
 * which participate in an event
 */
proclist	get_proc_insts ();

/* Returns a process name
 * from its identifier
 */
char*	procinstname ();

/* Returns the process instantiation
 * which offers an event in the gate "gid"
 * Returns -1 if "gid" is not offered
 */
proc	proc_by_gate ();

/* Returns the name of a specification "S"
 */
char*	specname ();

/* returns the identifier of gate "g"
 * as it is seen in process instance "pi"
 */
Gte	gte_by_level ();

/* It returns the number of experiments in an offert
 */
int	NumExp ();

/* It returns the sort of the experiment
 * "ne"th of an offert
 * Return NOSORT if ne is out of range.
 */
Sort	SortExp ();

/* It returns the type of the experiment
 * "ne"th of an offert.
 * EXCLAM for "!"
 * INTERR for "?"
 * NOTYPE if "ne" is out of range
 */
int	TypeExp ();

/* It returns the value of the experiment
 * "ne"th of an offert.
 * it returns NULL if "ne" is out of range
 * or no value is known in such experiment
 */
kdatum	ValueExp ();

/* It returns the variables which
 * participate in the "ne"th experiment
 * of a given offert
 */
varlist	get_VarlistExp ();

/* It returns the list of guards
 * which affect some given offert "of"
 */
CNDlist	get_GRDlist ();

/* It return the number of predicates
 * in an offert
 */
int	NumPRD ();

/* It return an array of predicates
 * belonging to an offert.
 * Be sure to get the number of predicates
 * in the offert.
 * Take into account
 * that if you get an offert, such predicates
 * are not FALSE!.
 */
CNDlist	get_PRDlist ();

/* Checks a condition
 */
int	chk_cond ();

/*
  Informaci'on sobre:

Nota: * Done
      - To be provided

  - Instanciaciones:
	  * Qu'e proceso se ha instanciado,
	  * Cuales son las puertas reales y las actuales (renombramiento)
	  - Cuales son los par'ametros reales y actuales (tras la 
	    evaluaci'on).

  - Ofertas:
	  * Cu'al es el conjunto total de acciones ofertado,
	  * Cu'al es el subconjunto de las anteriores sobre las
	    que se puede realizar una sincronizaci'on,
	  * Cuales son los experimentos reales, y sus valores
	  * Cuales son los predicados de selecci'on reales.
	  * Que no se pierda el nombre de la puerta aunque desde
	    el punto de vista de la especificaci'on est'e oculta (i).

  - Sincronizaciones:
	  * Qu'e sincronizaci'on se ha producido,
	  * En cu'al de las instanciaciones de proceso
	    se ha producido,
	  - Valores actuales resultado de la sincronizaci'on.
	  * Que no se pierda el nombre de la puerta aunque desde
	    el punto de vista de la especificaci'on est'e oculta (i).

	  * Indicar a TOPO por cu'al de las acciones del subconjunto
	    de las ofertas por las que se puede avanzar se desea
	    hacerlo.

  - Exit:
	  * Qu'e conjunto de instanciaciones de procesos
	    han realizado 'exit' (conjunta o separadamente).

  - Stop:
	  * Determinar qu'e procesos han realizado stop seg'un dos
	    condiciones: los que han realizado la acci'on 'stop' o los
	    que no pueden realizar m'as acciones al quedarse bloqueados.

  - Datos:
	  - Posibilidad de que el usuario introduzca datos
	    (como cadena de caracteres).

	  - Evaluaci'on de expresiones introducidas por el usuario.
	  - Preevaluaci'on de expresiones para determinar c'omo
	    se va a evaluar una guarda, o los par'ametros de una
	    instanciaci'on de proceso antes de realizar su
	    instanciaci'on.


  * Posibilidad de vuelta atras (backtracking).

  * Posibilidad de guardar y recuperar estados intermedios.
*/

#ifdef lint

#undef first_off
extern offert first_off ();

#undef getnoff
extern offert getnoff ();

#undef rest_set_off
extern set_off rest_set_off ();

#undef card_set_off
extern int card_set_off ();

#undef free_set_off
extern void free_set_off ();

#undef NOTCNDIsIn
extern boolean NOTCNDIsIn ();

#undef varname
extern char* varname ();

#endif

#endif
#endif
