#ifndef intkaos_HH
#define intkaos_HH

/******************************************************
 *      intkaos.hh: Kernel of LOTOS Data Interpreter (LDI)
******************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: intkaos.hh,v $
# Revision 1.1  1994/07/19  12:35:04  lotos
# Initial revision
#
 * Revision 1.1  1994/07/18  18:35:33  lotos
 * Initial revision
 *
 * Revision 2.3  1993/09/20  12:39:05  lotos
 * synchronized with kaos development
 * adpated to kdatum
 * udatum are not expected to be used
 * reduce number of reserved words: new user lexicon
 *
 * Revision 2.6  1993/03/24  17:48:31  lotos
 * field RFC, removed
 *
 * Revision 2.5  1993/01/18  18:16:12  lotos
 * distribution issues
 *
 * Revision 2.4  1993/01/12  18:37:16  lotos
 * include stdio.h
 *
 * Revision 2.3  1992/12/02  11:04:05  lotos
 * draw and parse functions are controled by options
 * format of parse, changed
 *
 * Revision 2.2  1992/11/17  18:35:08  lotos
 * separate internal (kdatum) and external (udatum)
 * new annotation ldc at the very and of the spec
 * new annotation ldcinit at the beginning
 *
 * Revision 2.1  1992/10/14  18:16:00  lotos
 * new philosophy to write ADTs,
 * every new expression is supposed to be pointed once,
 * in order to share a value, it has to be kd_copy'ed
 * functions assume their arguments are absolutely theirs
 *
 * Revision 1.5  1992/09/02  14:04:23  lotos
 * avoid casting on LHS (for portability)
 *
 * Revision 1.4  92/05/06  18:45:53  lotos
 * debug flag added
 *
 * Revision 1.3  92/01/15  12:45:04  lotos
 * ready to distribute
 *
 * Revision 1.2  91/11/20  13:27:37  lotos
 * parse and eval code added
 *
 * Revision 1.1  91/10/02  17:00:04  lotos
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

#include <stdio.h>
#include <values.h>

extern  int usrb;
extern  int extname;

/* boolean values */

#ifndef TRUE
#  define TRUE	1
#  define FALSE	0
#endif

#ifndef SHARED
#  define PUBLIC
#  define SHARED  extern
#  define PRIVATE static
#endif

/* defines for variables using */
# define IS_FREE  0
# define NOT_FREE 1

/* defines for equaltiy resolution
   EQ: two terms are syntactically equals
   NEQ: tow terms are REALLY differents
   UNDEF: they are not EQ, but it is not possible to say that they are NEQ
*/
# define NEQ 0
# define EQ  1
# define UNDEF -1

/* basic data types */

typedef struct
{ int debug;	/* debugging flag */
  struct
  { int draw;
    int parse;
  } try;
} tKAOS_CFG;

#ifndef intkaos_IMP
extern	tKAOS_CFG kaos;
#else
	tKAOS_CFG kaos= { FALSE, FALSE, FALSE };
#endif

typedef struct Kdatum
{ int:BITS(int)-1;
  int opn;		/* operation identifier */
  struct Klink *lnk;	/* link to arguments */
} *kdatum;

typedef struct Klink
{ struct Kdatum *arg;	/* argument */
  struct Klink *next;	/* next argument */
} *klink;

typedef struct Udatum
{ int:BITS(int)-1;
  int ino;		/* integer number */
  void *ptr;		/* any pointer */
} *udatum;

typedef struct
{ int sid;		/* sort identifier */
  int isextern;		/* is sort extern? */
  char *name;		/* sort name */
  void (*free)();	/* memory deallocation function */
  int (*equal)();	/* equality checking function */
  char *(*draw)();	/* drawing function */
  int (*parse)();	/* parsing function */
} *tSORT_TBL;

extern tSORT_TBL sort_tbl;
extern unsigned sort_tbl_size;

typedef struct
{ int oid;		/* operation identifier */
  int sid;		/* sort identifier */
  int narg;		/* number of arguments */
  int *sarg;		/* sort of arguments */
  int isextern;		/* is operation extern? */
  int isinfix;		/* is operation infix? */
  char *name;		/* operation name */
  kdatum (*eval)();	/* evaluation function */
} *tOPN_TBL;

/* internal table of operations */

typedef struct{
  struct Klink *rnode;        /* pointer to result structure */
  struct C_node *cnode;        /* pointer to condition structure */
  struct F_node *fnode;        /* pointer to failure structure */
} *i_tOPN_TBL;

/* condition structure value node */

typedef struct V_node{
  int value;                   /* value to satisfy */
  int eqn;                     /* equation comment index */
  struct C_node *ncnode;       /* pointer to next condition node */
  struct V_node *nvnode;       /* pointer to next value node */
  struct Klink *nrnode;       /* pointer to result node */
  struct Klink *npnode;       /* pointer to precondition node */
} v_node;

/* condition node */

typedef struct C_node{
  int narg;                    /* number of the condition arguments */
 int *argument;               /* array with the condition arguments */
 struct V_node *nvnode;       /* pointer to the first value node */
} c_node;

/* failure node */

struct F_node{
  char *file;                  /* failure source file */
  int line;                    /* failure source line */
} f_node;

/* structure of the PUSH arguments */

typedef struct A_list{
  int argument;                /* value of the argument */
  struct A_list *next;         /* pointer to next argument */
} a_list;


typedef struct tEQN_TBL{
  int counter;                 /* counter of rewritings */
  char *eqnstr;               /* the equation */
} *tEQN_TBL;

typedef struct{
  char *name;
  int  sid;
  int  use;       /* IS_FREE, NOT_FREE */
  struct Kdatum* value;
  int  lnk;
} *tVAR_TBL;


SHARED unsigned   opn_tbl_size;       /* operation table size */
SHARED tOPN_TBL   opn_tbl;            /* table of operations */
SHARED i_tOPN_TBL i_opn_tbl;          /* internal table of operations */

SHARED tSORT_TBL  sort_tbl;           /* table of sorts */
SHARED unsigned   sort_tbl_size;      /* sort table size */

SHARED tEQN_TBL   eqn_tbl;            /* table of equation comments */
SHARED int        eqn_tsize;          /* size of eqn_tbl */

SHARED tVAR_TBL   var_tbl;            /* table of variables */
SHARED unsigned   var_tbl_size;       /* var table size */
SHARED unsigned   var_size;           /* size of vars */
SHARED int nor;                       /* number of rewritings */
SHARED int rdeb;                      /* comment tracing mode:
				          1 -> yes
					  0 -> no  */

/* error handling functions */

void	put_error (char *format, ...);

/* data handling functions */

void	ldcinit ();

#define kd_alloc()	((kdatum)_xd_alloc())

#define ud_alloc()	((udatum)_xd_alloc())

#define kd_link()	((klink)_xd_link())

#define kd_copy(exp)		((kdatum)_xd_copy(_xd_internal, exp))

#define ud_copy(sort, exp)	((udatum)_xd_copy(sort, exp))

#define kd_const(exp)		((kdatum)_xd_const(_xd_internal, exp))

#define ud_const(sort, exp)	((udatum)_xd_const(sort, exp))

#define kd_free(exp)		(_xd_free(_xd_internal, exp))

#define ud_free(sort, exp)	(_xd_free(sort, exp))

#define kd_equal(exp1, exp2) \
	  (_xd_equal(_xd_internal, exp1, exp2, _xd_preserve))

#define ud_equal(sort, exp1, exp2) \
	  (_xd_equal(sort, exp1, exp2, _xd_preserve))

#define kd_gequal(exp1, exp2, mask) \
	  (_xd_equal(_xd_internal, exp1, exp2, mask))

#define ud_gequal(sort, exp1, exp2, mask) \
	  (_xd_equal(sort, exp1, exp2, mask))

#define kd_draw(exp)		(_xd_draw(_xd_internal, exp, _xd_preserve))

#define ud_draw(sort, exp)	(_xd_draw(sort, exp, _xd_preserve))

#define kd_gdraw(exp, mask)		(_xd_draw(_xd_internal, exp, mask))

#define ud_gdraw(sort, exp, mask)	(_xd_draw(sort, exp, mask))

#define kd_parse(sort, ptr, r)	(_xd_parse(sort, ptr, r))

#define ud_parse(sort, ptr, r)	(_xd_parse(sort, ptr, r))

#define kd_eval(sort, str, r)	(_xd_eval(sort, str, r))

#define ud_eval(sort, str, r)	(_xd_eval(sort, str, r))

#define kd_sort(snm)	_xd_sort(snm)

#define ud_sort(snm)	_xd_sort(snm)

/* Interprete functions */
#define kd_opn(sort, snm)   _xd_opn(sort, snm)

#define ud_opn(sort, snm)   _xd_opn(sort, snm)

#define kd_opn_sort(snm)   _xd_opn_sort(snm)

#define ud_opn_sort(snm)   _xd_opn_sort(snm)

#define kd_kd2sort(dat)    _xd_kd2sort(dat)

#define kd_v_sort(snm)    _xd_v_sort(snm)

#define kd_get_varid(snm,sort)    _xd_get_varid(snm,sort)

#define kd_varid(snm,sort)    _xd_varid(snm,sort)

#define kd_lfvarid(snm,sort)  _xd_lfvarid(snm,sort)

#define kd_rw_node(node)     _xd_rw_node (node)

extern int _xd_var();
extern int _xd_get_varid();
extern int _xd_varid();
extern int _xd_lfvarid();
extern kdatum _xd_rw_node ();

/* internal functions */

#define _xd_internal (-7007)
#define _xd_preserve ((0x1 << 4) | (0x1 << 7))

extern kdatum _xd_alloc();
extern kdatum _xd_copy();
extern kdatum _xd_const();
extern void _xd_free();
extern int _xd_equal();
extern char *_xd_draw();
extern int _xd_parse();
extern int _xd_eval();
extern int _xd_sort();
extern int _xd_opn_sort();

#ifdef lint

/* Interprete functions */
#undef kd_opn
extern int kd_opn();
#undef ud_opn
extern int ud_opn();

#undef kd_opn_sort
extern int kd_opn_sort();
#undef ud_opn_sort
extern int ud_opn_sort();

#undef kd_v_sort
extern int kd_v_sort();
#undef kd_get_varid
extern int kd_get_varid();

#undef kd_varid
extern int kd_varid();
#undef kd_lfvarid
extern int kd_lfvarid();

#undef kd_rw_node
extern kdatum kd_rw_node();

#undef kd_alloc
extern kdatum kd_alloc();
#undef ud_alloc
extern udatum ud_alloc();

#undef kd_link
extern klink kd_link();

#undef kd_copy
extern kdatum kd_copy();
#undef ud_copy
extern udatum ud_copy();

#undef kd_const
extern kdatum kd_const();
#undef ud_const
extern udatum ud_const();

#undef kd_free
extern void kd_free();
#undef ud_free
extern void ud_free();

#undef kd_equal
extern int kd_equal();
#undef ud_equal
extern int ud_equal();

#undef kd_gequal
extern int kd_gequal();
#undef ud_gequal
extern int ud_gequal();

#undef kd_draw
extern char * kd_draw();
#undef ud_draw
extern char * ud_draw();

#undef kd_gdraw
extern char * kd_gdraw();
#undef ud_gdraw
extern char * ud_gdraw();

#undef kd_parse
extern int kd_parse();
#undef ud_parse
extern int ud_parse();

#undef kd_eval
extern int kd_eval();
#undef ud_eval
extern int ud_eval();

#undef kd_sort
extern int kd_sort();
#undef ud_sort
extern int ud_sort();


#endif
#endif
