/******************************************************
 *      ldi.hh:	Semantic analyzer of LOTOS Data Interpreter (LDI)
 ******************************************************/
/***********************************
   (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: ldi.hh,v $
# Revision 1.1  1994/07/19  12:34:59  lotos
# Initial revision
#
 * Revision 1.1  1994/07/18  18:35:21  lotos
 * Initial revision
 *
 * Revision 2.3  1993/09/20  12:39:05  lotos
 * synchronized with kaos development
 * adpated to kdatum
 * udatum are not expected to be used
 * reduce number of reserved words: new user lexicon
 *
 * Revision 2.2  1993/06/22  08:49:38  lotos
 * fix variable redeclaration
 * fix standard input reading (batch mode)
 *
 * Revision 2.1  1993/06/10  13:37:30  lotos
 * completely remade
 *
 * Revision 1.2  1993/01/18  18:26:47  lotos
 * distribution issues
 *
 * Revision 1.1  1992/11/17  18:27:05  lotos
 * Initial revision
 *
 ***********************************/

#ifndef ldi_HH
#define ldi_HH

#define PUBLIC
#define SHARED  extern
#define PRIVATE static


# include <signal.h>
# include "cast.hh"
# include "intkaos.hh"

/*******  general defines   *******/
# define infix 1
# define prefix 0

# define DSORTS 1
# define DOPNS  2
# define DEQNS  3
# define DVARS  4

/*****  exported variables  *****/

SHARED  int     trace;
SHARED  int     ldidebug;

SHARED  int     seqn;
SHARED  int     srw;
SHARED  int     sr;

/*******  basic data types  *******/

PUBLIC	int	ldi_init	();
PUBLIC	int	ldiequal	();
PUBLIC	void	ldistat		();
PUBLIC	void	reset		();

PUBLIC	int	getvsort	();
PUBLIC	int	getopsort	();
PUBLIC	int	getopnar	();
PUBLIC  int     getkdsort       ();

PUBLIC	char*	getvname	();
PUBLIC	char*	getopname	();
PUBLIC	char*	getsname	();
PUBLIC	int	getop_sarg	();
PUBLIC	int*	getopargs	();
PUBLIC	int	get_var_id	();
PUBLIC	int	let_var		();
PUBLIC	int	dec_var		();
PUBLIC	int	free_var	();
PUBLIC	int	reset_var	();
PUBLIC	kdatum	get_value	();
PUBLIC	int	isinfix		();

PUBLIC	int	get_var_size	();
PUBLIC	int	get_opn_size	();


PUBLIC	void	display		();
PUBLIC	void	showdeb		();
PUBLIC	void	setdeb		();
PUBLIC	void	showtrace	();
PUBLIC	void	settrace	();
PUBLIC  int     lnk             ();
PUBLIC  int     get_lnk         ();

/******** kdatum builder functions *******/

PUBLIC kdatum   mknode		();
PUBLIC kdatum   mkprefix	();
PUBLIC kdatum   mkinfix		();
PUBLIC klink    lnsnode		();

#endif
