/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
$Log: swbus.h,v $
 * Revision 1.11  1993/01/18  18:10:25  lotos
 * distribution issues
 *
 * Revision 1.10  1993/01/12  20:19:50  lotos
 * portability issues
 *
 * Revision 1.9  1993/01/12  14:16:27  lotos
 * use conf.h for portability
 * move colour numbers upwards
 *
 * Revision 1.8  1992/02/21  17:12:53  lotos
 * adapted to new lfe
 * better presentation of reports
 *
 * Revision 1.7  92/01/14  15:23:12  lotos
 * distribution issues
 * 
 * Revision 1.6  92/01/13  19:06:13  lotos
 * adapted to ophuscate
 * 
 * Revision 1.5  91/02/28  17:18:58  lotos
 * rule 'premiss ::= _value_expression' removed
 * 
 * Revision 1.4  90/10/30  09:38:33  lotos
 * adapted to new CAST
 * 
 * Revision 1.3  90/07/06  20:33:45  lotos
 * add option -n to list single types
 * 
 * Revision 1.2  90/06/04  10:42:58  lotos
 * types are classified into
 * basic: not importing any other
 * constructed: importing others (via union, rename, or act)
 * used by others
 * not used by any other
 * those build by renaming of other
 * those built by actualizing other
 * 
 * options are mutually exclusive
 * 
 * Revision 1.1  90/05/11  12:53:57  lotos
 * Initial revision
 * 
 ***********************************/

#define PUBLIC
#define PRIVATE static
#define SHARED extern

# include <stdlib.h>
# include <stdio.h>
# include <string.h>
# include <ctype.h>
# include <assert.h>
# include "version.h"

# include "cast.hh"
# include "rag.hh"
# include "nodes.h"

# include "colours.h"

# define c_dec        91
# define c_typexr     92
# define c_type_class 93
# define c_lib_used   94
# define c_is_lib     95

/*+++++ +++++*/
# define TSPEC  1
# define TTYPE  2
# define TSORT  3
# define TOPN   4
# define TPROC  5
# define TGATE  6
# define TVAL   7
/*+++++ +++++*/

/* The types have to be one of the following */
# define UNION 1
# define RENAMED 2
# define ACTUALIZED 3

typedef struct TypeList {
  int      iddec;
  struct   TypeList* next;
} TUSEDNODE;

typedef struct TypeDepend {
  int               iddec;
  char              *name;
  struct TypeDepend *next;
} TYPEDEPEND;

typedef struct Symbol {
  char*      typename;
  int        iddec;
  int        line;
  struct     Symbol* left;
  struct     Symbol* right;
  int        type_class;
  TYPEDEPEND *typexr;		/* Mantiene la lista de dependencias */
				/* del tipo. Cada dependencia ocupa */
				/* dos nodos. El primero es iddec como */
				/* string y el segundo el lexv */
} SNODE;

SHARED ST        *SLTable;
SHARED AT        *SATable;
SHARED char      *progname;
SHARED SNODE     *tsroot;
SHARED TUSEDNODE *tusedroot;

PUBLIC char*    emalloc ();
PUBLIC void     addonetype ();
PUBLIC int      NotIn ();
PUBLIC void     print_item ();
PUBLIC SNODE*	puttypexr ();
PUBLIC void	print_ts();
PUBLIC INTlist  INT2cons();
PUBLIC SNODE*   name_search ();
