/******************************************************
 *      ast2cr.c: translator from AST to cr
 ******************************************************/
/**********************************************
* (C) Copyright 1992; The LotoSphere Consortium
***********************************************
$Log: ast2cr.c,v $
 * Revision 2.4  1993/06/16  13:52:51  lotos
 * code cleaning
 * new annotations
 * sort annonations (arbitrary)
 * detect invalid options
 *
 * Revision 2.3  1992/11/17  17:19:05  lotos
 * adapted to new naming convention
 *
 * Revision 2.2  1992/09/11  16:55:13  lotos
 * track new location of annotations
 *
 * Revision 2.1  1992/05/07  19:48:17  lotos
 * integreted into topo
 *
 * Revision 1.8  92/03/05  18:50:01  gabriel
 * Adapted to CR v9
 *
 * Revision 1.7  92/03/05  18:24:18  gabriel
 * colours.h colours.c grc.h nodes.h included as sources
 *
 * Revision 1.6  92/01/31  11:34:59  gabriel
 * Adapted to TOPO 2R1.
 * It generates the CR as writen originally by the user.
 * Fixed the data types representation: now, it contains the original
 * data types and the semi-flattened versions of them.
 * Also the library is now correctly generated, with their own semi-
 * flattened representation.
 *
 * Revision 1.5  92/01/08  13:39:03  gabriel
 * Added annotations for the lite compiler (colos)
 * Removed unneeded strdup's
 * Added progname variable
 *
 * Revision 1.4  91/11/19  20:24:26  gabriel
 * Corrected bugs related with memory management in aux.c.
 *
 * Revision 1.3  91/09/24  09:49:22  gabriel
 * Adapted to TOPO 1R7
 *
 * Revision 1.2  91/07/05  18:25:26  gabriel
 * Cosmetics
 * Adapted to new version of TOPO
 *
 * Revision 1.1  91/07/05  18:13:03  gabriel
 * Initial revision
 *
 ***********************************/

#ifndef lint
static char rcsid[]= "$Id: ast2cr.c,v 2.4 1993/06/16 13:52:51 lotos Exp $";
#endif

# include "swbus.h"

/* KJT 11/03/98: added for NS/OS */

#ifdef __NeXT__
char *strdup(s) register char *s; {

  register char *ns;

  return(((ns=malloc(strlen(s)+1))==0)?0:strcpy(ns,s)); }
#endif

PRIVATE	TIOCOLOURS iocolours [] = {
#include "colours.c"

  "mytid",    c_mytid,                            IO_int,
  "isformal", c_isformal,                         IO_int,
  "yes_sfl",  c_yes_sflat,                        IO_int,
  /* This colour indicates, if exist, that the type */
  /* has been semiflattened. It appears in _type_definition */

  "mylexv", c_mylexv,                             IO_str,
  "spec", c_ccr_specification,                    IO_ign,
  "pi",   c_ccr_process_identifier,               IO_ign,
  "si",   c_ccr_specification_identifier,         IO_ign,
  "gil",  c_ccr_gate_identifier_list,             IO_ign,
  "idl",  c_ccr_identifier_declaration_list,      IO_ign,
  "func", c_ccr_functionality,                    IO_ign,
  "dtdl", c_ccr_data_type_definition_list,        IO_ign,
  "db",   c_ccr_definition_block,                 IO_ign,
  "annl", c_ccr_annotation_list,                  IO_ign,
  "be",   c_ccr_behaviour_expression,             IO_ign,
  "sil",  c_ccr_sort_identifier_list,             IO_ign,
  "si",   c_ccr_sort_identifier,                  IO_ign,
  "eel",  c_ccr_exit_entry_list,                  IO_ign,
  "ee",   c_ccr_exit_entry,                       IO_ign,
  "ve",   c_ccr_value_expression,                 IO_ign,
  "vel",  c_ccr_value_expression_list,            IO_ign,
  "ad",   c_ccr_action_denotation,                IO_ign,
  "eol",  c_ccr_experiment_offer_list,            IO_ign,
  "eo",   c_ccr_experiment_offer,                 IO_ign,
  "go",   c_ccr_guard_option,                     IO_ign,
  "gi",   c_ccr_gate_identifier,                  IO_ign,
  "pd",   c_ccr_process_definition,               IO_ign,
  "pdl",  c_ccr_process_definition_list,          IO_ign,
  "dtd",  c_ccr_data_type_definition,             IO_ign,
  "ftd",  c_ccr_flattened_type_definition,        IO_ign,
  "sd",   c_ccr_sort_declaration,                 IO_ign,
  "sdl",  c_ccr_sort_declaration_list,            IO_ign,
  "ol",   c_ccr_operation_list,                   IO_ign,
  "aeo",  c_ccr_actual_equations_option,          IO_ign,
  "feo",  c_ccr_formal_equations_option,          IO_ign,
  "fol",  c_ccr_formal_operation_list,            IO_ign,
  "fsdl", c_ccr_formal_sort_declaration_list,     IO_ign,
  "til",  c_ccr_type_identifier_list,             IO_ign,
  "ti",   c_ccr_type_identifier,                  IO_ign,
  "pe",   c_ccr_p_expression,                     IO_ign,
  "repl", c_ccr_replacement,                      IO_ign,
  "srl",  c_ccr_sort_replacement_list,            IO_ign,
  "sr",   c_ccr_sort_replacement,                 IO_ign,
  "orl",  c_ccr_operation_replacement_list,       IO_ign,
  "or",   c_ccr_operation_replacement,            IO_ign,
  "oper", c_ccr_operation,                        IO_ign,
  "iel",  c_ccr_identifier_equation_list,         IO_ign,
  "ie",   c_ccr_identifier_equation,              IO_ign,
  "id",   c_ccr_identifier_declaration,           IO_ign,
  "gdl",  c_ccr_gate_declaration_list,            IO_ign,
  "gd",   c_ccr_gate_declaration,                 IO_ign,
  "vi",   c_ccr_value_identifier,                 IO_ign,
  "avi",  c_ccr_annotated_value_identifier,       IO_ign,
  "oi",   c_ccr_operation_identifier,             IO_ign,
  "pi",   c_ccr_prefix_infix,                     IO_ign,
  "po",   c_ccr_parallel_operator,                IO_ign,
  "vil",  c_ccr_value_identifier_list,            IO_ign,
  "eity", c_ccr_equality,                         IO_ign,
  "esl",  c_ccr_equation_structure_list,          IO_ign,
  "es",   c_ccr_equation_structure,               IO_ign,
  "eion", c_ccr_equation,                         IO_ign,
  "el",   c_ccr_equation_list,                    IO_ign,
  "pl",   c_ccr_premiss_list,                     IO_ign,
  "cstr", c_ccr_casestring,                       IO_ign,
  NULL,   others,                                 IO_ign
  };

PRIVATE FILE* specfile = NULL;
PRIVATE FILE* alfile   = NULL;
PRIVATE FILE* sfile   = NULL;

PUBLIC	char	*progname = NULL;
PUBLIC  AT*     ATable;
PUBLIC  int     debugging = FALSE;
PUBLIC  int     printable = FALSE;
PUBLIC  int     mk_unique = 0;

PUBLIC  TNODE   **sflt;

void
help ()
{
  (void) fprintf (stderr, "usage: %s -n<name> [options]\n", progname);
  (void) fprintf (stderr, "\t\t<name> specification name\n");
  (void) fprintf (stderr, "\toptions:\n");
  (void) fprintf (stderr, "\t\t-d debuging\n");
  (void) fprintf (stderr, "\t\t-p printable\n");
  (void) fprintf (stderr, "\t\t-h help\n");
  (void) fprintf (stderr, "\tNo arguments: help\n");
}

/* KJT 20/01/23: added "int" type" */
int main (argc, argv)
     int argc;
     char* argv[];
{
  char	 *specname = NULL, *alname = NULL, *lname = NULL, *sname = NULL;
  TNODE  *astroot  = NULL;		/* AST root creation*/
  TNODE  *alroot   = NULL;
  TNODE  *sfltroot = NULL;
  TNODE  *aux      = NULL;
  int    i;
  char   c;
  int    luid;
  int    tid;

  progname = argv[0];
  if (argc == 1) {
    help ();
    exit (0);
  }
  while (argc > 1) {
    if (argv[1][0] == '-') {
      i = 0;
      while ((c = argv[1][++i]) != '\0')
	switch (c) {
	  case 'd' : debugging = TRUE; break;
	  case 'h' : help(); exit(0);
	  case 'n' : specname = strdup(&(argv[1][++i]));
		     i = strlen(argv[1]) - 1;
		     break;
	  case 'p' : printable = TRUE; break;
	  default  : help(); exit(1);
	  }
    }
    else {
      help ();
      exit(1);
    }
    argc--;
    argv++;
  }

  cast_init (iocolours);

  befussy = FALSE;

  if (strlen (specname) != 0) {
    alname = emalloc ((strlen (specname) + 5)*sizeof(char));
    lname  = emalloc ((strlen (specname) + 5)*sizeof(char));
    sname  = emalloc ((strlen (specname) + 5)*sizeof(char));

    (void)sprintf (alname, "%s.asc", specname);
    (void)sprintf (lname, "%s.lsc", specname);
    (void)sprintf (sname, "%s.lcr", specname);

    specfile = fopen (lname, "r");
    if (!specfile) {
      (void)fprintf (stderr, "%s: No such file: %s\n", progname, lname);
      exit (1);
    }
    alfile = fopen (alname, "r");
    if (!alfile) {
      (void)fprintf (stderr, "%s: No such file: %s\n", progname, alname);
      exit (1);
    }
    sfile = fopen (sname, "r");
    if (!sfile) {
      (void)fprintf (stderr, "%s: No such file: %s\n", progname, sname);
      exit (1);
    }
    astroot = restore (specfile);
    grnl = (IAT*) find_attr (c_grnl, astroot)->value;
    grnl->class = 1;
    alroot = restore (alfile);
    SymbolTable= (ST*) find_attr (c_ll, alroot)->value;
    ATable = (AT*) find_attr (c_at, alroot)->value;

    sfltroot = restore (sfile);
    luid = (int)find_attr(c_luid,astroot)->value;
    sflt = (TNODE**) emalloc ((unsigned)((luid+1)*sizeof(TNODE*)));
    for (i = 0 ; i <= luid; i++)
      sflt[i] = NULL;
    for (aux = gt_fs(sfltroot); aux != NULL; aux = gt_rb (aux)) {
      tid = (int) find_attr (c_iddec, gt_fs(aux))->value;
      set_attr (c_yes_sflat, aux, (CLR_TYPE) TRUE);
      sflt[tid] = aux;
    }
    for (i = 0; i<=luid; i++)
      if (sflt[i] != NULL) {
	sflt[i]->father = NULL;
	sflt[i]->brothers = NULL;
	rag (sflt[i]);
	/* this cannot be done in the last 'for' loop because its   */
	/* brothers has to be set to NULL before calling 'rag', and */
	/* the last loop depends on the 'brothers'.                 */
      }
  }

  rag (astroot);		/* Table creation from the AST */

  print_spe ((cr_specification)find_attr(c_ccr_specification, astroot)->value);

  if (debugging) {
    save_tree (stdout, astroot);
    exit(0);
  }

  exit (0);
}
