#ifndef adalng_HH
#define adalng_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "adalng.hh": symbols of ADA LaNGuage (using KAOS library).
***********************************************************************/

/***********************************
  (C) Copyright 1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: adalng.desc,v $
 * Revision 3.4  1994/07/18  17:55:15  lotos
 * Adapted to GNAT compiler
 *
 * Revision 3.3  1993/06/10  14:06:18  lotos
 * new annotation CALL
 *
 * Revision 3.2  1993/05/28  10:58:04  lotos
 * cosmetics
 *
 * Revision 3.1  1993/05/25  11:08:41  lotos
 * new release
 *
 ***********************************/


/* indentation data */

#define DFL_INDT_INCR	 2
#define MAX_INDT_INCR	16

/* splitting data */

#define MIN_SPLT_PICS	   1
#define MAX_SPLT_PICS	1000

/* text of comments */

#define CMT_BEGIN	"BEGIN"
#define CMT_END		"END"
#define CMT_OPN_DCLS	"operation declarations"
#define CMT_SORT_TBL	"sort table"
#define CMT_FREE_TBL	"free table"
#define CMT_EQUAL_TBL	"equal table"
#define CMT_DRAW_TBL	"draw table"
#define CMT_PARSE_TBL	"parse table"
#define CMT_OPN_TBL	"operation table"
#define CMT_EVAL_TBL	"eval table"
#define CMT_CNS_STG	"constant storage"
#define CMT_CALL_DFNS	"external call definitions"
#define CMT_OPN_STBS	"operation stubs"
#define CMT_OPN_DFNS	"operation definitions"

/* text of error messages */

#define MSG_PTL_INTRO	"partial operation failure"
#define MSG_PTL_LINE	"see line"
#define MSG_PTL_FILE	"of file"
#define MSG_PTL_OPN	"name"
#define MSG_PTL_ARG	"arg"

#define MSG_BFL_HINTRO	"non-constructor failure"
#define MSG_BFL_TINTRO	"unable to build term of external sort"
#define MSG_BFL_LINE	"see line"
#define MSG_BFL_FILE	"of file"
#define MSG_BFL_OPN	"name"
#define MSG_BFL_ARG	"arg"

/* symbols for building identifiers */

#define PACK_NAME	"KTYPE_PAK"	/* package name */
#define ARG_ROOT	"p"		/* argument name root */
#define VAL_NAME	"v"		/* value name */
#define LNK_ROOT	"s"		/* link name root */
#define CNS_STG		"konst"		/* constant storage name */

/* symbols of Ada language */

#define A_WITH		"with"
#define A_USE		"use"
#define A_SEPARATE	"separate"
#define A_PACKAGE	"package"
#define A_FUNCTION	"function"
#define A_PROCEDURE	"procedure"
#define A_DECLARE	"declare"
#define A_IN		"in"
#define A_OUT		"out"
#define A_BODY		"body"
#define A_IS		"is"
#define A_BEGIN		"begin"
#define A_END		"end"
#define A_NEW		"new"
#define A_IF		"if"
#define A_THEN		"then"
#define A_ELSE_IF	"elsif"
#define A_ELSE		"else"
#define A_ENDIF		"end if"
#define A_CASE		"case"
#define A_WHEN		"when"
#define A_ENDCASE	"end case"
#define A_RETURN	"return"
#define A_RAISE		"raise"
#define A_BOOLEAN	"boolean"
#define A_INTEGER	"integer"
#define A_STRING	"string"
#define A_TRUE		"true"
#define A_FALSE		"false"
#define A_NOT		"not"
#define A_AND_THEN	"and then"
#define A_NULL		"null"
#define A_OTHERS	"others"
#define A_PROGRAM_ERROR	"PROGRAM_ERROR"

/* symbols of KAOS library */

#define KAOS_PACK	"kaos_pak"

#define K_DEBUG		"kaos.debug"

#define K_DATUM		"kdatum"
#define K_OPN		"opn"
#define K_LNK		"lnk"

#define K_LINK		"klink"
#define K_ARG		"arg"
#define K_NEXT		"next"

#define U_DATUM		"udatum"
#define U_INO		"ino"
#define U_PTR		"ptr"

#define K_TYPE_MASK	"tMASK"

#define K_TABLE_DATA	"ktable_data"
#define K_TABLE_FUNC	"ktable_func"

#define K_TYPE_SORT_TBL	"tSORT_TBL"
#define K_TYPE_SORT_MTX	"tSORT_MATRIX"
#define K_SID		"sid"
#define K_ISEXTERN	"isextern"
#define K_NAME		"name"
#define K_SORT_TBL	"sort_tbl"
#define K_SORT_TBL_INIT	"sort_tbl_init"

#define K_FREE_TBL	"free_tbl"
#define K_EQUAL_TBL	"equal_tbl"
#define K_DRAW_TBL	"draw_tbl"
#define K_PARSE_TBL	"parse_tbl"
#define K_SORT		"sort"
#define K_EXP		"exp"
#define K_STR		"str"
#define K_NDX		"ndx"
#define K_VAL		"r"
#define K_OK		"ok"

#define K_TYPE_OPN_TBL	"tOPN_TBL"
#define K_TYPE_OPN_MTX	"tOPN_MATRIX"
#define K_TYPE_SARG_MTX	"tSARG_MATRIX"
#define K_OID		"oid"
#define K_SID		"sid"
#define K_SARG		"sarg"
#define K_ISEXTERN	"isextern"
#define K_ISINFIX	"isinfix"
#define K_NAME		"name"
#define K_OPN_TBL	"opn_tbl"
#define K_OPN_TBL_INIT	"opn_tbl_init"

#define K_TYPE_ARG_MTX	"tARG_MATRIX"
#define K_EVAL_TBL	"eval_tbl"
#define K_OPN		"opn"
#define K_ARG_MTX	"arg"

#define K_PUT_ERROR	"put_error"

#define K_FDATUM	"x2kdatum"

#define U_FDATUM	"x2udatum"

#define K_FALLOC	"kd_alloc"
#define K_FLINK		"kd_link"

#define U_FALLOC	"ud_alloc"

#define K_FCOPY		"kd_copy"
#define K_FCONST	"kd_const"
#define K_FFREE		"kd_free"
#define K_FEQUAL	"kd_equal"
#define K_GRL_FEQUAL	"kd_gequal"
#define K_FDRAW		"kd_draw"
#define K_GRL_FDRAW	"kd_gdraw"
#define K_FPARSE	"kd_parse"
#define K_FEVAL		"kd_eval"
#define K_FSORT		"kd_sort"

#define U_FCOPY		"ud_copy"
#define U_FCONST	"ud_const"
#define U_FFREE		"ud_free"
#define U_FEQUAL	"ud_equal"
#define U_GRL_FEQUAL	"ud_gequal"
#define U_FDRAW		"ud_draw"
#define U_GRL_FDRAW	"ud_gdraw"
#define U_FPARSE	"ud_parse"
#define U_FEVAL		"ud_eval"
#define U_FSORT		"ud_sort"

#define K_KONST		"konstant"
#define K_FIRST		"first"
#define K_VALUE		"value"
#define K_DONE		"done"
#endif
