# *************************************************************
#	kaos: Kernel of CAOS (Ada version), code generation
# *************************************************************
#***********************************
# (C) Copyright 1993; dit/upm
#  Distributed under the conditions stated in the
#  TOPO General Public License (see file LICENSE)
#***********************************
# $Id: kaos.make,v 3.2 1993/06/23 16:47:23 lotos Exp $
#***********************************

#ADACPL= NONE
#ADARTS= sequence
#ADARTS= parallel

ADASRCS= kaos.a kaos_b.a $(ADARTS)_s.a

ADAMKF= $(TOPOLIB)/ada
ADALIB= $(MAKE) $(MFLAGS) -f $(ADACPL).mk

NOOP:

make:	$(ADACPL).init $(ADACPL).done

$(ADACPL).init:	$(ADACPL).mk
	$(ADALIB) init
	touch $@

$(ADACPL).done:	$(ADASRCS)
	for src in $(ADASRCS); do		\
	  $(ADALIB) compile SRC="$$src";	\
	done
	touch $@

freeze:	$(ADACPL).freeze

$(ADACPL).freeze:	$(ADACPL).init $(ADACPL).done
	$(ADALIB) export
	touch $@

$(ADACPL).mk:
	cp $(ADAMKF)/$@ $@

clean:	$(ADACPL).mk
	$(ADALIB) clean
	rm -f $(ADACPL).freeze
	rm -f $(ADACPL).done
	rm -f $(ADACPL).init
