#ifndef clng_HH
#define clng_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "clng.hh": symbols of C LaNGuage (using KAOS library).
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: clng.desc,v $
 * Revision 2.9  1993/06/10  14:03:45  lotos
 * new annotation CALL
 *
 * Revision 2.8  1993/05/25  11:02:30  lotos
 * anotaciones ldcend y ldcinit pasan al principio
 *
 * Revision 2.7  1993/03/24  17:48:31  lotos
 * field RFC, removed
 *
 * Revision 2.6  1993/01/18  18:16:12  lotos
 * distribution issues
 *
 * Revision 2.5  1993/01/12  18:36:51  lotos
 * aloow a prefix for a single piece
 *
 * Revision 2.4  1992/12/09  10:49:32  lotos
 * split into pieces
 *
 * Revision 2.3  1992/12/02  11:02:33  lotos
 * draw and parse functions are controled by options
 *
 * Revision 2.2  1992/11/17  18:35:08  lotos
 * separate internal (kdatum) and external (udatum)
 * new annotation ldc at the very and of the spec
 * new annotation ldcinit at the beginning
 *
 * Revision 2.1  1992/10/14  18:16:00  lotos
 * new philosophy to write ADTs,
 * every new expression is supposed to be pointed once,
 * in order to share a value, it has to be kd_copy'ed
 * functions assume their arguments are absolutely theirs
 *
 * Revision 1.6  1992/09/02  14:04:23  lotos
 * avoid casting on LHS (for portability)
 *
 * Revision 1.5  92/02/29  13:26:33  lotos
 * flags for pretty printing: optional
 * 
 * Revision 1.4  92/01/15  12:44:54  lotos
 * ready to distribute
 * 
 * Revision 1.3  91/11/20  13:25:22  lotos
 * parse and eval code added
 * 
 * Revision 1.2  91/11/14  12:50:45  lotos
 * term builders fixed
 * 
 * Revision 1.1  91/10/02  16:59:21  lotos
 * Initial revision
 * 
 ***********************************/


/* indentation data */

#define DFL_INDT_INCR	 2
#define MAX_INDT_INCR	16

/* splitting data */

#define MIN_SPLT_PICS	   1
#define MAX_SPLT_PICS	1000

/* text of comments */

#define CMT_BEGIN	"BEGIN"
#define CMT_END		"END"
#define CMT_OPN_DCLS	"operation declarations"
#define CMT_SORT_TBL	"sort table"
#define CMT_ARG_BUF	"argument buffer"
#define CMT_EVAL_OPN	"evaluator of operations"
#define CMT_OPN_TBL	"operation table"
#define CMT_CALL_DFNS	"external call definitions"
#define CMT_OPN_DFNS	"operation definitions"

/* text of error messages */

#define MSG_PTL_INTRO	"partial operation failure"
#define MSG_PTL_LINE	"see line"
#define MSG_PTL_FILE	"of file"
#define MSG_PTL_OPN	"name"
#define MSG_PTL_ARG	"arg"

#define MSG_BFL_HINTRO	"non-constructor failure"
#define MSG_BFL_TINTRO	"unable to build term of external sort"
#define MSG_BFL_LINE	"see line"
#define MSG_BFL_FILE	"of file"
#define MSG_BFL_OPN	"name"
#define MSG_BFL_ARG	"arg"

/* symbols for building identifiers */

#define HEAD_NAME	"KTYPE_HH"	/* header name */
#define CODE_NAME	"KTYPE_IMP"	/* code name */
#define ARG_ROOT	"_p"		/* argument name root */
#define VAL_NAME	"_v"		/* value name */
#define LNK_ROOT	"_s"		/* link name root */
#define ARG_BUF		"_arg_buf"	/* argument buffer */
#define EVAL_OPN	"_eval_opn"	/* evaluator of operations: */
#define EVAL_OID	"_oid"		/*   * operation identifier */
#define EVAL_ARG	"_arg"		/*   * operation arguments  */

/* symbols of C language */

#define C_INCLUDE	"include"
#define C_DEFINE	"define"
#define C_IFNDEF        "ifndef"
#define C_ENDIF         "endif"
#define C_EXTERN	"extern"
#define C_STATIC	"static"
#define C_VOID		"void"
#define C_INT		"int"
#define C_UNSIGNED	"unsigned"
#define C_IF		"if"
#define C_ELSE_IF	"else if"
#define C_ELSE		"else"
#define C_SWITCH	"switch"
#define C_CASE		"case"
#define C_DEFAULT	"default"
#define C_BREAK		"break"
#define C_RETURN	"return"
#define C_EXIT		"exit"

/* symbols of KAOS library */

#define KAOS_H		"kaos.hh"

#define K_TRUE		"TRUE"
#define K_FALSE		"FALSE"
#define K_NULL		"NULL"

#define K_DEBUG		"kaos.debug"

#define K_DATUM		"kdatum"
#define K_OPN		"opn"
#define K_LNK		"lnk"

#define K_LINK		"klink"
#define K_ARG		"arg"
#define K_NEXT		"next"

#define U_DATUM		"udatum"
#define U_INO		"ino"
#define U_PTR		"ptr"

#define K_TYPE_SORT_TBL	"tSORT_TBL"
#define K_SID		"sid"
#define K_ISEXTERN	"isextern"
#define K_NAME		"name"
#define K_FREE		"free"
#define K_EQUAL		"equal"
#define K_DRAW		"draw"
#define K_PARSE		"parse"
#define K_SORT_TBL	"sort_tbl"
#define K_SIZE_SORT_TBL	"sort_tbl_size"

#define K_TYPE_OPN_TBL	"tOPN_TBL"
#define K_OID		"oid"
#define K_SID		"sid"
#define K_NARG		"narg"
#define K_SARG		"sarg"
#define K_ISEXTERN	"isextern"
#define K_ISINFIX	"isinfix"
#define K_NAME		"name"
#define K_EVAL		"eval"
#define K_OPN_TBL	"opn_tbl"
#define K_SIZE_OPN_TBL	"opn_tbl_size"

#define K_PUT_ERROR	"put_error"

#define K_LDCINIT       "ldcinit"

#define K_FALLOC	"kd_alloc"
#define K_FLINK		"kd_link"

#define U_FALLOC	"ud_alloc"

#define K_FCOPY		"kd_copy"
#define K_FCONST	"kd_const"
#define K_FFREE		"kd_free"
#define K_FEQUAL	"kd_equal"
#define K_GRL_FEQUAL	"kd_gequal"
#define K_FDRAW		"kd_draw"
#define K_GRL_FDRAW	"kd_gdraw"
#define K_FPARSE	"kd_parse"
#define K_FEVAL		"kd_eval"
#define K_FSORT		"kd_sort"

#define U_FCOPY		"ud_copy"
#define U_FCONST	"ud_const"
#define U_FFREE		"ud_free"
#define U_FEQUAL	"ud_equal"
#define U_GRL_FEQUAL	"ud_gequal"
#define U_FDRAW		"ud_draw"
#define U_GRL_FDRAW	"ud_gdraw"
#define U_FPARSE	"ud_parse"
#define U_FEVAL		"ud_eval"
#define U_FSORT		"ud_sort"
#endif
