/***********************************************************************
     "dtok.o": lotos Data language TOKenizer.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: dtok.c,v $
 * Revision 1.11  1995/01/17  09:52:43  lotos
 *  new entry in intermediate language: number of declarations
 *
 * Revision 1.10  1993/03/24  17:50:25  lotos
 * new annotation 'infix'
 *
 * Revision 1.9  1993/01/18  18:12:01  lotos
 * distribution issues
 *
 * Revision 1.8  1992/10/14  18:06:17  lotos
 * sort annotation added
 *
 * Revision 1.7  1992/10/14  18:03:46  lotos
 * forget ophuscation
 *
 * Revision 1.6  1992/09/02  14:00:15  lotos
 * accepts labelled equations
 * accepts textual equations
 *
 * Revision 1.5  92/01/14  15:24:40  lotos
 * distribution issues
 * 
 * Revision 1.4  92/01/13  19:17:38  lotos
 * ophuscation
 * 
 * Revision 1.3  91/11/14  12:57:08  lotos
 * restructured to handle comments
 * new annotation fail
 * 
 * Revision 1.2  91/10/02  16:43:01  lotos
 * skip empty records, under control of a variable
 * 
 * Revision 1.1  91/07/11  14:04:29  lotos
 * Initial revision
 * 
 ***********************************/

#include "version.h"
#ifndef lint
static char rcsid[]= "$Id: dtok.c,v 1.11 1995/01/17 09:52:43 lotos Exp $";
#endif

/* LINTLIBRARY */

#define dtok_IMP

#include <stdio.h>
#define dlng_IMP
#include "dtok.hh"


sREC *get_rec()
{
  static sREC *rec= NULL;
  int n;

  if (new_rec(rec))
    ;
  else
    return NULL;
  switch (add_fld(rec, SYM))
  {
    /* Isolated Comments */

    case COMMENT:
      (void) add_fld(rec, STR);
      break;
    case BEGIN_COMMENT:
      break;
    case LINE_QUOTE:
      (void) add_fld(rec, STR);
      break;
    case END_COMMENT:
      break;
    case ANNOTATION:
      if (add_fld(rec, SYM) == SORT_ANNOTATION)
	(void) add_fld(rec, INT);
      else
	(void) add_fld(rec, STR);
      break;
    case BEGIN_ANNOTATION:
      switch (add_fld(rec, SYM))
      { case PARTIAL_ANNOTATION:
	  (void) add_fld(rec, SYM);
	  (void) add_fld(rec, INT);
	  (void) add_fld(rec, SYM);
	  break;
	case RULE_ANNOTATION:
	  (void) add_fld(rec, INT);
	  (void) add_fld(rec, INT);
	  (void) add_fld(rec, SYM);
	  break;
      }
      break;
    case END_ANNOTATION:
      break;

    /* Sorts Declaration */

    case BEGIN_SORTS_DECL:
      (void) add_fld(rec, INT);
      break;
    case SORT_DECL:
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, INT);
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, SYM);
      break;
    case END_SORTS_DECL:
      break;

    /* Operations Declaration */

    case BEGIN_OPERATIONS_DECL:
      (void) add_fld(rec, INT);
      break;
    case OPERATION_DECL:
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, INT);
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, INT);
      n= add_fld(rec, INT);
      while (n-- > 0)
	(void) add_fld(rec, INT);
      break;
    case END_OPERATIONS_DECL:
      break;

    /* Operations Definition */

    case BEGIN_OPERATION_DEF:
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, INT);
      n= add_fld(rec, INT);
      while (n-- > 0)
	(void) add_fld(rec, INT);
      break;

    /* Rules */

    case BEGIN_RULE:
      (void) add_fld(rec, INT);
      break;

    /* Patterns */

    case BEGIN_PATTERN:
      (void) add_fld(rec, INT);
      (void) add_fld(rec, INT);
      break;
    case OPERATION_MATCH:
      (void) add_fld(rec, INT);
      while (add_fld(rec, INT) != EINT)
	;
      break;
    case VALUE_MATCH:
      while (add_fld(rec, INT) != EINT)
	;
      break;
    case END_PATTERN:
      break;

    /* Conditions */

    case BEGIN_CONDITION:
      break;
    case END_CONDITION:
      break;

    /* Replacements */

    case BEGIN_REPLACEMENT:
      break;
    case OPERATION_EVAL:
      (void) add_fld(rec, SYM);
      (void) add_fld(rec, INT);
      (void) add_fld(rec, INT);
      break;
    case VALUE_EVAL:
      while (add_fld(rec, INT) != EINT)
	;
      break;
    case END_REPLACEMENT:
      break;
    case END_RULE:
      break;

    /* Buildings */ 

    case BUILD:
      (void) add_fld(rec, INT);
      (void) add_fld(rec, INT);
      break;

    case END_OPERATION_DEF:
      break;

    case ESYM:
      if (ign_empty_rec)
	return get_rec();
      break;
    default:
      abort_if(TRUE)
  }
  switch (add_fld(rec, SYM))
  {
    /* Inline Comments */

    case COMMENT:
      (void) add_fld(rec, STR);
      break;
    case ANNOTATION:
      switch (add_fld(rec, SYM))
      { case FAIL_ANNOTATION:
	  (void) add_fld(rec, SYM);
	  (void) add_fld(rec, INT);
	  (void) add_fld(rec, SYM);
	  break;
	case INFIX_ANNOTATION:
	  break;
	default:
	  (void) add_fld(rec, STR);
	  break;
      }
      break;

    case ESYM:
      break;
    default:
      abort_if(TRUE)
  }
  return rec;
}
