/***********************************************************************
     "basic.o": BASIC functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: basic.c,v $
 * Revision 1.2  1993/03/29  18:14:34  lotos
 * keep lint shut down
 *
 * Revision 1.1  1993/03/18  11:14:24  lotos
 * Initial revision
 *
 ***********************************/

/* KJT 29/10/04: changed to use "stdarg" instead of "varargs" */

#ifndef lint
static char rcsid[]= "$Id: basic.c,v 1.2 1993/03/29 18:14:34 lotos Exp $";
#endif

#define basic_IMP

/* KJT 12/02/12: Added */
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "glad.hh"
#include "basic.hh"


/*
 *** LINT passing (complaints suppression) functions ***
 */

#ifdef lint
   int __NOOP__= 0;
#endif

#ifdef lint
   int __TEST__= 0;
#endif

#ifdef lint
   int __EVAL__= TRUE;
#endif


/*
 *** Error handling functions ***
 */

PUBLIC void
start_error (char *head, va_list args)
{
  if (prog_name != NULL &&
      *prog_name != '\0')
    (void) fprintf(stderr, "%s: ", prog_name);
  if (head != NULL)
    (void) vfprintf(stderr, head, args);
}

PUBLIC void
complete_error (char *body, va_list args)
{
  (void) vfprintf(stderr, body, args);
  (void) fprintf(stderr, "\n");
}

PUBLIC void
explain_error (char *body, va_list args)
{
  if (prog_name != NULL)
    (void) fprintf(stderr, "%*s  (", strlen(prog_name), "");
  (void) vfprintf(stderr, body, args);
  (void) fprintf(stderr, ")\n");
}

/* calls a function with varargs argument list */

PUBLIC void
varargs_error (func_error func, char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  (*func)(msg, args);
  va_end(args);
}

PUBLIC void
error (char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  /* KJT 12/02/12: was "(val_list) NULL" */
  start_error((char *) NULL, NULL);
  complete_error(msg, args);
  va_end(args);
}

PUBLIC void
fail (char *msg, ...)
{
  va_list args;

  va_start(args, msg);
  /* KJT 12/02/12: was "(val_list) NULL" */
  start_error((char *) NULL, NULL);
  complete_error(msg, args);
  va_end(args);
  exit(1);
}


/*
 *** Programming error detection functions ***
 */

/* writes a condition error message and aborts */

PUBLIC void
_cond_error (file, line)
  char *file;
  int line;
{
  error("abnormal condition: file \"%s\", line %d", file, line);
  abort();
}


/*
 *** Memory allocation functions ***
 */

/* writes an allocation error message and exits (code 1) */

PUBLIC void
_alloc_error ()
{
  error("not enough memory");
  exit(1);
}

/* stops "lint" complaints about malloc() */

#ifdef lint
PUBLIC void *
_call_malloc(size)
  unsigned size;
{
  return ALIN(void, (char *) malloc(size));
}
#endif

/* stops "lint" complaints about realloc() */

#ifdef lint
PUBLIC void *
_call_realloc(ptr, size)
  void *ptr;
  unsigned size;
{
  return ALIN(void, (char *) realloc((char *) ptr, size));
}
#endif

/* stops "lint" complaints about free() */

#ifdef lint
PUBLIC void
_call_free(ptr)
  void *ptr;
{
  (void) free((char *) ptr);
}
#endif
