/***********************************************************************
     "glad.o": General Language to Annotate Data.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: glad.c,v $
 * Revision 1.3  1994/11/08  13:48:56  lotos
 * ported to djgpp
 *
 * Revision 1.2  1993/03/24  17:45:23  lotos
 * new option -s
 *
 * Revision 1.1  1993/03/18  11:14:24  lotos
 * Initial revision
 *
 ***********************************/

#include "version.h"
#ifndef lint
static char rcsid[]= "$Id: glad.c,v 1.3 1994/11/08 13:48:56 lotos Exp $";
#endif

#define glad_IMP

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "glad.hh"
#include "support.hh"
#include "process.hh"


/* writes program usage */

PRIVATE void
usage ()
{
  (void) fprintf(stderr, "usage: %s", prog_name);
  (void) fprintf(stderr, " [ -h ]");
  (void) fprintf(stderr, " [ -n ]");
  (void) fprintf(stderr, " [ -d ]");
  (void) fprintf(stderr, " [ -s ]");
  (void) fprintf(stderr, " [ -pfile [ -f ] [ -l ] ]");
  (void) fprintf(stderr, " file");
  (void) fprintf(stderr, "\n");
}

/* writes program help */

PRIVATE void
help ()
{
  usage();
  (void) fprintf(stderr, "       -h        this help message\n");
  (void) fprintf(stderr, "       -n        no input specification\n");
  (void) fprintf(stderr, "       -d        draws template tree\n");
  (void) fprintf(stderr, "       -s        ");
  (void) fprintf(stderr, "symbolic, nothing is external\n");
  (void) fprintf(stderr, "       -pfile    ");
  (void) fprintf(stderr, "pretty-prints results into file\n");
  (void) fprintf(stderr, "       -f        ");
  (void) fprintf(stderr, "uses flattened results to pretty-print\n");
  (void) fprintf(stderr, "       -l        ");
  (void) fprintf(stderr, "adds source lines to pretty-printing\n");
  (void) fprintf(stderr, "       file      source file\n");
}

/* processes command line arguments */

PRIVATE void
proc_arg (argc, argv)
  int argc;
  char *argv[];
{
  int any_error= FALSE;
  int i, j;

  prog_name= strrchr(argv[0], '/');
  if (prog_name == NULL)
    prog_name= argv[0];
  else
    ++prog_name;
  for (i= 1; !any_error && i < argc; ++i)
    if (argv[i][j= 0] == '-')
      switch (argv[i][++j])
      { case 'h':
	  prog_flag.put_help= TRUE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	case 'n':
	  prog_flag.proc_spec= FALSE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	case 'd':
	  prog_flag.draw_tplt= TRUE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	case 's':
	  prog_flag.ign_extn= TRUE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	case 'p':
	  if (argv[i][++j] == '\0')
	    any_error= TRUE;
	  else
	    prog_flag.prt_file= &argv[i][j];
	  break;
	case 'f':
	  prog_flag.prt_flat= TRUE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	case 'l':
	  prog_flag.prt_from= TRUE;
	  if (argv[i][++j] != '\0')
	    any_error= TRUE;
	  break;
	default:
	  any_error= TRUE;
	  break;
      }
    else if (prog_flag.src_file == NULL)
      prog_flag.src_file= argv[i];
    else
      any_error= TRUE;
  if (!prog_flag.proc_spec)
  { if (prog_flag.prt_file != NULL)
      any_error= TRUE;
  }
  if (prog_flag.prt_file == NULL)
  { if (prog_flag.prt_flat)
      any_error= TRUE;
    if (prog_flag.prt_from)
      any_error= TRUE;
  }
  if (!prog_flag.put_help)
  { if (prog_flag.src_file == NULL)
      any_error= TRUE;
  }
  if (any_error)
  { usage();
    exit(2);
  }
  if (prog_flag.put_help)
  { help();
    exit(0);
  }
}

/* KJT 20/01/23: added "int" type" */
int main(argc, argv)
  int argc;
  char *argv[];
{
  int errcnt= 0;

  proc_arg(argc, argv);
  xtart();
  if (prog_flag.proc_spec)
    errcnt+= build_spec();
  errcnt+= build_tplt();
  if (errcnt == 0)
  { if (prog_flag.proc_spec)
    { errcnt+= apply_tplt();
      errcnt+= proc_spec();
      if (errcnt == 0)
	save_spec();
      if (prog_flag.prt_file != NULL)
	print_spec();
    }
  }
  if (prog_flag.draw_tplt)
    draw_tplt();
  stop(errcnt);
  return 0;
}
