#ifndef input_HH
#define input_HH

#define PUBLIC
#define PRIVATE static

/***********************************************************************
     "input.hh": basic INPUT functions.
***********************************************************************/

/***********************************
  (C) Copyright 1992-1993; dit/upm
   Distributed under the conditions stated in the
   TOPO General Public License (see file LICENSE)
 ***********************************
 $Log: input.desc,v $
 * Revision 1.1  1993/03/18  11:14:24  lotos
 * Initial revision
 *
 ***********************************/


/* input status */
typedef enum { IBGN, IRUN, ICLR, ISTP, IEND } eIST;

typedef struct
{ char *chr;
  int ndx;
  int size;
  int level;
  char stop;
  eIST stat;
  FILE *fp;
} sILB;	/* input line buffer structure */

/* input line buffer (you mustn't use it) */
#ifndef input_IMP
extern	sILB _ILB;
#else
/* KJT 18/05/02: removed non-constant initialisation: was ... IBGN, stdin */
	sILB _ILB= { NULL, 0, 0, 0, '\0', IBGN, NULL };
#endif

/* initializes the input line buffer */

void	ILBinit ();

/* clears the input line buffer */

void	ILBclear ();

/* fills the input line buffer, or return FALSE if cannot */

int	ILBfill ();

/* returns current character in input line buffer */

#define ILBchar()			\
	  eval_if(_ILB.stat == IRUN,	\
		  _ILB.chr[_ILB.ndx])

/* returns current pointer in input line buffer */

#define ILBpoint()			\
	  eval_if(_ILB.stat == IRUN,	\
		  _ILB.chr + _ILB.ndx)

/* returns next character in input line buffer */

#define ILBnext(incr)				\
	  eval_if(_ILB.stat == IRUN,		\
		  _ILB.chr[_ILB.ndx + (incr)])

/* goes forth in input line buffer and returns the position */

#define ILBforth(incr)			\
	  eval_if(_ILB.stat == IRUN,	\
		  _ILB.ndx+= (incr))

/* stops input line buffer temporally */

#define ILBstop()					\
	  eval_if(_ILB.stat == IRUN,			\
		  (_ILB.stop= _ILB.chr[_ILB.ndx],	\
		   _ILB.chr[_ILB.ndx]= '\0',		\
		   _ILB.stat= ISTP))

/* continues temporally stoped input line buffer */

#define ILBcont()					\
	  eval_if(_ILB.stat == ISTP,			\
		  (_ILB.chr[_ILB.ndx]= _ILB.stop,	\
		   _ILB.stop= '\0',			\
		   _ILB.stat= IRUN))
#endif
